/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.deployment;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.dal.CopyToEnvironment;
import org.craftercms.studio.api.v1.dal.CopyToEnvironmentMapper;
import org.craftercms.studio.api.v1.dal.ObjectMetadata;
import org.craftercms.studio.api.v1.dal.PublishToTarget;
import org.craftercms.studio.api.v1.deployment.Deployer;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.dependency.DmDependencyService;
import org.craftercms.studio.api.v1.service.deployment.ContentNotFoundForPublishingException;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.service.deployment.DeploymentService;
import org.craftercms.studio.api.v1.service.deployment.PublishingManager;
import org.craftercms.studio.api.v1.service.deployment.UploadFailedException;
import org.craftercms.studio.api.v1.service.notification.NotificationService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.objectstate.TransitionEvent;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.DeploymentEndpointConfigTO;
import org.craftercms.studio.impl.v1.deployment.DeployerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PublishingManagerImpl
implements PublishingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublishingManagerImpl.class);
    private static final String TARGET_REQUEST_PARAMETER = "target";
    private static final String VERSION_REQUEST_PARAMETER = "version";
    private static final String PASSWORD_REQUEST_PARAMETER = "password";
    private static final String SITE_REQUEST_PARAMETER = "siteId";
    private static final String DELETED_FILES_REQUEST_PARAMETER = "deletedFiles";
    private static final String CONTENT_LOCATION_REQUEST_PARAMETER = "contentLocation";
    private static final String CONTENT_FILE_REQUEST_PARAMETER = "contentFile";
    private static final String METADATA_FILE_REQUEST_PARAMETER = "metadataFile";
    private static final String FILES_SEPARATOR = ",";
    private static final String LIVE_ENVIRONMENT = "live";
    private static final String PRODUCTION_ENVIRONMENT = "Production";
    private static final String WORK_AREA_ENVIRONMENT = "work-area";
    protected String indexFile;
    protected boolean importModeEnabled;
    protected SiteService siteService;
    protected ObjectStateService objectStateService;
    protected ContentService contentService;
    protected DmDependencyService dmDependencyService;
    protected DeploymentService deploymentService;
    protected String environmentsStoreRootPath;
    protected DeployerFactory deployerFactory;
    protected ContentRepository contentRepository;
    protected ObjectMetadataManager objectMetadataManager;
    protected NotificationService notificationService;
    @Autowired
    protected CopyToEnvironmentMapper copyToEnvironmentMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkConnection(DeploymentEndpointConfigTO target) {
        boolean connOk = false;
        if (target.getStatusUrl() != null && !target.getStatusUrl().isEmpty()) {
            LOGGER.debug(String.format("Check deployment agent status for target ", target.getName()), new Object[0]);
            URL statusUrl = null;
            try {
                statusUrl = new URL(target.getStatusUrl());
            }
            catch (MalformedURLException e) {
                LOGGER.error(String.format("Invalid endpoint status URL for publishing channel [%s]", target.getName()), e, new Object[0]);
            }
            GetMethod getMethod = null;
            HttpClient client = null;
            try {
                getMethod = new GetMethod(target.getStatusUrl());
                client = new HttpClient();
                int status = client.executeMethod((HttpMethod)getMethod);
                if (status == 200) {
                    connOk = true;
                }
            }
            catch (Exception e) {
                LOGGER.error(String.format("Target (%s) is not available. Status check failed for url %s", target.getName(), target.getStatusUrl()), new Object[0]);
            }
            finally {
                HttpConnectionManager mgr;
                if (client != null && (mgr = client.getHttpConnectionManager()) instanceof SimpleHttpConnectionManager) {
                    ((SimpleHttpConnectionManager)mgr).shutdown();
                }
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
                getMethod = null;
                client = null;
            }
        }
        return connOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTargetVersion(DeploymentEndpointConfigTO target, String site) {
        long version = -1L;
        if (target.getVersionUrl() != null && !target.getVersionUrl().isEmpty()) {
            LOGGER.debug(String.format("Get deployment agent version for target ", target.getName()), new Object[0]);
            URL versionUrl = null;
            try {
                versionUrl = new URL(target.getVersionUrl());
            }
            catch (MalformedURLException e) {
                LOGGER.error(String.format("Invalid get version URL for target [%s]", target.getName()), e, new Object[0]);
            }
            GetMethod getMethod = null;
            HttpClient client = null;
            try {
                getMethod = new GetMethod(target.getVersionUrl());
                String siteId = target.getSiteId();
                if (StringUtils.isEmpty((String)siteId)) {
                    siteId = site;
                }
                getMethod.setQueryString(new NameValuePair[]{new NameValuePair(TARGET_REQUEST_PARAMETER, target.getTarget()), new NameValuePair(SITE_REQUEST_PARAMETER, siteId)});
                client = new HttpClient();
                int status = client.executeMethod((HttpMethod)getMethod);
                if (status == 200) {
                    InputStream responseStream = getMethod.getResponseBodyAsStream();
                    String responseText = IOUtils.toString((InputStream)responseStream);
                    version = responseText != null && !responseText.isEmpty() ? Long.parseLong(responseText.trim()) : 0L;
                }
            }
            catch (Exception mgr) {
            }
            finally {
                if (client != null && (mgr = client.getHttpConnectionManager()) instanceof SimpleHttpConnectionManager) {
                    ((SimpleHttpConnectionManager)mgr).shutdown();
                }
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
                getMethod = null;
                client = null;
            }
        }
        return version;
    }

    @Override
    public List<PublishToTarget> getItemsToSync(String site, long targetVersion, List<String> environments) {
        return this.deploymentService.getItemsToSync(site, targetVersion, environments);
    }

    @Override
    public void deployItemsToTarget(String site, List<PublishToTarget> filteredItems, DeploymentEndpointConfigTO target) throws ContentNotFoundForPublishingException, UploadFailedException {
        LOGGER.debug("Start deploying items for site \"{0}\", target \"{1}\", number of items \"{2}\"", site, target.getName(), filteredItems.size());
        int numberOfBuckets = filteredItems.size() / target.getBucketSize() + 1;
        String environment = filteredItems.get(0).getEnvironment();
        Iterator<PublishToTarget> iter = filteredItems.iterator();
        LOGGER.debug("Divide all deployment items into {0} bucket(s) for  target {1}", numberOfBuckets, target.getName());
        for (int bucketIndex = 0; bucketIndex < numberOfBuckets; ++bucketIndex) {
            int cntFiles = 0;
            String siteId = target.getSiteId();
            if (StringUtils.isEmpty((String)siteId)) {
                siteId = site;
            }
            LOGGER.debug("Preparing deployment items (bucket {0}) for target {1}", bucketIndex + 1, target.getName());
            int loopSize = filteredItems.size() - bucketIndex * target.getBucketSize() > target.getBucketSize() ? target.getBucketSize() : filteredItems.size() - bucketIndex * target.getBucketSize();
            ArrayList<String> filesToDeploy = new ArrayList<String>();
            ArrayList<String> deletedFiles = new ArrayList<String>();
            for (int j = 0; j < loopSize; ++j) {
                RepositoryItem[] children;
                String folderPath;
                String fullPath;
                if (!iter.hasNext()) continue;
                PublishToTarget item = iter.next();
                LOGGER.debug("Parsing \"{0}\" , site \"{1}\"; for publishing on target \"{2}\"", item.getPath(), item.getSite(), target.getName());
                if (StringUtils.equals((String)item.getAction(), (String)"DELETE")) {
                    deletedFiles.add(item.getPath());
                    if (item.getPath().endsWith("/" + this.indexFile)) {
                        fullPath = this.contentService.expandRelativeSitePath(item.getSite(), item.getPath().replace("/index.xml", ""));
                        folderPath = item.getPath().replace("/" + this.indexFile, "");
                        if (this.contentRepository.contentExists(fullPath)) {
                            children = this.contentRepository.getContentChildren(fullPath);
                            if (children.length < 2) {
                                deletedFiles.add(folderPath);
                            }
                        } else {
                            deletedFiles.add(folderPath);
                        }
                    }
                } else {
                    filesToDeploy.add(item.getPath());
                    if (StringUtils.equals((String)item.getAction(), (String)"MOVE") && item.getOldPath() != null && !item.getOldPath().equalsIgnoreCase(item.getPath())) {
                        LOGGER.debug("Add old path to be deleted for MOVE action (\"{0}\")", item.getOldPath());
                        deletedFiles.add(item.getOldPath());
                        if (item.getOldPath().endsWith("/" + this.indexFile)) {
                            fullPath = this.contentService.expandRelativeSitePath(item.getSite(), item.getOldPath().replace("/index.xml", ""));
                            folderPath = item.getOldPath().replace("/" + this.indexFile, "");
                            if (this.contentRepository.contentExists(fullPath)) {
                                children = this.contentRepository.getContentChildren(fullPath);
                                if (children.length < 2) {
                                    deletedFiles.add(folderPath);
                                }
                            } else {
                                deletedFiles.add(folderPath);
                            }
                        }
                    }
                }
                ++cntFiles;
            }
            Deployer deployer = this.deployerFactory.createSyncTargetDeployer(environment, target);
            try {
                deployer.deployFiles(site, filesToDeploy, deletedFiles);
                continue;
            }
            catch (ContentNotFoundForPublishingException e) {
                LOGGER.error("Deployment failed for bucket number {0} on target {1}.", bucketIndex + 1, target.getName());
                throw e;
            }
            catch (UploadFailedException e) {
                LOGGER.error("Deployment failed for bucket number {0} on target {1}.", bucketIndex + 1, target.getName());
                throw e;
            }
        }
        LOGGER.debug("Publishing deployment event for target \"{0}\" with \"{1}\" items.", target.getName(), 0);
        LOGGER.info("Deployment successful on target {0}", target.getName());
        LOGGER.debug("Finished deploying items for site \"{0}\", target \"{1}\", number of items \"{2}\"", site, target.getName(), filteredItems.size());
    }

    private String getDestinationPath(String site, String path, String environment) {
        return String.format("%s/%s/%s/%s", this.environmentsStoreRootPath, site, environment, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long setTargetVersion(DeploymentEndpointConfigTO target, long newVersion, String site) {
        long resoponseVersion = -1L;
        if (target.getVersionUrl() != null && !target.getVersionUrl().isEmpty()) {
            LOGGER.debug("Set deployment agent version for target {0}", target.getName());
            URL versionUrl = null;
            try {
                versionUrl = new URL(target.getVersionUrl());
            }
            catch (MalformedURLException e) {
                LOGGER.error("Invalid set version URL for target [%s]", target.getName());
                return resoponseVersion;
            }
            PostMethod postMethod = null;
            HttpClient client = null;
            try {
                postMethod = new PostMethod(target.getVersionUrl());
                postMethod.addParameter(TARGET_REQUEST_PARAMETER, target.getTarget());
                postMethod.addParameter(VERSION_REQUEST_PARAMETER, String.valueOf(newVersion));
                String siteId = target.getSiteId();
                if (StringUtils.isEmpty((String)siteId)) {
                    siteId = site;
                }
                postMethod.addParameter(SITE_REQUEST_PARAMETER, site);
                client = new HttpClient();
                int status = client.executeMethod((HttpMethod)postMethod);
                if (status == 200) {
                    InputStream responseStream = postMethod.getResponseBodyAsStream();
                    String responseText = IOUtils.toString((InputStream)responseStream);
                    resoponseVersion = responseText != null && !responseText.isEmpty() ? Long.parseLong(responseText) : 0L;
                }
            }
            catch (Exception e) {
                LOGGER.error("Target {0} responded with error while setting target version. Set version failed for url {1}", target.getName(), target.getVersionUrl());
            }
            finally {
                HttpConnectionManager mgr;
                if (client != null && (mgr = client.getHttpConnectionManager()) instanceof SimpleHttpConnectionManager) {
                    ((SimpleHttpConnectionManager)mgr).shutdown();
                }
                if (postMethod != null) {
                    postMethod.releaseConnection();
                }
                postMethod = null;
                client = null;
            }
        }
        return resoponseVersion;
    }

    @Override
    public List<CopyToEnvironment> getItemsReadyForDeployment(String site, String environment) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("state", "READY_FOR_LIVE");
        params.put("environment", environment);
        params.put("now", new Date());
        return this.copyToEnvironmentMapper.getItemsReadyForDeployment(params);
    }

    @Override
    public void processItem(CopyToEnvironment item) throws DeploymentException {
        String liveEnvironment = this.siteService.getLiveEnvironmentName(item.getSite());
        boolean isLive = false;
        if (StringUtils.isNotEmpty((String)liveEnvironment)) {
            if (liveEnvironment.equals(item.getEnvironment())) {
                isLive = true;
            }
        } else if (LIVE_ENVIRONMENT.equalsIgnoreCase(item.getEnvironment()) || PRODUCTION_ENVIRONMENT.equalsIgnoreCase(item.getEnvironment())) {
            isLive = true;
        }
        if (StringUtils.equals((String)item.getAction(), (String)"DELETE")) {
            RepositoryItem[] children;
            String fullPath;
            Deployer deployer = this.deployerFactory.createEnvironmentStoreDeployer(item.getEnvironment());
            if (item.getOldPath() != null && item.getOldPath().length() > 0) {
                this.contentService.deleteContent(item.getSite(), item.getOldPath(), item.getUser());
                boolean hasRenamedChildren = false;
                deployer.deleteFile(item.getSite(), item.getOldPath());
                if (item.getOldPath().endsWith("/index.xml")) {
                    fullPath = this.contentService.expandRelativeSitePath(item.getSite(), item.getOldPath().replace("/index.xml", ""));
                    children = this.contentRepository.getContentChildren(fullPath);
                    if (children.length < 2) {
                        deployer.deleteFile(item.getSite(), item.getOldPath().replace("/index.xml", ""));
                    } else {
                        hasRenamedChildren = true;
                    }
                    if (!hasRenamedChildren) {
                        this.contentService.deleteContent(item.getSite(), item.getOldPath().replace("/index.xml", ""), false, item.getUser());
                    }
                }
                this.objectMetadataManager.clearRenamed(item.getSite(), item.getPath());
            }
            boolean haschildren = false;
            deployer.deleteFile(item.getSite(), item.getPath());
            if (item.getPath().endsWith("/index.xml")) {
                fullPath = this.contentService.expandRelativeSitePath(item.getSite(), item.getPath().replace("/index.xml", ""));
                children = this.contentRepository.getContentChildren(fullPath);
                if (children.length < 2) {
                    deployer.deleteFile(item.getSite(), item.getPath().replace("/index.xml", ""));
                } else {
                    haschildren = true;
                }
            }
            if (isLive) {
                this.contentService.deleteContent(item.getSite(), item.getPath(), item.getUser());
                if (!haschildren) {
                    this.contentService.deleteContent(item.getSite(), item.getPath().replace("/index.xml", ""), false, item.getUser());
                }
            }
        } else {
            boolean sendEmail;
            Deployer deployer;
            LOGGER.debug("Setting system processing for {0}:{1}", item.getSite(), item.getPath());
            this.objectStateService.setSystemProcessing(item.getSite(), item.getPath(), true);
            if (isLive) {
                if (!this.importModeEnabled) {
                    this.contentRepository.createVersion(this.contentService.expandRelativeSitePath(item.getSite(), item.getPath()), true);
                } else {
                    LOGGER.debug("Import mode is ON. Create new version is skipped for [{0}] site \"{1}\"", item.getPath(), item.getSite());
                }
            }
            if (StringUtils.equals((String)item.getAction(), (String)"MOVE") && item.getOldPath() != null && item.getOldPath().length() > 0) {
                deployer = this.deployerFactory.createEnvironmentStoreDeployer(item.getEnvironment());
                deployer.deleteFile(item.getSite(), item.getOldPath());
                if (item.getOldPath().endsWith("/index.xml")) {
                    boolean hasRenamedChildren = false;
                    String fullPath = this.contentService.expandRelativeSitePath(item.getSite(), item.getOldPath().replace("/index.xml", ""));
                    RepositoryItem[] children = this.contentRepository.getContentChildren(fullPath);
                    if (children.length < 2) {
                        deployer.deleteFile(item.getSite(), item.getOldPath().replace("/index.xml", ""));
                    } else {
                        hasRenamedChildren = true;
                    }
                    if (!hasRenamedChildren) {
                        this.contentService.deleteContent(item.getSite(), item.getOldPath().replace("/index.xml", ""), false, item.getUser());
                    }
                }
                if (isLive) {
                    this.objectMetadataManager.clearRenamed(item.getSite(), item.getPath());
                }
            }
            LOGGER.debug("Getting deployer for environment store.", new Object[0]);
            deployer = this.deployerFactory.createEnvironmentStoreDeployer(item.getEnvironment());
            deployer.deployFile(item.getSite(), item.getPath());
            ObjectMetadata objectMetadata = this.objectMetadataManager.getProperties(item.getSite(), item.getPath());
            if (objectMetadata == null) {
                this.objectMetadataManager.insertNewObjectMetadata(item.getSite(), item.getPath());
                objectMetadata = this.objectMetadataManager.getProperties(item.getSite(), item.getPath());
            }
            boolean bl = sendEmail = objectMetadata.getSendEmail() == 1;
            if (sendEmail) {
                String submittedByValue = objectMetadata.getSubmittedBy();
                this.notificationService.sendApprovalNotification(item.getSite(), submittedByValue, item.getPath(), item.getUser());
            }
            if (isLive) {
                ContentItemTO contentItem = this.contentService.getContentItem(item.getSite(), item.getPath());
                this.objectStateService.transition(item.getSite(), contentItem, TransitionEvent.DEPLOYMENT);
            }
            LOGGER.debug("Resetting system processing for {0}:{1}", item.getSite(), item.getPath());
            this.objectStateService.setSystemProcessing(item.getSite(), item.getPath(), false);
        }
    }

    @Override
    public void setLockBehaviourEnabled(boolean enabled) {
    }

    @Override
    public void setupItemsForPublishingSync(String site, String environment, List<CopyToEnvironment> itemsToDeploy) throws DeploymentException {
        this.deploymentService.setupItemsForPublishingSync(site, environment, itemsToDeploy);
    }

    @Override
    public void insertDeploymentHistory(DeploymentEndpointConfigTO target, List<PublishToTarget> publishedItems, Date publishingDate) throws DeploymentException {
        this.deploymentService.insertDeploymentHistory(target, publishedItems, publishingDate);
    }

    @Override
    public void markItemsCompleted(String site, String environment, List<CopyToEnvironment> processedItems) throws DeploymentException {
        for (CopyToEnvironment item : processedItems) {
            item.setState("COMPLETED");
            this.copyToEnvironmentMapper.updateItemDeploymentState(item);
        }
    }

    @Override
    public void markItemsProcessing(String site, String environment, List<CopyToEnvironment> itemsToDeploy) throws DeploymentException {
        for (CopyToEnvironment item : itemsToDeploy) {
            item.setState("PROCESSING");
            this.copyToEnvironmentMapper.updateItemDeploymentState(item);
        }
    }

    @Override
    public void markItemsReady(String site, String environment, List<CopyToEnvironment> copyToEnvironmentItems) throws DeploymentException {
        for (CopyToEnvironment item : copyToEnvironmentItems) {
            item.setState("READY_FOR_LIVE");
            this.copyToEnvironmentMapper.updateItemDeploymentState(item);
        }
    }

    @Override
    public List<CopyToEnvironment> processMandatoryDependencies(CopyToEnvironment item, List<String> pathsToDeploy, Set<String> missingDependenciesPaths) throws DeploymentException {
        ArrayList<CopyToEnvironment> mandatoryDependencies = new ArrayList<CopyToEnvironment>();
        String site = item.getSite();
        String path = item.getPath();
        if (StringUtils.equals((String)item.getAction(), (String)"NEW") || StringUtils.equals((String)item.getAction(), (String)"MOVE")) {
            String parentFullPath;
            int idx;
            String helpPath = path.replace("/" + this.indexFile, "");
            String parentPath = helpPath.substring(0, idx = helpPath.lastIndexOf("/")) + "/" + this.indexFile;
            if (this.objectStateService.isNew(site, parentPath) && !missingDependenciesPaths.contains(parentFullPath = this.contentService.expandRelativeSitePath(site, parentPath)) && !pathsToDeploy.contains(parentFullPath)) {
                this.deploymentService.cancelWorkflow(site, parentPath);
                missingDependenciesPaths.add(parentFullPath);
                CopyToEnvironment parentItem = this.createMissingItem(site, parentPath, item);
                this.processItem(parentItem);
                mandatoryDependencies.add(parentItem);
                mandatoryDependencies.addAll(this.processMandatoryDependencies(parentItem, pathsToDeploy, missingDependenciesPaths));
            }
            List<String> dependentPaths = this.dmDependencyService.getDependencyPaths(site, path);
            for (String dependentPath : dependentPaths) {
                String dependentFullPath;
                if (!this.objectStateService.isNew(site, dependentPath) || missingDependenciesPaths.contains(dependentFullPath = this.contentService.expandRelativeSitePath(site, dependentPath)) || pathsToDeploy.contains(dependentFullPath)) continue;
                this.deploymentService.cancelWorkflow(site, dependentPath);
                missingDependenciesPaths.add(dependentFullPath);
                CopyToEnvironment dependentItem = this.createMissingItem(site, dependentPath, item);
                this.processItem(dependentItem);
                mandatoryDependencies.add(dependentItem);
                mandatoryDependencies.addAll(this.processMandatoryDependencies(dependentItem, pathsToDeploy, missingDependenciesPaths));
            }
        }
        return mandatoryDependencies;
    }

    private CopyToEnvironment createMissingItem(String site, String itemPath, CopyToEnvironment item) {
        ObjectMetadata metadata;
        CopyToEnvironment missingItem = new CopyToEnvironment();
        missingItem.setSite(site);
        missingItem.setEnvironment(item.getEnvironment());
        missingItem.setPath(itemPath);
        missingItem.setScheduledDate(item.getScheduledDate());
        missingItem.setState(item.getState());
        if (this.objectStateService.isNew(site, itemPath)) {
            missingItem.setAction("NEW");
        }
        if ((metadata = this.objectMetadataManager.getProperties(site, itemPath)) != null && metadata.getRenamed() != 0) {
            String oldPath = metadata.getOldUrl();
            missingItem.setOldPath(oldPath);
            missingItem.setAction("MOVE");
        }
        String contentTypeClass = this.contentService.getContentTypeClass(site, itemPath);
        missingItem.setContentTypeClass(contentTypeClass);
        missingItem.setUser(item.getUser());
        missingItem.setSubmissionComment(item.getSubmissionComment());
        return missingItem;
    }

    public String getIndexFile() {
        return this.indexFile;
    }

    public void setIndexFile(String indexFile) {
        this.indexFile = indexFile;
    }

    public boolean isImportModeEnabled() {
        return this.importModeEnabled;
    }

    public void setImportModeEnabled(boolean importModeEnabled) {
        this.importModeEnabled = importModeEnabled;
        LOGGER.info("Import mode is {0}. Creating new version when deploying content is {1}", importModeEnabled ? "ON" : "OFF", importModeEnabled ? "DISABLED" : "ENABLED");
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public DmDependencyService getDmDependencyService() {
        return this.dmDependencyService;
    }

    public void setDmDependencyService(DmDependencyService dmDependencyService) {
        this.dmDependencyService = dmDependencyService;
    }

    public DeploymentService getDeploymentService() {
        return this.deploymentService;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public String getEnvironmentsStoreRootPath() {
        return this.environmentsStoreRootPath;
    }

    public void setEnvironmentsStoreRootPath(String environmentsStoreRootPath) {
        this.environmentsStoreRootPath = environmentsStoreRootPath;
    }

    public DeployerFactory getDeployerFactory() {
        return this.deployerFactory;
    }

    public void setDeployerFactory(DeployerFactory deployerFactory) {
        this.deployerFactory = deployerFactory;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }
}

