/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.deployment.job;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.UserTransaction;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.dal.CopyToEnvironment;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.service.deployment.PublishingManager;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.service.transaction.TransactionService;
import org.craftercms.studio.api.v1.to.PublishingChannelGroupConfigTO;
import org.craftercms.studio.api.v1.util.ListUtils;
import org.craftercms.studio.impl.v1.job.RepositoryJob;

public class DeployContentToEnvironmentStore
extends RepositoryJob {
    private static final Logger logger = LoggerFactory.getLogger(DeployContentToEnvironmentStore.class);
    private static final String LIVE_ENVIRONMENT = "live";
    protected static final ReentrantLock singleWorkerLock = new ReentrantLock();
    private static boolean stopSignaled = false;
    private static boolean running = false;
    protected TransactionService transactionService;
    protected PublishingManager publishingManager;
    protected ContentRepository contentRepository;
    protected int processingChunkSize;
    protected boolean masterPublishingNode;
    protected boolean mandatoryDependenciesCheckEnabled;
    protected SiteService siteService;
    protected ContentService contentService;

    public static synchronized void signalToStop(boolean toStop) {
        stopSignaled = toStop;
    }

    public static synchronized boolean isRunning() {
        return running;
    }

    public static synchronized void setRunning(boolean isRunning) {
        running = isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAsSignedInUser() {
        if (this.masterPublishingNode && !stopSignaled) {
            DeployContentToEnvironmentStore.setRunning(true);
            if (singleWorkerLock.tryLock()) {
                try {
                    this.processJobs();
                }
                catch (Throwable err) {
                    logger.error("unable to execute job", err);
                }
                finally {
                    singleWorkerLock.unlock();
                }
            }
            DeployContentToEnvironmentStore.setRunning(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processJobs() {
        try {
            UserTransaction tx = this.transactionService.getTransaction();
            try {
                Set<String> siteNames = this.siteService.getAllAvailableSites();
                if (siteNames != null && siteNames.size() > 0) {
                    for (String site : siteNames) {
                        Set<String> environments = this.getAllPublishingEnvironments(site);
                        for (String environment : environments) {
                            logger.debug("Processing content ready for deployment for site \"{0}\"", site);
                            List<CopyToEnvironment> itemsToDeploy = this.publishingManager.getItemsReadyForDeployment(site, environment);
                            List<String> pathsToDeploy = this.getPaths(itemsToDeploy);
                            HashSet<String> missingDependenciesPaths = new HashSet<String>();
                            if (itemsToDeploy == null || itemsToDeploy.size() <= 0) continue;
                            logger.debug("Site \"{0}\" has {1} items ready for deployment", site, itemsToDeploy.size());
                            logger.debug("Splitting items into chunks for processing", site, itemsToDeploy.size());
                            List<List<CopyToEnvironment>> chunks = ListUtils.partition(itemsToDeploy, this.processingChunkSize);
                            for (int i = 0; i < chunks.size(); ++i) {
                                List<CopyToEnvironment> itemList = chunks.get(i);
                                ArrayList<CopyToEnvironment> missingDependencies = new ArrayList<CopyToEnvironment>();
                                for (CopyToEnvironment item : itemList) {
                                    this.contentRepository.lockItem(item.getSite(), item.getPath());
                                }
                                try {
                                    logger.debug("Mark items as processing for site \"{0}\"", site);
                                    this.publishingManager.markItemsProcessing(site, environment, itemList);
                                    for (CopyToEnvironment item : itemList) {
                                        this.contentRepository.lockItem(item.getSite(), item.getPath());
                                        try {
                                            logger.debug("Processing [{0}] content item for site \"{1}\"", item.getPath(), site);
                                            this.publishingManager.processItem(item);
                                            if (!this.mandatoryDependenciesCheckEnabled) continue;
                                            missingDependencies.addAll(this.publishingManager.processMandatoryDependencies(item, pathsToDeploy, missingDependenciesPaths));
                                        }
                                        finally {
                                            this.contentRepository.unLockItem(item.getSite(), item.getPath());
                                        }
                                    }
                                    logger.debug("Setting up items for publishing synchronization for site \"{0}\"", site);
                                    if (this.mandatoryDependenciesCheckEnabled && missingDependencies.size() > 0) {
                                        ArrayList<CopyToEnvironment> mergedList = new ArrayList<CopyToEnvironment>(itemList);
                                        mergedList.addAll(missingDependencies);
                                        this.publishingManager.setupItemsForPublishingSync(site, environment, mergedList);
                                    } else {
                                        this.publishingManager.setupItemsForPublishingSync(site, environment, itemList);
                                    }
                                    logger.debug("Mark deployment completed for processed items for site \"{0}\"", site);
                                    this.publishingManager.markItemsCompleted(site, environment, itemList);
                                    continue;
                                }
                                catch (DeploymentException err) {
                                    logger.error("Error while executing deployment to environment store for site \"{0}\", number of items \"{1}\", chunk number \"{2}\" (chunk size {3})", err, site, itemsToDeploy.size(), i, this.processingChunkSize);
                                    this.publishingManager.markItemsReady(site, environment, itemList);
                                    throw err;
                                }
                                catch (Exception err) {
                                    logger.error("Unexpected error while executing deployment to environment store for site \"{0}\", number of items \"{1}\", chunk number \"{2}\" (chunk size {3})", err, site, itemsToDeploy.size(), i, this.processingChunkSize);
                                    this.publishingManager.markItemsReady(site, environment, itemList);
                                    throw err;
                                }
                                finally {
                                    for (CopyToEnvironment item : itemList) {
                                        this.contentRepository.unLockItem(item.getSite(), item.getPath());
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception err) {
                logger.error("Error while executing deployment to environment store", err, new Object[0]);
            }
        }
        catch (Exception err) {
            logger.error("Error while executing deployment to environment store", err, new Object[0]);
        }
    }

    private List<String> getPaths(List<CopyToEnvironment> itemsToDeploy) {
        ArrayList<String> paths = new ArrayList<String>(itemsToDeploy.size());
        if (this.mandatoryDependenciesCheckEnabled) {
            for (CopyToEnvironment item : itemsToDeploy) {
                paths.add(this.contentService.expandRelativeSitePath(item.getSite(), item.getPath()));
            }
        }
        return paths;
    }

    private Set<String> getAllPublishingEnvironments(String site) {
        Map<String, PublishingChannelGroupConfigTO> groupConfigTOs = this.siteService.getPublishingChannelGroupConfigs(site);
        HashSet<String> environments = new HashSet<String>();
        if (groupConfigTOs != null && groupConfigTOs.size() > 0) {
            for (PublishingChannelGroupConfigTO groupConfigTO : groupConfigTOs.values()) {
                if (!StringUtils.isNotEmpty((String)groupConfigTO.getName())) continue;
                environments.add(groupConfigTO.getName());
            }
        }
        return environments;
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    public void setTransactionService(TransactionService service) {
        this.transactionService = service;
    }

    public PublishingManager getPublishingManager() {
        return this.publishingManager;
    }

    public void setPublishingManager(PublishingManager publishingManager) {
        this.publishingManager = publishingManager;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public int getProcessingChunkSize() {
        return this.processingChunkSize;
    }

    public void setProcessingChunkSize(int processingChunkSize) {
        this.processingChunkSize = processingChunkSize;
    }

    public boolean isMasterPublishingNode() {
        return this.masterPublishingNode;
    }

    public void setMasterPublishingNode(boolean masterPublishingNode) {
        this.masterPublishingNode = masterPublishingNode;
    }

    public boolean isMandatoryDependenciesCheckEnabled() {
        return this.mandatoryDependenciesCheckEnabled;
    }

    public void setMandatoryDependenciesCheckEnabled(boolean mandatoryDependenciesCheckEnabled) {
        this.mandatoryDependenciesCheckEnabled = mandatoryDependenciesCheckEnabled;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }
}

