/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.deployment.job;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.craftercms.studio.api.v1.dal.PublishToTarget;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.deployment.ContentNotFoundForPublishingException;
import org.craftercms.studio.api.v1.service.deployment.PublishingManager;
import org.craftercms.studio.api.v1.service.deployment.UploadFailedException;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.DeploymentEndpointConfigTO;
import org.craftercms.studio.api.v1.to.PublishingChannelConfigTO;
import org.craftercms.studio.api.v1.to.PublishingChannelGroupConfigTO;
import org.craftercms.studio.impl.v1.job.RepositoryJob;

public class PublishContentToDeploymentTarget
extends RepositoryJob {
    private static final Logger logger = LoggerFactory.getLogger(PublishContentToDeploymentTarget.class);
    protected static final ReentrantLock singleWorkerLock = new ReentrantLock();
    protected static Map<String, Map<String, Integer>> _publishingFailureCounters = new HashMap<String, Map<String, Integer>>();
    private static boolean stopSignaled = false;
    private static boolean running = false;
    protected Integer maxTolerableRetries;
    protected boolean masterPublishingNode;
    protected SiteService siteService;
    protected PublishingManager publishingManager;

    public static Map<String, Map<String, Integer>> getPublishingRetryCounters() {
        return _publishingFailureCounters;
    }

    public static Map<String, Integer> getPublishingRetryCounters(String site) {
        return _publishingFailureCounters.get(site);
    }

    public static synchronized void signalToStop(boolean toStop) {
        stopSignaled = toStop;
    }

    public static synchronized boolean isRunning() {
        return running;
    }

    public static synchronized void setRunning(boolean isRunning) {
        running = isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAsSignedInUser() {
        if (this.masterPublishingNode && !stopSignaled) {
            PublishContentToDeploymentTarget.setRunning(true);
            if (singleWorkerLock.tryLock()) {
                try {
                    this.processJobs();
                }
                catch (Exception err) {
                    logger.error("unable to execute job", err, new Object[0]);
                }
                finally {
                    singleWorkerLock.unlock();
                }
            }
            PublishContentToDeploymentTarget.setRunning(false);
        }
    }

    public void processJobs() {
        block26: {
            try {
                try {
                    Set<String> siteNames = this.siteService.getAllAvailableSites();
                    if (siteNames == null || siteNames.size() <= 0) break block26;
                    for (String site : siteNames) {
                        logger.debug("Starting publishing for site \"{0}\"", site);
                        Set<DeploymentEndpointConfigTO> targets = this.getAllTargetsForSite(site);
                        for (DeploymentEndpointConfigTO target : targets) {
                            logger.debug("Starting publishing on target \"{0}\", site \"{1}\"", target.getName(), site);
                            if (target.getEnvironments() == null || target.getEnvironments().isEmpty()) continue;
                            if (this.publishingManager.checkConnection(target)) {
                                logger.debug("Getting target version (target: \"{0}\", site: \"{1}\"", target.getName(), site);
                                long targetVersion = this.publishingManager.getTargetVersion(target, site);
                                logger.debug("Target version: \"{0}\" (target: \"{1}\", site: \"{2}\"", targetVersion, target.getName(), site);
                                if (targetVersion != -1L) {
                                    Map<String, Integer> counters;
                                    List<PublishToTarget> syncItems = this.publishingManager.getItemsToSync(site, targetVersion, target.getEnvironments());
                                    if (syncItems != null && syncItems.size() > 0) {
                                        logger.info("publishing \"{0}\" item(s) to \"{1}\" for site \"{2}\"", syncItems.size(), target.getName(), site);
                                        logger.debug("Filtering out items before sending to deployment agent", new Object[0]);
                                        List<PublishToTarget> filteredItems = this.filterItems(syncItems, target);
                                        try {
                                            if (filteredItems != null && filteredItems.size() > 0) {
                                                logger.debug("Sending \"{0}\" items to target \"{1}\", site \"{2}\"", filteredItems.size(), target.getName(), site);
                                                this.publishingManager.deployItemsToTarget(site, filteredItems, target);
                                            }
                                            long newVersion = this.getDeployedVersion(syncItems);
                                            logger.debug("Setting new version for target (target: \"{0}\", site \"{1}\", version \"{2}\"", target.getName(), site, newVersion);
                                            this.publishingManager.setTargetVersion(target, newVersion, site);
                                            logger.debug("Inserting deployment history for \"{0}\" items on target \"{1}\", site \"{2}\"", filteredItems.size(), target.getName(), site);
                                            this.publishingManager.insertDeploymentHistory(target, filteredItems, new Date());
                                        }
                                        catch (UploadFailedException err) {
                                            Integer count;
                                            Map<String, Integer> counters2 = _publishingFailureCounters.get(err.getSite());
                                            if (counters2 == null) {
                                                counters2 = new HashMap<String, Integer>();
                                            }
                                            if ((count = counters2.get(err.getTarget())) == null) {
                                                count = 0;
                                            } else {
                                                Integer n = count;
                                                Integer n2 = count = Integer.valueOf(count + 1);
                                            }
                                            if (count > this.maxTolerableRetries) {
                                                logger.error("Uploading content failed for site \"{0}\", target \"{1}\", URL \"{2}\"", err, err.getSite(), err.getTarget(), err.getUrl());
                                            } else {
                                                logger.warn("Uploading content failed for site \"{0}\", target \"{1}\", URL \"{2}\"", err.getSite(), err.getTarget(), err.getUrl());
                                            }
                                            counters2.put(err.getTarget(), count);
                                            _publishingFailureCounters.put(err.getSite(), counters2);
                                            continue;
                                        }
                                    }
                                    if ((counters = _publishingFailureCounters.get(site)) == null) {
                                        counters = new HashMap<String, Integer>();
                                    }
                                    counters.put(target.getName(), 0);
                                    _publishingFailureCounters.put(site, counters);
                                } else {
                                    logger.error("cannot negotiate a version for deployment agent \"{0}\" for site \"{1}\"", target.getName(), site);
                                }
                            } else {
                                logger.warn("cannot connect to deployment agent \"{0}\" for site \"{1}\"", target.getName(), site);
                            }
                            logger.debug("Finished publishing on target \"{0}\", site \"{1}\"", target.getName(), site);
                        }
                        logger.debug("Finished publishing for site \"{0}\"", site);
                    }
                }
                catch (ContentNotFoundForPublishingException err) {
                    Integer count;
                    Map<String, Integer> counters = _publishingFailureCounters.get(err.getSite());
                    if (counters == null) {
                        counters = new HashMap<String, Integer>();
                    }
                    if ((count = counters.get(err.getTarget())) == null) {
                        count = 0;
                    } else {
                        Integer n = count;
                        Integer n3 = count = Integer.valueOf(count + 1);
                    }
                    if (count > this.maxTolerableRetries) {
                        logger.error("Content not found for publishing site \"{0}\", target \"{1}\", path \"{2}\"", err, err.getSite(), err.getTarget(), err.getPath());
                    } else {
                        logger.warn("Content not found for publishing site \"{0}\", target \"{1}\", path \"{2}\"", err.getSite(), err.getTarget(), err.getPath());
                    }
                    counters.put(err.getTarget(), count);
                    _publishingFailureCounters.put(err.getSite(), counters);
                }
                catch (Exception err) {
                    logger.error("error while processing items to be published", err, new Object[0]);
                }
            }
            catch (Exception err) {
                logger.error("error while processing items to be published", err, new Object[0]);
            }
        }
    }

    protected Set<DeploymentEndpointConfigTO> getAllTargetsForSite(String site) {
        Map<String, PublishingChannelGroupConfigTO> groupConfigTOs = this.siteService.getPublishingChannelGroupConfigs(site);
        HashSet<DeploymentEndpointConfigTO> targets = new HashSet<DeploymentEndpointConfigTO>();
        HashMap<String, DeploymentEndpointConfigTO> targetMap = new HashMap<String, DeploymentEndpointConfigTO>();
        if (groupConfigTOs != null && groupConfigTOs.size() > 0) {
            for (PublishingChannelGroupConfigTO groupConfigTO : groupConfigTOs.values()) {
                List<PublishingChannelConfigTO> channelConfigTOs = groupConfigTO.getChannels();
                if (channelConfigTOs == null || channelConfigTOs.size() <= 0) continue;
                for (PublishingChannelConfigTO channelConfigTO : channelConfigTOs) {
                    DeploymentEndpointConfigTO endpoint = this.siteService.getDeploymentEndpoint(site, channelConfigTO.getName());
                    if (endpoint == null) continue;
                    DeploymentEndpointConfigTO targetItem = (DeploymentEndpointConfigTO)targetMap.get(endpoint.getName());
                    if (targetItem == null) {
                        targetItem = new DeploymentEndpointConfigTO();
                        targetItem.setName(endpoint.getName());
                        targetItem.setTarget(endpoint.getTarget());
                        targetItem.setType(endpoint.getType());
                        targetItem.setServerUrl(endpoint.getServerUrl());
                        targetItem.setStatusUrl(endpoint.getStatusUrl());
                        targetItem.setVersionUrl(endpoint.getVersionUrl());
                        targetItem.setPassword(endpoint.getPassword());
                        targetItem.setExcludePattern(endpoint.getExcludePattern());
                        targetItem.setIncludePattern(endpoint.getIncludePattern());
                        targetItem.setBucketSize(endpoint.getBucketSize());
                        targetItem.setSiteId(endpoint.getSiteId());
                        targetItem.setSendMetadata(endpoint.isSendMetadata());
                        targets.add(targetItem);
                        targetMap.put(endpoint.getName(), targetItem);
                    }
                    targetItem.addEnvironment(groupConfigTO.getName());
                }
            }
        }
        return targets;
    }

    protected long getDeployedVersion(List<PublishToTarget> syncItems) {
        Collections.sort(syncItems, new VersionComparator());
        PublishToTarget item = syncItems.get(0);
        return item.getVersion();
    }

    protected List<PublishToTarget> filterItems(List<PublishToTarget> syncItems, DeploymentEndpointConfigTO target) {
        List<String> includePaths = target.getIncludePattern();
        List<String> excludePaths = target.getExcludePattern();
        ArrayList<PublishToTarget> filteredItems = new ArrayList<PublishToTarget>();
        for (PublishToTarget item : syncItems) {
            Matcher m;
            Pattern regexPattern;
            boolean exclude = false;
            if (includePaths != null) {
                for (String includePath : includePaths) {
                    regexPattern = Pattern.compile(includePath);
                    m = regexPattern.matcher(item.getPath());
                    if (!m.matches()) continue;
                    exclude = false;
                }
            }
            if (excludePaths != null) {
                for (String excludePath : excludePaths) {
                    regexPattern = Pattern.compile(excludePath);
                    m = regexPattern.matcher(item.getPath());
                    if (!m.matches()) continue;
                    exclude = true;
                }
            }
            if (exclude) continue;
            filteredItems.add(item);
        }
        return filteredItems;
    }

    public Integer getMaxTolerableRetries() {
        return this.maxTolerableRetries;
    }

    public void setMaxTolerableRetries(Integer maxTolerableRetries) {
        this.maxTolerableRetries = maxTolerableRetries;
    }

    public boolean isMasterPublishingNode() {
        return this.masterPublishingNode;
    }

    public void setMasterPublishingNode(boolean masterPublishingNode) {
        this.masterPublishingNode = masterPublishingNode;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public PublishingManager getPublishingManager() {
        return this.publishingManager;
    }

    public void setPublishingManager(PublishingManager publishingManager) {
        this.publishingManager = publishingManager;
    }

    class VersionComparator
    implements Comparator<PublishToTarget> {
        VersionComparator() {
        }

        @Override
        public int compare(PublishToTarget publishToTargetItem, PublishToTarget publishToTargetItem2) {
            long result = publishToTargetItem.getVersion() - publishToTargetItem2.getVersion();
            if (result > 0L) {
                return -1;
            }
            if (result < 0L) {
                return 1;
            }
            return 0;
        }
    }
}

