/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.notification;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.ConfigurableServiceBase;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.notification.NotificationService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.DmPathTO;
import org.craftercms.studio.api.v1.to.EmailMessageQueueTo;
import org.craftercms.studio.api.v1.to.EmailMessageTO;
import org.craftercms.studio.api.v1.to.EmailMessageTemplateTO;
import org.craftercms.studio.api.v1.to.MessageTO;
import org.craftercms.studio.api.v1.to.NotificationConfigTO;
import org.craftercms.studio.api.v1.to.TimeStamped;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class NotificationServiceImpl
extends ConfigurableServiceBase
implements NotificationService {
    private static final Logger logger = LoggerFactory.getLogger(NotificationServiceImpl.class);
    protected static final String MESSAGE_REJECTION = "rejection";
    protected static final String MESSAGE_REJECTION_NON_PREVIEWABLE = "rejectionNonPreviewable";
    protected static final String MESSAGE_APPROVAL = "approval";
    protected static final String MESSAGE_APPROVAL_NONPREVIEWABLE = "approvalNonPreviewable";
    protected static final String MESSAGE_DELETE_APPROVAL = "deleteApproval";
    protected static final String MESSAGE_CONTENT_SUBMISSION = "contentSubmission";
    protected static final String MESSAGE_CONTENT_NOPREVIEWABLE_SUBMISSION = "contentNoPreviewableSubmission";
    protected static final String MESSAGE_CONTENT_SUBMISSION_FOR_DELETE = "contentSubmissionForDelete";
    protected static final String MESSAGE_CONTENT_NOPREVIEWABLE_SUBMISSION_FOR_DELETE = "contentNoPreviewableSubmissionForDelete";
    protected static final String MESSAGE_CONTENT_DATE_FORMAT = "EEE, d MMM yyyy HH:mm:ss z";
    protected static final String DOCUMENT_EXTERNAL_URL_PROPERTY = "cstudio-core:documentExternalUrl";
    protected EmailMessageQueueTo emailMessages;
    protected String previewBaseUrl = null;
    protected String liveBaseUrl = null;
    protected ServicesConfig servicesConfig;
    protected SiteService siteService;
    protected SecurityService securityService;
    protected ContentService contentService;
    protected Map<String, NotificationConfigTO> notificationConfigMap = new HashMap<String, NotificationConfigTO>();

    public String getPreviewBaseUrl() {
        return this.previewBaseUrl;
    }

    public void setPreviewBaseUrl(String previewBaseUrl) {
        this.previewBaseUrl = previewBaseUrl;
    }

    public String getLiveBaseUrl() {
        return this.liveBaseUrl;
    }

    public void setLiveBaseUrl(String liveBaseUrl) {
        this.liveBaseUrl = liveBaseUrl;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Override
    public void register() {
        this._servicesManager.registerService(NotificationService.class, this);
    }

    @Override
    public boolean sendNotice(String site, String action) {
        Boolean sendNotice;
        NotificationConfigTO config = this.notificationConfigMap.get(site);
        if (config != null && (sendNotice = config.getSendNoticeMapping().get(action)) != null) {
            return sendNotice;
        }
        return true;
    }

    @Override
    public String getGeneralMessage(String site, String key) {
        Map<String, String> messages;
        NotificationConfigTO config = this.notificationConfigMap.get(site);
        if (config != null && (messages = config.getMessages()) != null) {
            return messages.get(key);
        }
        return "";
    }

    @Override
    public List<MessageTO> getCannedRejectionReasons(String site) {
        Map<String, List<MessageTO>> messages;
        NotificationConfigTO config = this.notificationConfigMap.get(site);
        if (config != null && (messages = config.getCannedMessages()) != null) {
            return messages.get(MESSAGE_REJECTION);
        }
        return null;
    }

    public EmailMessageTemplateTO getRejectionEmailMessageTemplate(String site) {
        Map<String, EmailMessageTemplateTO> messages;
        NotificationConfigTO config = this.notificationConfigMap.get(site);
        if (config != null && (messages = config.getEmailMessageTemplates()) != null) {
            return messages.get(MESSAGE_REJECTION);
        }
        return null;
    }

    public EmailMessageTemplateTO getRejectionNonPreviewableEmailMessageTemplate(String site) {
        Map<String, EmailMessageTemplateTO> messages;
        NotificationConfigTO config = this.notificationConfigMap.get(site);
        if (config != null && (messages = config.getEmailMessageTemplates()) != null) {
            return messages.get(MESSAGE_REJECTION_NON_PREVIEWABLE);
        }
        return null;
    }

    public EmailMessageTemplateTO getApprovalEmailMessageTemplate(String site) {
        Map<String, EmailMessageTemplateTO> messages;
        NotificationConfigTO config = this.notificationConfigMap.get(site);
        if (config != null && (messages = config.getEmailMessageTemplates()) != null) {
            return messages.get(MESSAGE_APPROVAL);
        }
        return null;
    }

    public EmailMessageTemplateTO getApprovalNonPreviewableEmailMessageTemplate(String site) {
        Map<String, EmailMessageTemplateTO> messages;
        NotificationConfigTO config = this.notificationConfigMap.get(site);
        if (config != null && (messages = config.getEmailMessageTemplates()) != null) {
            return messages.get(MESSAGE_APPROVAL_NONPREVIEWABLE);
        }
        return null;
    }

    public EmailMessageTemplateTO getDeleteApprovalEmailMessageTemplate(String site) {
        Map<String, EmailMessageTemplateTO> messages;
        NotificationConfigTO config = this.notificationConfigMap.get(site);
        if (config != null && (messages = config.getEmailMessageTemplates()) != null) {
            return messages.get(MESSAGE_DELETE_APPROVAL);
        }
        return null;
    }

    public EmailMessageTemplateTO getContentSubmissionEmailMessageTemplate(String site) {
        Map<String, EmailMessageTemplateTO> messages;
        NotificationConfigTO config = this.notificationConfigMap.get(site);
        if (config != null && (messages = config.getEmailMessageTemplates()) != null) {
            return messages.get(MESSAGE_CONTENT_SUBMISSION);
        }
        return null;
    }

    public EmailMessageTemplateTO getContentSubmissionNoPreviewableEmailMessageTemplate(String site) {
        Map<String, EmailMessageTemplateTO> messages;
        NotificationConfigTO config = this.notificationConfigMap.get(site);
        if (config != null && (messages = config.getEmailMessageTemplates()) != null) {
            return messages.get(MESSAGE_CONTENT_NOPREVIEWABLE_SUBMISSION);
        }
        return null;
    }

    public EmailMessageTemplateTO getContentSubmissionForDeleteEmailMessageTemplate(String site) {
        Map<String, EmailMessageTemplateTO> messages;
        NotificationConfigTO config = this.notificationConfigMap.get(site);
        if (config != null && (messages = config.getEmailMessageTemplates()) != null) {
            return messages.get(MESSAGE_CONTENT_SUBMISSION_FOR_DELETE);
        }
        return null;
    }

    public EmailMessageTemplateTO getContentSubmissionForDeleteNoPreviewableEmailMessageTemplate(String site) {
        Map<String, EmailMessageTemplateTO> messages;
        NotificationConfigTO config = this.notificationConfigMap.get(site);
        if (config != null && (messages = config.getEmailMessageTemplates()) != null) {
            return messages.get(MESSAGE_CONTENT_NOPREVIEWABLE_SUBMISSION_FOR_DELETE);
        }
        return null;
    }

    @Override
    public String getCompleteMessage(String site, String key) {
        Map<String, String> messages;
        NotificationConfigTO config = this.notificationConfigMap.get(site);
        if (config != null && (messages = config.getCompleteMessages()) != null) {
            return messages.get(key);
        }
        return "";
    }

    @Override
    public String getErrorMessage(String site, String key, Map<String, String> params) {
        Map<String, String> messages;
        NotificationConfigTO config = this.notificationConfigMap.get(site);
        if (config != null && (messages = config.getErrorMessages()) != null) {
            String s = messages.get(key);
            for (Map.Entry<String, String> param : params.entrySet()) {
                s = s.replaceAll("\\$" + param.getKey(), param.getValue());
            }
            return s;
        }
        return "";
    }

    @Override
    public void sendContentSubmissionNotification(String site, String to, String browserUrl, String from, Date scheduledDate, boolean isPreviewable, boolean isDelete) {
        try {
            EmailMessageTemplateTO template = null;
            template = isDelete ? (isPreviewable ? this.getContentSubmissionForDeleteEmailMessageTemplate(site) : this.getContentSubmissionForDeleteNoPreviewableEmailMessageTemplate(site)) : (isPreviewable ? this.getContentSubmissionEmailMessageTemplate(site) : this.getContentSubmissionNoPreviewableEmailMessageTemplate(site));
            String subject = "Contributer submitted a content for approval.";
            String message = "Contributer submitted a content for approval.\n";
            if (isDelete) {
                subject = "Contributer submitted a content for delete.";
                message = "Contributer submitted a content for delete.\n";
            }
            if (template != null) {
                subject = template.getSubject();
                message = template.getMessage();
            }
            if (scheduledDate != null) {
                subject = subject + ", At requested [";
                subject = subject + this.getDateInSpecificTimezone(scheduledDate, site);
                subject = subject + (isDelete ? "] (Scheduled for Delete)" : "] (Scheduled Go Live)");
            } else {
                subject = subject + ", As soon as possible ";
            }
            this.notifyUser(site, to, message, subject, from, browserUrl, "");
        }
        catch (Exception e) {
            logger.error("Could not queue the content submission notification:", e, new Object[0]);
        }
    }

    @Override
    public void sendDeleteApprovalNotification(String site, String to, String browserUrl, String from) {
        try {
            EmailMessageTemplateTO template = this.getDeleteApprovalEmailMessageTemplate(site);
            String subject = "Your Content deletion got Approved.";
            String message = "Admin has approved your request to delete content.\n";
            if (template != null) {
                subject = template.getSubject();
                message = template.getMessage();
            }
            this.notifyUser(site, to, message, subject, from, browserUrl, "");
        }
        catch (Exception e) {
            logger.error("Could not queue the content delete approval notification:", e, new Object[0]);
        }
    }

    public void setEmailMessages(EmailMessageQueueTo emailMessages) {
        this.emailMessages = emailMessages;
    }

    @Override
    public void sendGenericNotification(String site, String path, String to, String from, String key, Map<String, String> params) {
        try {
            Map<String, EmailMessageTemplateTO> messages;
            EmailMessageTemplateTO template = null;
            this.checkForUpdate(site);
            NotificationConfigTO config = this.notificationConfigMap.get(site);
            if (config != null && (messages = config.getEmailMessageTemplates()) != null) {
                template = messages.get(key);
            }
            if (template == null) {
                throw new RuntimeException("No email-message-template: " + key);
            }
            String subject = template.getSubject();
            String message = template.getMessage();
            if (params != null) {
                for (String name : params.keySet()) {
                    String value = params.get(name);
                    message = message.replaceAll("\\$" + name, value);
                }
            }
            this.notifyUser(site, to, message, subject, from, path, null);
        }
        catch (Exception e) {
            logger.error("Could not queue the notification:", e, new Object[0]);
        }
    }

    @Override
    protected void loadConfiguration(String key) {
        String configFullPath = this.getConfigFullPath(key);
        try {
            Document document = this.contentService.getContentAsDocument(configFullPath);
            if (document != null) {
                Element root = document.getRootElement();
                NotificationConfigTO config = new NotificationConfigTO();
                Node configNode = root.selectSingleNode("/notification-config");
                if (configNode != null) {
                    this.loadCannedMessages(config, configNode.selectNodes("canned-messages/messages"));
                    this.loadEmailMessageTemplates(config, configNode.selectNodes("email-message-templates/email-message-template"));
                    Map<String, String> completeMessages = this.loadMessages(configNode.selectNodes("complete-messages/message"));
                    Map<String, String> errorMessages = this.loadMessages(configNode.selectNodes("error-messages/message"));
                    config.setCompleteMessages(completeMessages);
                    config.setErrorMessages(errorMessages);
                    Map<String, String> generalMessages = this.loadMessages(configNode.selectNodes("general-messages/message"));
                    config.setMessages(generalMessages);
                    Map<String, Boolean> noticeMapping = this.loadSendNoticeMapping(configNode.selectSingleNode("send-notifications"));
                    config.setSendNoticeMapping(noticeMapping);
                    config.setSite(key);
                    config.setLastUpdated(new Date());
                    this.notificationConfigMap.put(key, config);
                } else {
                    logger.error("Notification config is not found for " + key, new Object[0]);
                }
            }
        }
        catch (Exception ex) {
            logger.error("Notification config is not found for " + key, ex, new Object[0]);
        }
    }

    protected Map<String, Boolean> loadSendNoticeMapping(Node node) {
        Element element;
        List childElements;
        HashMap<String, Boolean> noticeMapping = new HashMap<String, Boolean>();
        if (node != null && (childElements = (element = (Element)node).elements()) != null && childElements.size() > 0) {
            for (Element childElement : childElements) {
                String action = childElement.getName();
                String value = childElement.getText();
                Boolean sendNotice = StringUtils.isEmpty((String)value) || !value.equals("false");
                if (StringUtils.isEmpty((String)action)) continue;
                noticeMapping.put(action, sendNotice);
            }
        }
        return noticeMapping;
    }

    protected Map<String, String> loadMessages(List<Node> nodes) {
        if (nodes != null) {
            HashMap<String, String> messagesMap = new HashMap<String, String>();
            for (Node node : nodes) {
                String name = node.valueOf("@name");
                if (StringUtils.isEmpty((String)name)) continue;
                String message = node.getText();
                messagesMap.put(name, message);
            }
            return messagesMap;
        }
        return null;
    }

    @Override
    protected String getConfigFullPath(String key) {
        String siteConfigPath = this.configPath.replaceFirst("\\{site\\}", key);
        return siteConfigPath + "/" + this.configFileName;
    }

    protected void loadCannedMessages(NotificationConfigTO config, List<Node> nodes) {
        if (nodes != null) {
            HashMap<String, List<MessageTO>> messageMap = new HashMap<String, List<MessageTO>>();
            for (Node listNode : nodes) {
                List messageNodes;
                String name = listNode.valueOf("@name");
                if (StringUtils.isEmpty((String)name) || (messageNodes = listNode.selectNodes("message")) == null) continue;
                ArrayList<MessageTO> messages = new ArrayList<MessageTO>(messageNodes.size());
                for (Node messageNode : messageNodes) {
                    MessageTO message = new MessageTO();
                    message.setTitle(messageNode.valueOf("title"));
                    message.setBody(messageNode.valueOf("body"));
                    messages.add(message);
                }
                messageMap.put(name, messages);
            }
            config.setCannedMessages(messageMap);
        }
    }

    protected void loadEmailMessageTemplates(NotificationConfigTO config, List<Node> nodes) {
        if (nodes != null) {
            HashMap<String, EmailMessageTemplateTO> messageMap = new HashMap<String, EmailMessageTemplateTO>();
            for (Node listNode : nodes) {
                String name = listNode.valueOf("@name");
                if (StringUtils.isEmpty((String)name)) continue;
                EmailMessageTemplateTO message = new EmailMessageTemplateTO();
                message.setSubject(listNode.valueOf("Subject"));
                message.setMessage(listNode.valueOf("message"));
                messageMap.put(name, message);
            }
            config.setEmailMessageTemplates(messageMap);
        }
    }

    @Override
    protected void removeConfiguration(String key) {
        if (!StringUtils.isEmpty((String)key)) {
            this.notificationConfigMap.remove(key);
        }
    }

    @Override
    public void sendRejectionNotification(String site, String to, String browserUrl, String reason, String from, boolean isPreviewable) {
        try {
            EmailMessageTemplateTO template = null;
            template = isPreviewable ? this.getRejectionEmailMessageTemplate(site) : this.getRejectionNonPreviewableEmailMessageTemplate(site);
            String subject = "Your content has got rejected.";
            String message = "Your content has been rejected for following reason(s).\n";
            if (template != null) {
                subject = template.getSubject();
                message = template.getMessage();
            }
            if (StringUtils.isNotEmpty((String)reason)) {
                message = message + "\n\n" + reason;
            }
            this.notifyUser(site, to, message, subject, from, browserUrl, reason);
        }
        catch (Exception e) {
            logger.error("Could not queue the rejection notification:", e, new Object[0]);
        }
    }

    @Override
    public void sendApprovalNotification(String site, String to, String browserUrl, String from) {
        try {
            logger.debug("Sending approval notification to:" + to, new Object[0]);
            boolean isPreviewable = true;
            try {
                ContentItemTO contentItem = this.contentService.getContentItem(site, browserUrl);
                isPreviewable = contentItem.isPreviewable();
            }
            catch (Exception e) {
                logger.error("during Notification send item name read failed", e, new Object[0]);
            }
            EmailMessageTemplateTO template = null;
            template = isPreviewable ? this.getApprovalEmailMessageTemplate(site) : this.getApprovalNonPreviewableEmailMessageTemplate(site);
            String subject = "Your content has got the approval.";
            String message = "Your content has been approved.\n";
            if (template != null) {
                subject = template.getSubject();
                message = template.getMessage();
            }
            this.notifyUser(site, to, message, subject, from, browserUrl, "");
        }
        catch (Exception e) {
            logger.error("Could not queue the approval notification:", e, new Object[0]);
        }
    }

    protected void notifyUser(String site, String toUser, String content, String subject, String fromUser, String relativeUrl, String rejectReason) {
        String folderPath;
        logger.debug("Notifying user:" + toUser, new Object[0]);
        if (StringUtils.isEmpty((String)toUser)) {
            logger.error("to User is empty or Null, not sending any email", new Object[0]);
            return;
        }
        if (this.previewBaseUrl == null) {
            this.previewBaseUrl = this.siteService.getPreviewServerUrl(site);
        }
        if (this.liveBaseUrl == null) {
            this.liveBaseUrl = this.siteService.getLiveServerUrl(site);
        }
        String adminEmailAddress = this.siteService.getAdminEmailAddress(site);
        String userEmailAddress = "";
        if (userEmailAddress == null || "".equals(userEmailAddress)) {
            Map<String, String> profile = this.securityService.getUserProfile(toUser);
            userEmailAddress = profile.get("email");
        }
        Map<String, String> fromProfile = this.securityService.getUserProfile(fromUser);
        String userFirstName = fromProfile.get("firstName");
        String userLastName = fromProfile.get("lastName");
        String replyTo = fromProfile.get("email");
        String fromPersonalName = "";
        if (userFirstName != null) {
            fromPersonalName = userFirstName + " ";
        }
        if (userLastName != null) {
            fromPersonalName = fromPersonalName + userLastName;
        }
        EmailMessageTO emailMessage = new EmailMessageTO(subject, content, userEmailAddress);
        emailMessage.setPreviewBaseUrl(this.previewBaseUrl);
        emailMessage.setLiveBaseUrl(this.liveBaseUrl);
        if (StringUtils.isNotEmpty((String)rejectReason)) {
            emailMessage.setRejectReason(rejectReason);
        }
        String itemName = "";
        boolean isDocument = false;
        boolean isExternalDocument = false;
        String documentUrl = "";
        ContentItemTO contentItem = this.contentService.getContentItem(site, relativeUrl, 0);
        if (contentItem != null) {
            itemName = contentItem.getInternalName();
            if (contentItem.isPreviewable() && contentItem.isDocument()) {
                isDocument = true;
                String string = "";
            }
        }
        String absolutePath = this.contentService.expandRelativeSitePath(site, relativeUrl);
        DmPathTO path = new DmPathTO(absolutePath);
        String name = path.getName();
        String browserUri = contentItem.getBrowserUri();
        String internalName = folderPath = name.equals("index.xml") ? relativeUrl.replace("/" + name, "") : relativeUrl;
        int index = folderPath.lastIndexOf(47);
        if (index != -1) {
            internalName = folderPath.substring(index + 1);
        }
        internalName = StringUtils.isEmpty((String)itemName) ? internalName : itemName;
        emailMessage.setPersonalFromName(fromPersonalName);
        emailMessage.setTitle(internalName);
        emailMessage.setAdminEmail(adminEmailAddress);
        if (isDocument) {
            if (isExternalDocument) {
                emailMessage.setBrowserUrlForExternalDocument(documentUrl);
            } else {
                emailMessage.setBrowserUrl(documentUrl);
            }
        } else {
            emailMessage.setBrowserUrl(browserUri);
        }
        if (replyTo != null) {
            emailMessage.setReplyTo(replyTo);
        }
        logger.debug("Queuing notification email request for user:" + userEmailAddress, new Object[0]);
        this.emailMessages.addEmailMessage(emailMessage);
    }

    protected String getDateInSpecificTimezone(Date dt, String site) {
        String ret = "";
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(MESSAGE_CONTENT_DATE_FORMAT);
            fmt.setTimeZone(TimeZone.getTimeZone(this.servicesConfig.getDefaultTimezone(site)));
            ret = fmt.format(dt).toString();
        }
        catch (Exception e) {
            logger.error("Date cannot be converted", e, new Object[0]);
        }
        return ret;
    }

    @Override
    public void reloadConfiguration(String site) {
        if (this.isConfigUpdated(site)) {
            this.loadConfiguration(site);
        }
    }

    @Override
    protected TimeStamped getConfigurationById(String key) {
        return this.notificationConfigMap.get(key);
    }
}

