/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.objectstate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.dal.ObjectState;
import org.craftercms.studio.api.v1.dal.ObjectStateMapper;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.objectstate.State;
import org.craftercms.studio.api.v1.service.objectstate.TransitionEvent;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.springframework.beans.factory.annotation.Autowired;

public class ObjectStateServiceImpl
extends AbstractRegistrableService
implements ObjectStateService {
    private static final Logger logger = LoggerFactory.getLogger(ObjectStateServiceImpl.class);
    protected State[][] transitionTable = null;
    @Autowired
    protected ObjectStateMapper objectStateMapper;
    protected GeneralLockService generalLockService;
    protected ContentService contentService;

    @Override
    public void register() {
        this.getServicesManager().registerService(ObjectStateService.class, this);
        this.initializeTransitionTable();
    }

    @Override
    public ObjectState getObjectState(String site, String path) {
        return this.getObjectState(site, path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectState getObjectState(String site, String path, boolean insert) {
        String lockId = site + ":" + path;
        ObjectState state = null;
        this.generalLockService.lock(lockId);
        try {
            ContentItemTO item;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("site", site);
            params.put("path", path);
            state = this.objectStateMapper.getObjectStateBySiteAndPath(params);
            if (state == null && insert && this.contentService.contentExists(site, path) && !(item = this.contentService.getContentItem(site, path, 0)).isFolder()) {
                this.insertNewEntry(site, item);
                state = this.objectStateMapper.getObjectStateBySiteAndPath(params);
            }
        }
        finally {
            this.generalLockService.unlock(lockId);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSystemProcessing(String site, String path, boolean isSystemProcessing) {
        String lockId = site + ":" + path;
        logger.debug("Locking with ID: {0}", lockId);
        this.generalLockService.lock(lockId);
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("site", site);
            params.put("path", path);
            params.put("systemProcessing", isSystemProcessing);
            logger.debug("Updating system processing in DB: {0}:{1} - {2}", site, path, isSystemProcessing);
            this.objectStateMapper.setSystemProcessingBySiteAndPath(params);
        }
        catch (Throwable throwable) {
            logger.debug("Unlocking with ID: {0}", lockId);
            this.generalLockService.unlock(lockId);
            throw throwable;
        }
        logger.debug("Unlocking with ID: {0}", lockId);
        this.generalLockService.unlock(lockId);
    }

    @Override
    public void setSystemProcessingBulk(String site, List<String> paths, boolean isSystemProcessing) {
        if (paths == null || paths.isEmpty()) {
            return;
        }
        for (String path : paths) {
            this.setSystemProcessing(site, path, isSystemProcessing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transition(String site, ContentItemTO item, TransitionEvent event) {
        String lockId = site + ":" + item.getUri();
        this.generalLockService.lock(lockId);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("site", site);
            params.put("path", item.getUri());
            ObjectState currentState = this.objectStateMapper.getObjectStateBySiteAndPath(params);
            State nextState = null;
            if (currentState == null) {
                logger.debug("Preforming transition event " + event.name() + " on object " + lockId + " without current state", new Object[0]);
                switch (event) {
                    case SAVE: {
                        nextState = State.NEW_UNPUBLISHED_UNLOCKED;
                        break;
                    }
                    case SAVE_FOR_PREVIEW: {
                        nextState = State.NEW_UNPUBLISHED_LOCKED;
                        break;
                    }
                    default: {
                        nextState = State.NEW_UNPUBLISHED_UNLOCKED;
                        break;
                    }
                }
            } else {
                logger.debug("Preforming transition event " + (Object)((Object)event) + " on object " + lockId + " with " + currentState.getState() + " state", new Object[0]);
                State currentStateValue = State.valueOf(currentState.getState());
                nextState = this.transitionTable[currentStateValue.ordinal()][event.ordinal()];
            }
            if (currentState == null) {
                ObjectState newEntry = new ObjectState();
                if (item.getNodeRef() == null) {
                    newEntry.setObjectId(UUID.randomUUID().toString());
                } else {
                    newEntry.setObjectId(item.getNodeRef());
                }
                newEntry.setSite(site);
                newEntry.setPath(item.getUri());
                newEntry.setSystemProcessing(0);
                newEntry.setState(nextState.name());
                this.objectStateMapper.insertEntry(newEntry);
            } else if (nextState.toString() != currentState.getState() && nextState != State.NOOP) {
                currentState.setState(nextState.name());
                this.objectStateMapper.setObjectState(currentState);
            } else if (nextState == State.NOOP) {
                logger.warn("Transition not defined for event " + event.name() + " and current state " + currentState.getState() + " [object id: " + currentState.getObjectId() + "]", new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error("Transition not defined for event", e, new Object[0]);
        }
        finally {
            this.generalLockService.unlock(lockId);
        }
        logger.debug("Transition finished for " + event.name() + " on object " + lockId, new Object[0]);
    }

    @Override
    public void insertNewEntry(String site, ContentItemTO item) {
        ObjectState newEntry = new ObjectState();
        if (StringUtils.isEmpty((String)item.getNodeRef())) {
            newEntry.setObjectId(UUID.randomUUID().toString());
        } else {
            newEntry.setObjectId(item.getNodeRef());
        }
        newEntry.setSite(site);
        newEntry.setPath(item.getUri());
        newEntry.setSystemProcessing(0);
        newEntry.setState(State.NEW_UNPUBLISHED_UNLOCKED.name());
        this.objectStateMapper.insertEntry(newEntry);
    }

    @Override
    public void insertNewEntry(String site, String path) {
        ObjectState newEntry = new ObjectState();
        newEntry.setObjectId(UUID.randomUUID().toString());
        newEntry.setSite(site);
        newEntry.setPath(path);
        newEntry.setSystemProcessing(0);
        newEntry.setState(State.NEW_UNPUBLISHED_UNLOCKED.name());
        this.objectStateMapper.insertEntry(newEntry);
    }

    @Override
    public List<ObjectState> getSubmittedItems(String site) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> statesValues = new ArrayList<String>();
        for (State state : State.SUBMITTED_STATES) {
            statesValues.add(state.name());
        }
        params.put("states", statesValues);
        params.put("site", site);
        List<ObjectState> objects = this.objectStateMapper.getObjectStateByStates(params);
        return objects;
    }

    @Override
    public void updateObjectPath(String site, String oldPath, String newPath) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("oldPath", oldPath);
        params.put("newPath", newPath);
        this.objectStateMapper.updateObjectPath(params);
    }

    @Override
    public boolean isUpdatedOrNew(String site, String path) {
        ObjectState state = this.getObjectState(site, path);
        if (state != null) {
            return State.isUpdateOrNew(State.valueOf(state.getState()));
        }
        return false;
    }

    @Override
    public boolean isNew(String site, String path) {
        ObjectState state = this.getObjectState(site, path);
        if (state != null) {
            return State.isNew(State.valueOf(state.getState()));
        }
        return false;
    }

    @Override
    public boolean isScheduled(String site, String path) {
        ObjectState state = this.getObjectState(site, path);
        if (state != null) {
            return State.isScheduled(State.valueOf(state.getState()));
        }
        return false;
    }

    @Override
    public boolean isInWorkflow(String site, String path) {
        ObjectState state = this.getObjectState(site, path);
        if (state != null) {
            return State.isInWorkflow(State.valueOf(state.getState()));
        }
        return false;
    }

    @Override
    public List<ObjectState> getChangeSet(String site) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> statesValues = new ArrayList<String>();
        for (State state : State.CHANGE_SET_STATES) {
            statesValues.add(state.name());
        }
        params.put("states", statesValues);
        params.put("site", site);
        List<ObjectState> objects = this.objectStateMapper.getObjectStateByStates(params);
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObjectState(String objectId) {
        GeneralLockService nodeLockService = this.getService(GeneralLockService.class);
        nodeLockService.lock(objectId);
        try {
            this.objectStateMapper.deleteObjectState(objectId);
        }
        finally {
            nodeLockService.unlock(objectId);
        }
    }

    @Override
    public void deleteObjectStateForPath(String site, String path) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        this.objectStateMapper.deleteObjectStateForSiteAndPath(params);
    }

    @Override
    public void transitionBulk(String site, List<String> paths, TransitionEvent event, State defaultTargetState) {
        if (paths != null && !paths.isEmpty()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("site", site);
            params.put("paths", paths);
            List<ObjectState> objectStates = this.objectStateMapper.getObjectStateForSiteAndPaths(params);
            HashMap bulkSubsets = new HashMap();
            for (ObjectState state : objectStates) {
                if (!bulkSubsets.containsKey(state.getState())) {
                    bulkSubsets.put(State.valueOf(state.getState()), new ArrayList());
                }
                ((List)bulkSubsets.get((Object)State.valueOf(state.getState()))).add(state.getObjectId());
            }
            State nextState = null;
            for (Map.Entry entry : bulkSubsets.entrySet()) {
                if (entry.getKey() == null) {
                    params = new HashMap();
                    params.put("site", site);
                    params.put("paths", paths);
                    params.put("state", defaultTargetState.name());
                    this.objectStateMapper.setObjectStateForSiteAndPaths(params);
                    continue;
                }
                nextState = this.transitionTable[((State)((Object)entry.getKey())).ordinal()][event.ordinal()];
                if (nextState != entry.getKey() && nextState != State.NOOP) {
                    params = new HashMap();
                    params.put("site", site);
                    params.put("paths", paths);
                    params.put("state", nextState.name());
                    this.objectStateMapper.setObjectStateForSiteAndPaths(params);
                    continue;
                }
                if (nextState != State.NOOP) continue;
                logger.warn("Transition not defined for event " + event.name() + " and current state " + ((State)((Object)entry.getKey())).name() + " [setting object state for multiple objects]", new Object[0]);
            }
        }
    }

    @Override
    public List<ObjectState> getObjectStateByStates(String site, List<String> states) {
        if (states != null && !states.isEmpty()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("states", states);
            params.put("site", site);
            List<ObjectState> result = this.objectStateMapper.getObjectStateByStates(params);
            return result;
        }
        return new ArrayList<ObjectState>(0);
    }

    public String setObjectState(String site, String path, String state, boolean systemProcessing) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        ObjectState objectState = this.objectStateMapper.getObjectStateBySiteAndPath(params);
        if (objectState == null) {
            this.insertNewEntry(site, path);
            objectState = this.objectStateMapper.getObjectStateBySiteAndPath(params);
        }
        objectState.setState(state);
        objectState.setSystemProcessing(systemProcessing ? 1 : 0);
        this.objectStateMapper.setObjectState(objectState);
        return "Success";
    }

    @Override
    public void deleteObjectStatesForSite(String site) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        this.objectStateMapper.deleteObjectStatesForSite(params);
    }

    private void initializeTransitionTable() {
        this.transitionTable = new State[][]{{State.NEW_DELETED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NOOP, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NEW_DELETED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NOOP, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NEW_DELETED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED, State.NEW_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_UNPUBLISHED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NEW_DELETED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED, State.NEW_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_UNPUBLISHED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NEW_DELETED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED, State.NEW_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NEW_UNPUBLISHED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NEW_DELETED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED, State.NEW_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NEW_UNPUBLISHED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NEW_DELETED, State.NEW_SUBMITTED_NO_WF_SCHEDULED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NEW_UNPUBLISHED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NEW_DELETED, State.NEW_SUBMITTED_NO_WF_SCHEDULED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NEW_UNPUBLISHED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NOOP, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NOOP, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NEW_DELETED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_PUBLISHING_FAILED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NEW_UNPUBLISHED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NEW_UNPUBLISHED_UNLOCKED, State.NOOP, State.NOOP, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP}, {State.EXISTING_DELETED, State.EXISTING_UNEDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_UNEDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NOOP, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NOOP, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.NOOP, State.EXISTING_UNEDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NOOP, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_UNEDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.EXISTING_EDITED_UNLOCKED, State.NOOP, State.NOOP, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP}};
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }
}

