/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.security;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.security.SecurityProvider;

public class CachedSecurityProvider
implements SecurityProvider {
    private static final Logger logger = LoggerFactory.getLogger(CachedSecurityProvider.class);
    SecurityProvider provider;
    HashMap<String, Object> cache;
    long cacheAge = System.currentTimeMillis();
    HashMap<String, Object> globalCache = new HashMap();

    public SecurityProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SecurityProvider provider) {
        this.provider = provider;
    }

    @Override
    public Set<String> getUserGroups(String user) {
        Set<String> value = null;
        value = (Set<String>)this.getCachedObject("getUserGroups-" + user);
        if (value == null && (value = this.provider.getUserGroups(user)) != null) {
            this.cacheObject("getUserGroups-" + user, value);
        }
        return value;
    }

    @Override
    public String getCurrentUser() {
        return this.provider.getCurrentUser();
    }

    @Override
    public Map<String, String> getUserProfile(String user) {
        return this.provider.getUserProfile(user);
    }

    @Override
    public String authenticate(String username, String password) {
        return this.provider.authenticate(username, password);
    }

    @Override
    public boolean validateTicket(String ticket) {
        return this.provider.validateTicket(ticket);
    }

    @Override
    public void addUserGroup(String groupName) {
        this.provider.addUserGroup(groupName);
    }

    @Override
    public void addUserGroup(String parentGroup, String groupName) {
        this.provider.addUserGroup(parentGroup, groupName);
    }

    @Override
    public String getCurrentToken() {
        return this.provider.getCurrentToken();
    }

    @Override
    public void addUserToGroup(String groupName, String user) {
        this.provider.addUserToGroup(groupName, user);
    }

    @Override
    public boolean logout() {
        return this.provider.logout();
    }

    protected void cacheObject(String key, Object value) {
        HashMap<String, Object> cache = this.getCache();
        cache.put(key, value);
    }

    protected Object getCachedObject(String key) {
        Object value = null;
        HashMap<String, Object> cache = this.getCache();
        value = cache.get(key);
        if (value != null) {
            logger.debug("HIT: " + key, new Object[0]);
        }
        return value;
    }

    protected HashMap<String, Object> getCache() {
        Object cache = null;
        if (System.currentTimeMillis() - this.cacheAge > 10000L) {
            this.cacheAge = System.currentTimeMillis();
            this.globalCache = new HashMap();
        }
        return this.globalCache;
    }
}

