/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.security;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.security.SecurityProvider;

public class MappedSecurityProvider
implements SecurityProvider {
    private static final Logger logger = LoggerFactory.getLogger(MappedSecurityProvider.class);
    private Map<String, SecurityProvider> providerMap = new HashMap<String, SecurityProvider>();
    private String providerType = "default";

    public Map<String, SecurityProvider> getProviderMap() {
        return this.providerMap;
    }

    public void setProviderMap(Map<String, SecurityProvider> map) {
        this.providerMap = map;
    }

    public String getProviderType() {
        return this.providerType;
    }

    public void setProviderType(String type) {
        this.providerType = type;
    }

    public void registerSecurityProvider(String type, SecurityProvider provider) {
        logger.debug("Registering Security Provider: ({0}) with class: '{1}'", type, "" + provider);
        this.providerMap.put(type, provider);
    }

    protected SecurityProvider lookupProvider(String key) {
        SecurityProvider provider = this.providerMap.get(key);
        if (provider == null) {
            throw new RuntimeException("provider type '" + key + "' not found.  Check server config.");
        }
        return provider;
    }

    @Override
    public Set<String> getUserGroups(String user) {
        SecurityProvider provider = this.lookupProvider(this.providerType);
        return provider.getUserGroups(user);
    }

    @Override
    public String getCurrentUser() {
        SecurityProvider provider = this.lookupProvider(this.providerType);
        return provider.getCurrentUser();
    }

    @Override
    public Map<String, String> getUserProfile(String user) {
        SecurityProvider provider = this.lookupProvider(this.providerType);
        return provider.getUserProfile(user);
    }

    @Override
    public String authenticate(String username, String password) {
        SecurityProvider provider = this.lookupProvider(this.providerType);
        return provider.authenticate(username, password);
    }

    @Override
    public boolean validateTicket(String ticket) {
        SecurityProvider provider = this.lookupProvider(this.providerType);
        return provider.validateTicket(ticket);
    }

    @Override
    public void addUserGroup(String groupName) {
        SecurityProvider provider = this.lookupProvider(this.providerType);
        provider.addUserGroup(groupName);
    }

    @Override
    public void addUserGroup(String parentGroup, String groupName) {
        SecurityProvider provider = this.lookupProvider(this.providerType);
        provider.addUserGroup(parentGroup, groupName);
    }

    @Override
    public String getCurrentToken() {
        SecurityProvider provider = this.lookupProvider(this.providerType);
        return provider.getCurrentToken();
    }

    @Override
    public void addUserToGroup(String groupName, String user) {
        SecurityProvider provider = this.lookupProvider(this.providerType);
        provider.addUserToGroup(groupName, user);
    }

    @Override
    public boolean logout() {
        SecurityProvider provider = this.lookupProvider(this.providerType);
        return provider.logout();
    }
}

