/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.security;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.ConfigurableServiceBase;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ContentTypeService;
import org.craftercms.studio.api.v1.service.security.SecurityProvider;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.to.ContentTypeConfigTO;
import org.craftercms.studio.api.v1.to.PermissionsConfigTO;
import org.craftercms.studio.api.v1.to.TimeStamped;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class SecurityServiceImpl
extends ConfigurableServiceBase
implements SecurityService {
    private static final Logger logger = LoggerFactory.getLogger(SecurityServiceImpl.class);
    protected Map<String, PermissionsConfigTO> permissionsConfigMap = new HashMap<String, PermissionsConfigTO>();
    protected String roleMappingsFileName;
    protected String permissionsFileName;
    protected String globalConfigPath;
    protected String globalRoleMappingsFileName;
    protected String globalPermissionsFileName;
    protected SecurityProvider securityProvider;
    protected ContentTypeService contentTypeService;
    protected ContentService contentService;

    @Override
    public String authenticate(String username, String password) {
        return this.securityProvider.authenticate(username, password);
    }

    @Override
    public boolean validateTicket(String token) {
        return this.securityProvider.validateTicket(token);
    }

    @Override
    public String getCurrentUser() {
        return this.securityProvider.getCurrentUser();
    }

    @Override
    public Map<String, String> getUserProfile(String user) {
        return this.securityProvider.getUserProfile(user);
    }

    @Override
    public Set<String> getUserPermissions(String site, String path, String user, List<String> groups) {
        HashSet<String> roles;
        Set<Object> permissions = new HashSet();
        if (StringUtils.isNotEmpty((String)site)) {
            PermissionsConfigTO rolesConfig = this.permissionsConfigMap.get(this.getPermissionsKey(site, this.roleMappingsFileName));
            PermissionsConfigTO permissionsConfig = this.permissionsConfigMap.get(this.getPermissionsKey(site, this.permissionsFileName));
            roles = new HashSet<String>();
            this.addUserRoles(roles, site, user);
            this.addGroupRoles(roles, site, groups, rolesConfig);
            permissions = this.populateUserPermissions(site, path, roles, permissionsConfig);
            if (path.indexOf("/site") == 0) {
                try {
                    ContentTypeConfigTO config = this.contentTypeService.getContentTypeForContent(site, path);
                    boolean isAllowed = this.contentTypeService.isUserAllowed(roles, config);
                    if (!isAllowed) {
                        logger.debug("The user is not allowed to access " + site + ":" + path + ". adding permission: " + "not allowed", new Object[0]);
                        permissions.add("not allowed");
                        return permissions;
                    }
                }
                catch (ServiceException e) {
                    logger.debug("Error while getting the content type of " + path + ". skipping user role checking on the content.", new Object[0]);
                }
            }
        }
        PermissionsConfigTO globalRolesConfig = this.permissionsConfigMap.get("###GLOBAL###:" + this.globalRoleMappingsFileName);
        PermissionsConfigTO globalPermissionsConfig = this.permissionsConfigMap.get("###GLOBAL###:" + this.globalPermissionsFileName);
        roles = new HashSet();
        this.addGlobalUserRoles(user, roles, globalRolesConfig);
        this.addGlobalGroupRoles(roles, groups, globalRolesConfig);
        permissions.addAll(this.populateUserGlobalPermissions(path, roles, globalPermissionsConfig));
        return permissions;
    }

    protected void addGlobalUserRoles(String user, Set<String> roles, PermissionsConfigTO rolesConfig) {
        Set<String> groups = this.securityProvider.getUserGroups(user);
        if (rolesConfig != null && groups != null) {
            Map<String, List<String>> rolesMap = rolesConfig.getRoles();
            for (String group : groups) {
                String groupName = group.replaceFirst("GROUP_", "");
                List<String> userRoles = rolesMap.get(groupName);
                if (roles == null || userRoles == null) continue;
                roles.addAll(userRoles);
            }
        }
    }

    protected void addGlobalGroupRoles(Set<String> roles, List<String> groups, PermissionsConfigTO rolesConfig) {
        if (groups != null) {
            Map<String, List<String>> rolesMap = rolesConfig.getRoles();
            for (String group : groups) {
                List<String> groupRoles = rolesMap.get(group);
                if (groupRoles == null) continue;
                logger.debug("Adding roles by group " + group + ": " + roles, new Object[0]);
                roles.addAll(groupRoles);
            }
        }
    }

    protected Set<String> populateUserGlobalPermissions(String path, Set<String> roles, PermissionsConfigTO permissionsConfig) {
        HashSet<String> permissions = new HashSet<String>();
        if (roles != null && !roles.isEmpty()) {
            for (String role : roles) {
                Map<String, Map<String, List<Node>>> permissionsMap = permissionsConfig.getPermissions();
                Map<String, List<Node>> siteRoles = permissionsMap.get("###GLOBAL###");
                if (siteRoles == null || siteRoles.isEmpty()) {
                    siteRoles = permissionsMap.get("*");
                }
                if (siteRoles != null && !siteRoles.isEmpty()) {
                    List<Node> ruleNodes = siteRoles.get(role);
                    if (ruleNodes == null || ruleNodes.isEmpty()) {
                        ruleNodes = siteRoles.get("*");
                    }
                    if (ruleNodes != null && !ruleNodes.isEmpty()) {
                        for (Node ruleNode : ruleNodes) {
                            String regex = ruleNode.valueOf("@regex");
                            if (!path.matches(regex)) continue;
                            logger.debug("Global permissions found by matching " + regex + " for " + role, new Object[0]);
                            List permissionNodes = ruleNode.selectNodes("allowed-permissions/permission");
                            for (Node permissionNode : permissionNodes) {
                                String permission = permissionNode.getText().toLowerCase();
                                logger.debug("adding global permissions " + permission + " to " + path + " for " + role, new Object[0]);
                                permissions.add(permission);
                            }
                        }
                        continue;
                    }
                    logger.debug("No default role is set. adding default permission: read", new Object[0]);
                    permissions.add("read");
                    continue;
                }
                logger.debug("No default site is set. adding default permission: read", new Object[0]);
                permissions.add("read");
            }
        } else {
            logger.debug("No user or group matching found. adding default permission: read", new Object[0]);
            permissions.add("read");
        }
        return permissions;
    }

    protected String getPermissionsKey(String site, String filename) {
        return new StringBuffer(site).append(":").append(filename).toString();
    }

    protected void addUserRoles(Set<String> roles, String site, String user) {
        if (!StringUtils.isEmpty((String)user)) {
            Set<String> userRoles = this.getUserRoles(site, user);
            logger.debug("Adding roles by user: " + userRoles, new Object[0]);
            roles.addAll(userRoles);
        }
    }

    @Override
    public Set<String> getUserRoles(String site, String user) {
        Set<String> groups = this.securityProvider.getUserGroups(user);
        if (groups != null && groups.size() > 0) {
            logger.debug("Groups for " + user + " in " + site + ": " + groups, new Object[0]);
            PermissionsConfigTO rolesConfig = this.permissionsConfigMap.get(this.getPermissionsKey(site, this.roleMappingsFileName));
            HashSet<String> userRoles = new HashSet<String>();
            if (rolesConfig != null) {
                Map<String, List<String>> rolesMap = rolesConfig.getRoles();
                for (String group : groups) {
                    String groupName = group.replaceFirst("GROUP_", "");
                    List<String> roles = rolesMap.get(groupName);
                    if (roles == null) continue;
                    userRoles.addAll(roles);
                }
            }
            return userRoles;
        }
        logger.debug("No groups found for " + user + " in " + site, new Object[0]);
        return new HashSet<String>(0);
    }

    protected void addGroupRoles(Set<String> roles, String site, List<String> groups, PermissionsConfigTO rolesConfig) {
        if (groups != null) {
            Map<String, List<String>> rolesMap = rolesConfig.getRoles();
            for (String group : groups) {
                List<String> groupRoles = rolesMap.get(group);
                if (groupRoles == null) continue;
                logger.debug("Adding roles by group " + group + ": " + roles, new Object[0]);
                roles.addAll(groupRoles);
            }
        }
    }

    protected Set<String> populateUserPermissions(String site, String path, Set<String> roles, PermissionsConfigTO permissionsConfig) {
        HashSet<String> permissions = new HashSet<String>();
        if (roles != null && !roles.isEmpty()) {
            for (String role : roles) {
                Map<String, Map<String, List<Node>>> permissionsMap = permissionsConfig.getPermissions();
                Map<String, List<Node>> siteRoles = permissionsMap.get(site);
                if (siteRoles == null || siteRoles.isEmpty()) {
                    siteRoles = permissionsMap.get("*");
                }
                if (siteRoles != null && !siteRoles.isEmpty()) {
                    List<Node> ruleNodes = siteRoles.get(role);
                    if (ruleNodes == null || ruleNodes.isEmpty()) {
                        ruleNodes = siteRoles.get("*");
                    }
                    if (ruleNodes != null && !ruleNodes.isEmpty()) {
                        for (Node ruleNode : ruleNodes) {
                            String regex = ruleNode.valueOf("@regex");
                            if (!path.matches(regex)) continue;
                            logger.debug("Permissions found by matching " + regex + " for " + role + " in " + site, new Object[0]);
                            List permissionNodes = ruleNode.selectNodes("allowed-permissions/permission");
                            for (Node permissionNode : permissionNodes) {
                                String permission = permissionNode.getText().toLowerCase();
                                logger.debug("adding permissions " + permission + " to " + path + " for " + role + " in " + site, new Object[0]);
                                permissions.add(permission);
                            }
                        }
                        continue;
                    }
                    logger.debug("No default role is set. adding default permission: read", new Object[0]);
                    permissions.add("read");
                    continue;
                }
                logger.debug("No default site is set. adding default permission: read", new Object[0]);
                permissions.add("read");
            }
        } else {
            logger.debug("No user or group matching found. adding default permission: read", new Object[0]);
            permissions.add("read");
        }
        return permissions;
    }

    @Override
    protected void loadConfiguration(String key) {
        String siteConfigPath = this.configPath.replaceFirst("\\{site\\}", this.getSiteFromKey(key));
        String siteConfigFullPath = siteConfigPath + "/" + this.getFilenameFromKey(key);
        Document document = null;
        try {
            document = this.contentService.getContentAsDocument(siteConfigFullPath);
        }
        catch (DocumentException e) {
            logger.error("Permission mapping not found for " + key, new Object[0]);
        }
        if (document != null) {
            PermissionsConfigTO config = new PermissionsConfigTO();
            config.setMapping(document);
            Element root = document.getRootElement();
            this.loadRoles(root, config);
            this.loadPermissions(root, config);
            config.setKey(key);
            config.setLastUpdated(new Date());
            this.permissionsConfigMap.put(key, config);
        } else {
            logger.error("Permission mapping not found for " + key, new Object[0]);
        }
    }

    protected void loadRoles(Element root, PermissionsConfigTO config) {
        if (root.getName().equals("role-mappings")) {
            Map<String, List<String>> rolesMap = new HashMap<String, List<String>>();
            List userNodes = root.selectNodes("users/user");
            rolesMap = this.getRoles(userNodes, rolesMap);
            List groupNodes = root.selectNodes("groups/group");
            rolesMap = this.getRoles(groupNodes, rolesMap);
            config.setRoles(rolesMap);
        }
    }

    protected Map<String, List<String>> getRoles(List<Node> nodes, Map<String, List<String>> rolesMap) {
        for (Node node : nodes) {
            String name = node.valueOf("@name");
            if (StringUtils.isEmpty((String)name)) continue;
            List roleNodes = node.selectNodes("role");
            ArrayList<String> roles = new ArrayList<String>();
            for (Node roleNode : roleNodes) {
                roles.add(roleNode.getText());
            }
            rolesMap.put(name, roles);
        }
        return rolesMap;
    }

    protected void loadPermissions(Element root, PermissionsConfigTO config) {
        if (root.getName().equals("permissions")) {
            HashMap<String, Map<String, List<Node>>> permissionsMap = new HashMap<String, Map<String, List<Node>>>();
            List siteNodes = root.selectNodes("site");
            for (Node siteNode : siteNodes) {
                String siteId = siteNode.valueOf("@id");
                if (StringUtils.isEmpty((String)siteId)) continue;
                List roleNodes = siteNode.selectNodes("role");
                HashMap<String, List> rules = new HashMap<String, List>();
                for (Node roleNode : roleNodes) {
                    String roleName = roleNode.valueOf("@name");
                    List ruleNodes = roleNode.selectNodes("rule");
                    rules.put(roleName, ruleNodes);
                }
                permissionsMap.put(siteId, rules);
            }
            config.setPermissions(permissionsMap);
        }
    }

    protected String getSiteFromKey(String key) {
        if (key.contains(":")) {
            return key.substring(0, key.indexOf(":"));
        }
        return key;
    }

    @Override
    public void addUserGroup(String groupName) {
        this.securityProvider.addUserGroup(groupName);
    }

    @Override
    public void addUserGroup(String parentGroup, String groupName) {
        this.securityProvider.addUserGroup(parentGroup, groupName);
    }

    @Override
    public void addUserToGroup(String groupName, String user) {
        this.securityProvider.addUserToGroup(groupName, user);
    }

    protected String getFilenameFromKey(String key) {
        return key.substring(key.indexOf(":") + 1);
    }

    @Override
    protected TimeStamped getConfigurationById(String key) {
        return this.permissionsConfigMap.get(key);
    }

    @Override
    protected void removeConfiguration(String key) {
        if (!StringUtils.isEmpty((String)key)) {
            this.permissionsConfigMap.remove(key);
        }
    }

    @Override
    protected void checkForUpdate(String site) {
        if (StringUtils.isNotEmpty((String)site)) {
            super.checkForUpdate(this.getPermissionsKey(site, this.roleMappingsFileName));
            super.checkForUpdate(this.getPermissionsKey(site, this.permissionsFileName));
        }
        if (this.isGlobalPermissionsConfigUpdated()) {
            this.loadGlobalPermissionsConfiguration();
        }
        if (this.isGlobalRolesConfigUpdated()) {
            this.loadGlobalRolesConfiguration();
        }
    }

    protected boolean isGlobalRolesConfigUpdated() {
        String globalRolesKey = "###GLOBAL###:" + this.globalRoleMappingsFileName;
        TimeStamped config = this.getConfigurationById(globalRolesKey);
        if (config == null) {
            return true;
        }
        String siteConfigFullPath = this.globalConfigPath + "/" + this.globalRoleMappingsFileName;
        if (this.contentRepository.contentExists(siteConfigFullPath)) {
            Date modifiedDate = this.contentRepository.getModifiedDate(siteConfigFullPath);
            if (modifiedDate == null) {
                return false;
            }
            return modifiedDate.after(config.getLastUpdated());
        }
        this.removeConfiguration(globalRolesKey);
        return true;
    }

    protected boolean isGlobalPermissionsConfigUpdated() {
        String globalPermissionsKey = "###GLOBAL###:" + this.globalPermissionsFileName;
        TimeStamped config = this.getConfigurationById(globalPermissionsKey);
        if (config == null) {
            return true;
        }
        String siteConfigFullPath = this.globalConfigPath + "/" + this.globalPermissionsFileName;
        if (this.contentRepository.contentExists(siteConfigFullPath)) {
            Date modifiedDate = this.contentRepository.getModifiedDate(siteConfigFullPath);
            if (modifiedDate == null) {
                return false;
            }
            return modifiedDate.after(config.getLastUpdated());
        }
        this.removeConfiguration(globalPermissionsKey);
        return true;
    }

    protected void loadGlobalPermissionsConfiguration() {
        String globalPermissionsConfigPath = this.globalConfigPath + "/" + this.globalPermissionsFileName;
        Document document = null;
        try {
            document = this.contentService.getContentAsDocument(globalPermissionsConfigPath);
        }
        catch (DocumentException e) {
            logger.error("Global permission mapping not found (path: {0})", globalPermissionsConfigPath);
        }
        if (document != null) {
            PermissionsConfigTO config = new PermissionsConfigTO();
            config.setMapping(document);
            Element root = document.getRootElement();
            this.loadPermissions(root, config);
            String globalPermissionsKey = "###GLOBAL###:" + this.globalPermissionsFileName;
            config.setKey(globalPermissionsKey);
            config.setLastUpdated(new Date());
            this.permissionsConfigMap.put(globalPermissionsKey, config);
        } else {
            logger.error("Global permission mapping not found (path: {0})", globalPermissionsConfigPath);
        }
    }

    protected void loadGlobalRolesConfiguration() {
        String globalRolesConfigPath = this.globalConfigPath + "/" + this.globalRoleMappingsFileName;
        Document document = null;
        try {
            document = this.contentService.getContentAsDocument(globalRolesConfigPath);
        }
        catch (DocumentException e) {
            logger.error("Global roles mapping not found (path: {0})", globalRolesConfigPath);
        }
        if (document != null) {
            PermissionsConfigTO config = new PermissionsConfigTO();
            config.setMapping(document);
            Element root = document.getRootElement();
            this.loadRoles(root, config);
            String globalRolesKey = "###GLOBAL###:" + this.globalRoleMappingsFileName;
            config.setKey(globalRolesKey);
            config.setLastUpdated(new Date());
            this.permissionsConfigMap.put(globalRolesKey, config);
        } else {
            logger.error("Global roles mapping not found (path: {0})", globalRolesConfigPath);
        }
    }

    @Override
    protected String getConfigFullPath(String key) {
        if (!StringUtils.isEmpty((String)key)) {
            String[] keys = key.split(":");
            if (keys.length == 2) {
                String site = keys[0];
                String fileName = keys[1];
                String siteConfigPath = this.configPath.replaceAll("\\{site\\}", site);
                String siteConfigFullPath = siteConfigPath + "/" + fileName;
                return siteConfigFullPath;
            }
            logger.error("Invalid content type config key provided: " + key + " site, content type is expected.", new Object[0]);
        } else {
            logger.error("Key cannot be empty. site, content type is expected.", new Object[0]);
        }
        return null;
    }

    @Override
    public void reloadConfiguration(String site) {
        this.loadConfiguration(this.getPermissionsKey(site, this.permissionsFileName));
        this.loadConfiguration(this.getPermissionsKey(site, this.roleMappingsFileName));
    }

    @Override
    public void reloadGlobalConfiguration() {
        this.loadGlobalPermissionsConfiguration();
        this.loadGlobalRolesConfiguration();
    }

    @Override
    public boolean logout() {
        return this.securityProvider.logout();
    }

    @Override
    public void register() {
        this.getServicesManager().registerService(SecurityService.class, this);
    }

    public String getRoleMappingsFileName() {
        return this.roleMappingsFileName;
    }

    public void setRoleMappingsFileName(String roleMappingsFileName) {
        this.roleMappingsFileName = roleMappingsFileName;
    }

    public String getPermissionsFileName() {
        return this.permissionsFileName;
    }

    public void setPermissionsFileName(String permissionsFileName) {
        this.permissionsFileName = permissionsFileName;
    }

    public String getGlobalConfigPath() {
        return this.globalConfigPath;
    }

    public void setGlobalConfigPath(String globalConfigPath) {
        this.globalConfigPath = globalConfigPath;
    }

    public String getGlobalRoleMappingsFileName() {
        return this.globalRoleMappingsFileName;
    }

    public void setGlobalRoleMappingsFileName(String globalRoleMappingsFileName) {
        this.globalRoleMappingsFileName = globalRoleMappingsFileName;
    }

    public String getGlobalPermissionsFileName() {
        return this.globalPermissionsFileName;
    }

    public void setGlobalPermissionsFileName(String globalPermissionsFileName) {
        this.globalPermissionsFileName = globalPermissionsFileName;
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public ContentTypeService getContentTypeService() {
        return this.contentTypeService;
    }

    public void setContentTypeService(ContentTypeService contentTypeService) {
        this.contentTypeService = contentTypeService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }
}

