/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.studio.api.v1.service.security.SecurityProvider;

public class TestSecurityProvider
implements SecurityProvider {
    private static final Map<String, Set<String>> USER_GROUPS = new HashMap<String, Set<String>>(){
        {
            HashSet<String> adminGroups = new HashSet<String>();
            adminGroups.add("crafter-admin");
            adminGroups.add("crafter-create-sites");
            HashSet<String> authorGroups = new HashSet<String>();
            authorGroups.add("crafter-author");
            this.put("admin", adminGroups);
            this.put("author", authorGroups);
        }
    };
    private static final Map<String, Map<String, String>> USER_PROFILES = new HashMap<String, Map<String, String>>(){
        {
            HashMap<String, String> adminProfile = new HashMap<String, String>();
            adminProfile.put("username", "admin");
            adminProfile.put("email", "evaladmin@craftersoftware.com");
            adminProfile.put("firstName", "Joe");
            adminProfile.put("lastName", "Admin");
            HashMap<String, String> authorProfile = new HashMap<String, String>();
            authorProfile.put("username", "author");
            authorProfile.put("email", "evalauthor@craftersoftware.com");
            authorProfile.put("firstName", "Joe");
            authorProfile.put("lastName", "Author");
            this.put("admin", adminProfile);
            this.put("author", authorProfile);
            this.put(null, new HashMap());
        }
    };
    private static final List<String> USER_FAKETICKETS = new ArrayList<String>(){
        {
            this.add("admin_FAKETICKET");
            this.add("author_FAKETICKET");
        }
    };
    Map<String, String> activeUser = new HashMap<String, String>();
    Map<String, String> activeProcess = new HashMap<String, String>();

    @Override
    public Set<String> getUserGroups(String user) {
        return USER_GROUPS.get(user);
    }

    @Override
    public String getCurrentUser() {
        RequestContext context = RequestContext.getCurrent();
        String username = null;
        username = context != null ? this.activeUser.get("username") : this.activeProcess.get("username");
        return username;
    }

    @Override
    public Map<String, String> getUserProfile(String user) {
        return USER_PROFILES.get(user);
    }

    @Override
    public boolean validateTicket(String ticket) {
        String theTicket = ticket;
        RequestContext context = RequestContext.getCurrent();
        if (theTicket == null) {
            theTicket = context != null ? this.activeUser.get("ticket") : this.activeProcess.get("ticket");
        }
        return USER_FAKETICKETS.contains(theTicket);
    }

    @Override
    public String authenticate(String username, String password) {
        RequestContext context = RequestContext.getCurrent();
        String ticket = null;
        if (this.getUserProfile(username) != null) {
            ticket = username + "_FAKETICKET";
            if (context != null) {
                this.activeUser.put("username", username);
                this.activeUser.put("ticket", ticket);
            } else {
                this.activeProcess.put("username", username);
                this.activeProcess.put("ticket", ticket);
            }
        }
        return ticket;
    }

    @Override
    public void addUserGroup(String groupName) {
    }

    @Override
    public void addUserGroup(String parentGroup, String groupName) {
    }

    @Override
    public void addUserToGroup(String groupName, String user) {
    }

    @Override
    public String getCurrentToken() {
        return this.activeProcess.get("ticket");
    }

    @Override
    public boolean logout() {
        this.activeUser.remove("username");
        this.activeUser.remove("ticket");
        return true;
    }
}

