/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.site;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.craftercms.commons.ebus.annotations.EventHandler;
import org.craftercms.commons.ebus.annotations.EventSelectorType;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.dal.SiteFeedMapper;
import org.craftercms.studio.api.v1.ebus.ClearCacheEventMessage;
import org.craftercms.studio.api.v1.ebus.DistributedEventMessage;
import org.craftercms.studio.api.v1.ebus.DistributedPeerEBusFacade;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.ConfigurableServiceBase;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.api.v1.service.configuration.DeploymentEndpointConfig;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.configuration.SiteEnvironmentConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ContentTypeService;
import org.craftercms.studio.api.v1.service.content.DmPageNavigationOrderService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.dependency.DmDependencyService;
import org.craftercms.studio.api.v1.service.deployment.DeploymentService;
import org.craftercms.studio.api.v1.service.notification.NotificationService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteConfigNotFoundException;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.DeploymentConfigTO;
import org.craftercms.studio.api.v1.to.DeploymentEndpointConfigTO;
import org.craftercms.studio.api.v1.to.DmPathTO;
import org.craftercms.studio.api.v1.to.EnvironmentConfigTO;
import org.craftercms.studio.api.v1.to.PublishingChannelGroupConfigTO;
import org.craftercms.studio.api.v1.to.SiteBlueprintTO;
import org.craftercms.studio.api.v1.to.SiteTO;
import org.craftercms.studio.api.v1.to.SitesConfigTO;
import org.craftercms.studio.api.v1.to.TimeStamped;
import org.craftercms.studio.impl.v1.service.site.SiteServiceDAL;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Autowired;
import reactor.core.Reactor;
import reactor.event.Event;

public class SiteServiceImpl
extends ConfigurableServiceBase
implements SiteService {
    private static final Logger logger = LoggerFactory.getLogger(SiteServiceImpl.class);
    protected SiteServiceDAL _siteServiceDAL;
    protected ServicesConfig servicesConfig;
    protected ContentService contentService;
    protected String sitesConfigPath;
    protected String environment;
    protected SiteEnvironmentConfig environmentConfig;
    protected DeploymentEndpointConfig deploymentEndpointConfig;
    protected String configRoot = null;
    protected String environmentConfigPath = null;
    protected ContentRepository contentRepository;
    protected ObjectStateService objectStateService;
    protected DmDependencyService dmDependencyService;
    protected SecurityService securityService;
    protected ActivityService activityService;
    protected DeploymentService deploymentService;
    protected ObjectMetadataManager objectMetadataManager;
    protected DmPageNavigationOrderService dmPageNavigationOrderService;
    protected Reactor repositoryRector;
    protected NotificationService notificationService;
    protected ContentTypeService contentTypeService;
    protected DistributedPeerEBusFacade distributedPeerEBusFacade;
    @Autowired
    protected SiteFeedMapper siteFeedMapper;
    protected Map<String, SiteTO> sitesMappings;
    protected SitesConfigTO sitesConfig = null;

    @Override
    public void register() {
        this._servicesManager.registerService(SiteService.class, this);
    }

    @Override
    public boolean writeConfiguration(String site, String path, InputStream content) {
        boolean toRet = this.contentRepository.writeContent("/cstudio/config/sites/" + site + "/" + path, content);
        this.reloadSiteConfiguration(site);
        return toRet;
    }

    @Override
    public boolean writeConfiguration(String path, InputStream content) {
        boolean toRetrun = this.contentRepository.writeContent(path, content);
        this.reloadSiteConfigurations();
        return toRetrun;
    }

    @Override
    public Map<String, Object> getConfiguration(String path) {
        return null;
    }

    @Override
    protected TimeStamped getConfigurationById(String key) {
        return this.sitesConfig;
    }

    @Override
    protected void removeConfiguration(String key) {
        if (!StringUtils.isEmpty((String)key)) {
            this.sitesConfig = null;
        }
    }

    @Override
    protected void loadConfiguration(String key) {
        String configLocation = this.configPath.replaceFirst("\\{site\\}", key).replaceFirst("\\{environment\\}", this.environment);
        configLocation = configLocation + "/" + this.configFileName;
        Document document = null;
        try {
            document = this.contentService.getContentAsDocument(configLocation);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        if (document != null) {
            Element root = document.getRootElement();
            SitesConfigTO config = new SitesConfigTO();
            Map<String, String> sitesMenu = this.loadMap(root.selectNodes("sites-menu/menu-item"));
            config.setSitesMenu(sitesMenu);
            Map<String, String> siteTypes = this.loadMap(root.selectNodes("site-types/site-type"));
            config.setSiteTypes(siteTypes);
            Map<String, String> repositoryTypes = this.loadMap(root.selectNodes("repository-types/repository-type"));
            config.setRepositoryTypes(repositoryTypes);
            config.setSitesLocation(root.valueOf("sites-location"));
            config.setLastUpdated(new Date());
            this.sitesConfig = config;
        }
    }

    protected Map<String, String> loadMap(List<Node> nodes) {
        if (nodes != null && nodes.size() > 0) {
            HashMap<String, String> mapping = new HashMap<String, String>();
            for (Node node : nodes) {
                String key = node.valueOf("@key");
                String value = node.getText();
                mapping.put(key, value);
            }
            return mapping;
        }
        return new HashMap<String, String>(0);
    }

    @Override
    public Document getSiteConfiguration(String site) throws SiteConfigNotFoundException {
        return this._siteServiceDAL.getSiteConfiguration(site);
    }

    @Override
    public Map<String, Object> getConfiguration(String site, String path, boolean applyEnv) {
        String configPath = "";
        configPath = StringUtils.isEmpty((String)site) ? this.configRoot + path : (applyEnv ? this.environmentConfigPath.replaceAll("\\{site\\}", site).replaceAll("\\{environment\\}", this.environment) + path : this.sitesConfigPath + "/" + site + path);
        logger.debug("[SITESERVICE] loading configuration at " + configPath, new Object[0]);
        String configContent = this.contentService.getContentAsString(configPath);
        JSONObject response = null;
        Map<String, Object> toRet = null;
        if (configContent != null) {
            configContent = configContent.replaceAll("\\n([\\s]+)?+", "");
            configContent = configContent.replaceAll("<!--(.*?)-->", "");
            toRet = this.convertNodesFromXml(configContent);
        } else {
            response = new JSONObject();
        }
        return toRet;
    }

    private Map<String, Object> convertNodesFromXml(String xml) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
            Document document = DocumentHelper.parseText((String)xml);
            return this.createMap(document.getRootElement());
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Map<String, Object> createMap(Element element) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int size = element.nodeCount();
        for (int i = 0; i < size; ++i) {
            Node currentNode = element.node(i);
            if (!(currentNode instanceof Element)) continue;
            Element currentElement = (Element)currentNode;
            String key = currentElement.getName();
            Object toAdd = null;
            toAdd = currentElement.isTextOnly() ? currentElement.getStringValue() : this.createMap(currentElement);
            if (map.containsKey(key)) {
                Object value = map.get(key);
                List<Object> listOfValues = new ArrayList();
                if (value instanceof List) {
                    listOfValues = (List)value;
                } else {
                    listOfValues.add(value);
                }
                listOfValues.add(toAdd);
                map.put(key, listOfValues);
                continue;
            }
            map.put(key, toAdd);
        }
        return map;
    }

    protected void checkForUpdates() {
    }

    protected void loadSiteConfig(String site, SiteTO siteConfig) {
        siteConfig.setWebProject(this.servicesConfig.getWemProject(site));
        siteConfig.setRepositoryRootPath("/wem-projects/" + site + "/" + site + "/work-area");
    }

    protected void loadSiteEnvironmentConfig(String site, SiteTO siteConfig) {
        logger.debug("Loading site environment configuration for " + site + "; Environemnt: " + this.environment, new Object[0]);
        EnvironmentConfigTO environmentConfigTO = this.environmentConfig.getEnvironmentConfig(site);
        if (environmentConfigTO == null) {
            logger.error("Environment configuration for site " + site + " does not exist.", new Object[0]);
            return;
        }
        siteConfig.setLiveUrl(environmentConfigTO.getLiveServerUrl());
        siteConfig.setAuthoringUrl(environmentConfigTO.getAuthoringServerUrl());
        siteConfig.setAuthoringUrlPattern(environmentConfigTO.getAuthoringServerUrlPattern());
        siteConfig.setPreviewUrl(environmentConfigTO.getPreviewServerUrl());
        siteConfig.setPreviewUrlPattern(environmentConfigTO.getPreviewServerUrlPattern());
        siteConfig.setAdminEmail(environmentConfigTO.getAdminEmailAddress());
        siteConfig.setCookieDomain(environmentConfigTO.getCookieDomain());
        siteConfig.setOpenSiteDropdown(environmentConfigTO.getOpenDropdown());
        siteConfig.setFormServerUrl(environmentConfigTO.getFormServerUrlPattern());
        siteConfig.setPublishingChannelGroupConfigs(environmentConfigTO.getPublishingChannelGroupConfigs());
    }

    protected void loadSiteDeploymentConfig(String site, SiteTO siteConfig) {
        logger.debug("Loading deployment configuration for " + site + "; Environment: " + this.environment, new Object[0]);
        DeploymentConfigTO deploymentConfig = this.deploymentEndpointConfig.getSiteDeploymentConfig(site);
        if (deploymentConfig == null) {
            logger.error("Deployment configuration for site " + site + " does not exist.", new Object[0]);
            return;
        }
        siteConfig.setDeploymentEndpointConfigs(deploymentConfig.getEndpointMapping());
    }

    @Override
    public DeploymentEndpointConfigTO getDeploymentEndpoint(String site, String endpoint) {
        return this.deploymentEndpointConfig.getDeploymentConfig(site, endpoint);
    }

    @Override
    public Map<String, PublishingChannelGroupConfigTO> getPublishingChannelGroupConfigs(String site) {
        return this.environmentConfig.getPublishingChannelGroupConfigs(site);
    }

    @Override
    public List<SiteFeed> getUserSites(String user) {
        String username = user;
        if (StringUtils.isEmpty((String)username)) {
            username = this.securityService.getCurrentUser();
        }
        List<SiteFeed> sites = this.siteFeedMapper.getSites();
        ArrayList<SiteFeed> toRet = new ArrayList<SiteFeed>();
        for (SiteFeed site : sites) {
            Set<String> userRoles = this.securityService.getUserRoles(site.getSiteId(), username);
            if (!CollectionUtils.isNotEmpty(userRoles)) continue;
            site.setLiveUrl(this.getLiveServerUrl(site.getSiteId()));
            toRet.add(site);
        }
        return toRet;
    }

    @Override
    public DeploymentEndpointConfigTO getPreviewDeploymentEndpoint(String site) {
        String endpoint = this.environmentConfig.getPreviewDeploymentEndpoint(site);
        return this.getDeploymentEndpoint(site, endpoint);
    }

    @Override
    public Set<String> getAllAvailableSites() {
        List<SiteFeed> sites = this.siteFeedMapper.getSites();
        HashSet<String> toRet = new HashSet<String>();
        for (SiteFeed site : sites) {
            toRet.add(site.getSiteId());
        }
        return toRet;
    }

    @Override
    public String getLiveEnvironmentName(String site) {
        PublishingChannelGroupConfigTO pcgcTO = this.environmentConfig.getLiveEnvironmentPublishingGroup(site);
        if (pcgcTO != null) {
            return pcgcTO.getName();
        }
        return null;
    }

    @Override
    public boolean createSiteFromBlueprint(String blueprintName, String siteName, String siteId, String desc) {
        boolean success = true;
        try {
            this.contentRepository.createFolder("/wem-projects/" + siteId + "/" + siteId, "work-area");
            this.contentRepository.copyContent("/cstudio/blueprints/" + blueprintName + "/site-content", "/wem-projects/" + siteId + "/" + siteId + "/work-area");
            String siteConfigFolder = "/cstudio/config/sites/" + siteId;
            this.contentRepository.createFolder("/cstudio/config/sites/", siteId);
            this.contentRepository.copyContent("/cstudio/blueprints/" + blueprintName + "/site-config", siteConfigFolder);
            this.replaceFileContent(siteConfigFolder + "/site-config.xml", "SITENAME", siteId);
            this.replaceFileContent(siteConfigFolder + "/role-mappings-config.xml", "SITENAME", siteId);
            this.replaceFileContent(siteConfigFolder + "/permission-mappings-config.xml", "SITENAME", siteId);
            this.securityService.addUserGroup("crafter_" + siteId);
            this.securityService.addUserGroup("crafter_" + siteId, "crafter_" + siteId + "_admin");
            this.securityService.addUserGroup("crafter_" + siteId, "crafter_" + siteId + "_author");
            this.securityService.addUserGroup("crafter_" + siteId, "crafter_" + siteId + "_viewer");
            this.securityService.addUserToGroup("crafter_" + siteId + "_admin", this.securityService.getCurrentUser());
            this.createObjectStatesforNewSite(siteId);
            this.extractDependenciesForNewSite(siteId);
            SiteFeed siteFeed = new SiteFeed();
            siteFeed.setName(siteName);
            siteFeed.setSiteId(siteId);
            siteFeed.setDescription(desc);
            this.siteFeedMapper.createSite(siteFeed);
            this.deploymentService.syncAllContentToPreview(siteId);
            this.reloadSiteConfiguration(siteId);
        }
        catch (Exception err) {
            success = false;
            logger.error("Error while creating site", err, new Object[0]);
        }
        return success;
    }

    protected void replaceFileContent(String path, String find, String replace) throws Exception {
        InputStream content = this.contentRepository.getContent(path);
        String contentAsString = IOUtils.toString((InputStream)content);
        contentAsString = contentAsString.replaceAll(find, replace);
        InputStream contentToWrite = IOUtils.toInputStream((String)contentAsString);
        this.contentRepository.writeContent(path, contentToWrite);
    }

    protected void createObjectStatesforNewSite(String site) {
        this.createObjectStateNewSiteObjectFolder(site, this.contentService.expandRelativeSitePath(site, "/"));
    }

    protected void createObjectStateNewSiteObjectFolder(String site, String path) {
        RepositoryItem[] children;
        for (RepositoryItem child : children = this.contentRepository.getContentChildren(path)) {
            if (child.isFolder) {
                this.createObjectStateNewSiteObjectFolder(site, child.path + "/" + child.name);
                continue;
            }
            this.objectStateService.insertNewEntry(site, this.contentService.getRelativeSitePath(site, child.path) + "/" + child.name);
        }
    }

    protected void extractDependenciesForNewSite(String site) {
        HashMap<String, Set<String>> globalDeps = new HashMap<String, Set<String>>();
        this.extractDependenciesItemForNewSite(site, this.contentService.expandRelativeSitePath(site, "/"), globalDeps);
    }

    private void extractDependenciesItemForNewSite(String site, String fullPath, Map<String, Set<String>> globalDeps) {
        RepositoryItem[] children;
        for (RepositoryItem child : children = this.contentRepository.getContentChildren(fullPath)) {
            if (child.isFolder) {
                this.extractDependenciesItemForNewSite(site, child.path + "/" + child.name, globalDeps);
                continue;
            }
            String childFullPath = child.path + "/" + child.name;
            DmPathTO dmPathTO = new DmPathTO(childFullPath);
            String relativePath = dmPathTO.getRelativePath();
            if (childFullPath.endsWith(".xml")) {
                try {
                    Document doc = this.contentService.getContentAsDocument(childFullPath);
                    this.dmDependencyService.extractDependencies(site, relativePath, doc, globalDeps);
                }
                catch (ContentNotFoundException e) {
                    logger.error("Failed to extract dependencies for document: " + childFullPath, e, new Object[0]);
                }
                catch (ServiceException e) {
                    logger.error("Failed to extract dependencies for document: " + childFullPath, e, new Object[0]);
                }
                catch (DocumentException e) {
                    logger.error("Failed to extract dependencies for document: " + childFullPath, (Exception)((Object)e), new Object[0]);
                }
                continue;
            }
            boolean isCss = childFullPath.endsWith(".css");
            boolean isJs = childFullPath.endsWith(".js");
            List<String> templatePatterns = this.servicesConfig.getRenderingTemplatePatterns(site);
            boolean isTemplate = false;
            for (String templatePattern : templatePatterns) {
                Pattern pattern = Pattern.compile(templatePattern);
                Matcher matcher = pattern.matcher(relativePath);
                if (!matcher.matches()) continue;
                isTemplate = true;
                break;
            }
            try {
                if (!isCss && !isJs && !isTemplate) continue;
                StringBuffer sb = new StringBuffer(this.contentService.getContentAsString(childFullPath));
                if (isCss) {
                    this.dmDependencyService.extractDependenciesStyle(site, relativePath, sb, globalDeps);
                    continue;
                }
                if (isJs) {
                    this.dmDependencyService.extractDependenciesJavascript(site, relativePath, sb, globalDeps);
                    continue;
                }
                if (!isTemplate) continue;
                this.dmDependencyService.extractDependenciesTemplate(site, relativePath, sb, globalDeps);
            }
            catch (ServiceException e) {
                logger.error("Failed to extract dependencies for: " + childFullPath, e, new Object[0]);
            }
        }
    }

    @Override
    public boolean deleteSite(String siteId) {
        boolean success = true;
        try {
            this.contentRepository.deleteContent("/wem-projects/" + siteId);
            this.contentRepository.deleteContent("/cstudio/config/sites/" + siteId);
            this.siteFeedMapper.deleteSite(siteId);
            this.activityService.deleteActivitiesForSite(siteId);
            this.dmDependencyService.deleteDependenciesForSite(siteId);
            this.deploymentService.deleteDeploymentDataForSite(siteId);
            this.objectStateService.deleteObjectStatesForSite(siteId);
            this.dmPageNavigationOrderService.deleteSequencesForSite(siteId);
        }
        catch (Exception err) {
            success = false;
        }
        return success;
    }

    @Override
    public SiteBlueprintTO[] getAvailableBlueprints() {
        RepositoryItem[] blueprintsFolders = this.contentRepository.getContentChildren("/cstudio/blueprints");
        SiteBlueprintTO[] blueprints = new SiteBlueprintTO[blueprintsFolders.length];
        int idx = 0;
        for (RepositoryItem folder : blueprintsFolders) {
            SiteBlueprintTO blueprintTO = new SiteBlueprintTO();
            blueprintTO.id = folder.name;
            blueprintTO.label = StringUtils.capitalize((String)folder.name);
            blueprintTO.description = "";
            blueprintTO.screenshots = null;
            blueprints[idx++] = blueprintTO;
        }
        return blueprints;
    }

    @Override
    public String getPreviewServerUrl(String site) {
        return this.environmentConfig.getPreviewServerUrl(site);
    }

    @Override
    public String getLiveServerUrl(String site) {
        return this.environmentConfig.getLiveServerUrl(site);
    }

    @Override
    public String getAdminEmailAddress(String site) {
        return this.environmentConfig.getAdminEmailAddress(site);
    }

    @Override
    protected String getConfigFullPath(String key) {
        return null;
    }

    @Override
    public void reloadSiteConfigurations() {
        Set<String> sites;
        this.reloadGlobalConfiguration();
        if (this.sitesMappings == null) {
            this.sitesMappings = new HashMap<String, SiteTO>();
        }
        if ((sites = this.getAllAvailableSites()) != null && sites.size() > 0) {
            for (String site : sites) {
                this.reloadSiteConfiguration(site);
            }
        } else {
            logger.error("[SITESERVICE] no sites found", new Object[0]);
        }
    }

    @Override
    public void reloadSiteConfiguration(String site) {
        this.reloadSiteConfiguration(site, true);
    }

    @EventHandler(event="cluster.clearCache", ebus="@distributedReactor", type=EventSelectorType.REGEX)
    public void onClearCacheEvent(Event<ClearCacheEventMessage> event) {
        logger.debug("On clear cache event", new Object[0]);
        ClearCacheEventMessage message = (ClearCacheEventMessage)event.getData();
        this.reloadSiteConfiguration(message.getSite(), false);
    }

    @Override
    public void reloadSiteConfiguration(String site, boolean triggerEvent) {
        if (this.sitesMappings == null) {
            this.sitesMappings = new HashMap<String, SiteTO>();
        }
        SiteTO siteConfig = new SiteTO();
        if (this.sitesMappings.containsKey(site)) {
            if (this.servicesConfig.isUpdated(site)) {
                logger.debug("[SITESERVICE] " + site + " configuration is updated. reloading it.", new Object[0]);
                siteConfig = this.sitesMappings.get(site);
                this.loadSiteConfig(site, siteConfig);
            }
            if (this.environmentConfig.isUpdated(site)) {
                logger.debug("[SITESERVICE] " + site + " environment configuration is updated. reloading it.", new Object[0]);
                siteConfig = this.sitesMappings.get(site);
                this.environmentConfig.reloadConfiguration(site);
                this.loadSiteEnvironmentConfig(site, siteConfig);
            }
            if (this.deploymentEndpointConfig.isUpdated(site)) {
                logger.debug("[SITESERVICE] " + site + " deployment configuration is updated. reloading it.", new Object[0]);
                siteConfig = this.sitesMappings.get(site);
                this.deploymentEndpointConfig.reloadConfiguration(site);
                this.loadSiteDeploymentConfig(site, siteConfig);
            }
        } else {
            logger.debug("[SITESERVICE] loading site configuration for " + site, new Object[0]);
            siteConfig.setSite(site);
            siteConfig.setEnvironment(this.environment);
            this.loadSiteConfig(site, siteConfig);
            this.environmentConfig.reloadConfiguration(site);
            this.loadSiteEnvironmentConfig(site, siteConfig);
            this.deploymentEndpointConfig.reloadConfiguration(site);
            this.loadSiteDeploymentConfig(site, siteConfig);
            this.sitesMappings.put(site, siteConfig);
        }
        this.notificationService.reloadConfiguration(site);
        this.securityService.reloadConfiguration(site);
        this.contentTypeService.reloadConfiguration(site);
        if (triggerEvent) {
            ClearCacheEventMessage message = new ClearCacheEventMessage(site);
            DistributedEventMessage distributedEventMessage = new DistributedEventMessage();
            distributedEventMessage.setEventKey("cluster.clearCache");
            distributedEventMessage.setMessageClass(ClearCacheEventMessage.class);
            distributedEventMessage.setMessage(message);
            this.distributedPeerEBusFacade.notifyCluster(distributedEventMessage);
        }
    }

    @Override
    public void reloadGlobalConfiguration() {
        this.securityService.reloadGlobalConfiguration();
    }

    public SiteServiceDAL getSiteService() {
        return this._siteServiceDAL;
    }

    public void setSiteServiceDAL(SiteServiceDAL service) {
        this._siteServiceDAL = service;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public String getSitesConfigPath() {
        return this.sitesConfigPath;
    }

    public void setSitesConfigPath(String sitesConfigPath) {
        this.sitesConfigPath = sitesConfigPath;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public SiteEnvironmentConfig getEnvironmentConfig() {
        return this.environmentConfig;
    }

    public void setEnvironmentConfig(SiteEnvironmentConfig environmentConfig) {
        this.environmentConfig = environmentConfig;
    }

    public DeploymentEndpointConfig getDeploymentEndpointConfig() {
        return this.deploymentEndpointConfig;
    }

    public void setDeploymentEndpointConfig(DeploymentEndpointConfig deploymentEndpointConfig) {
        this.deploymentEndpointConfig = deploymentEndpointConfig;
    }

    public String getConfigRoot() {
        return this.configRoot;
    }

    public void setConfigRoot(String configRoot) {
        this.configRoot = configRoot;
    }

    public String getEnvironmentConfigPath() {
        return this.environmentConfigPath;
    }

    public void setEnvironmentConfigPath(String environmentConfigPath) {
        this.environmentConfigPath = environmentConfigPath;
    }

    public ContentRepository getContenetRepository() {
        return this.contentRepository;
    }

    @Override
    public void setContentRepository(ContentRepository repo) {
        this.contentRepository = repo;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public DmDependencyService getDmDependencyService() {
        return this.dmDependencyService;
    }

    public void setDmDependencyService(DmDependencyService dmDependencyService) {
        this.dmDependencyService = dmDependencyService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public ActivityService getActivityService() {
        return this.activityService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public DeploymentService getDeploymentService() {
        return this.deploymentService;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public DmPageNavigationOrderService getDmPageNavigationOrderService() {
        return this.dmPageNavigationOrderService;
    }

    public void setDmPageNavigationOrderService(DmPageNavigationOrderService dmPageNavigationOrderService) {
        this.dmPageNavigationOrderService = dmPageNavigationOrderService;
    }

    public Reactor getRepositoryRector() {
        return this.repositoryRector;
    }

    public void setRepositoryRector(Reactor repositoryRector) {
        this.repositoryRector = repositoryRector;
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public ContentTypeService getContentTypeService() {
        return this.contentTypeService;
    }

    public void setContentTypeService(ContentTypeService contentTypeService) {
        this.contentTypeService = contentTypeService;
    }

    public DistributedPeerEBusFacade getDistributedPeerEBusFacade() {
        return this.distributedPeerEBusFacade;
    }

    public void setDistributedPeerEBusFacade(DistributedPeerEBusFacade distributedPeerEBusFacade) {
        this.distributedPeerEBusFacade = distributedPeerEBusFacade;
    }
}

