/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.translation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.translation.TranslationService;
import org.craftercms.studio.impl.v1.service.translation.TranslationProvider;
import org.craftercms.studio.impl.v1.service.translation.dal.TranslationContentDAL;

public class TranslationServiceImpl
implements TranslationService {
    private static final Logger logger = LoggerFactory.getLogger(TranslationServiceImpl.class);
    protected final String MSG_ERROR_SUBMITTING_ITEM_FOR_TRANSLATION = "err_submit_item_for_translation";
    protected final String MSG_ERR_TRANSLATION_CLOSE_STREAM_ON_SOURCE_CONTENT = "err_close_stream_on_translation_source_content";
    protected TranslationProvider _translationProvider;
    protected TranslationContentDAL _translationContentDAL;

    @Override
    public List<String> calculateTargetTranslationSet(String srcSite, List<String> srcPaths, String targetSite) {
        return this._translationContentDAL.calculateTargetTranslationSet(srcSite, srcPaths, targetSite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void translate(String sourceSite, String sourceLanguage, String targetLanguage, String path) {
        block13: {
            InputStream untranslatedContentStream = null;
            try {
                untranslatedContentStream = this._translationContentDAL.getContent(sourceSite, path);
            }
            catch (ContentNotFoundException e) {
                logger.error("Content not found for {0}:{1}", e, sourceSite, path);
            }
            if (untranslatedContentStream != null) {
                byte[] untranslatedBytes = IOUtils.toByteArray((InputStream)untranslatedContentStream);
                ByteArrayInputStream detachedContentStream = new ByteArrayInputStream(untranslatedBytes);
                this._translationProvider.translate(sourceSite, sourceLanguage, targetLanguage, path, detachedContentStream);
                try {
                    untranslatedContentStream.close();
                }
                catch (Exception err) {
                    logger.error("err_close_stream_on_translation_source_content", err, sourceSite, sourceLanguage, targetLanguage, path);
                }
                break block13;
                catch (IOException err) {
                    try {
                        logger.error("err_submit_item_for_translation", err, sourceSite, sourceLanguage, targetLanguage, path);
                    }
                    catch (Throwable throwable) {
                        try {
                            untranslatedContentStream.close();
                        }
                        catch (Exception err2) {
                            logger.error("err_close_stream_on_translation_source_content", err2, sourceSite, sourceLanguage, targetLanguage, path);
                        }
                        throw throwable;
                    }
                    try {
                        untranslatedContentStream.close();
                    }
                    catch (Exception err3) {
                        logger.error("err_close_stream_on_translation_source_content", err3, sourceSite, sourceLanguage, targetLanguage, path);
                    }
                }
            }
        }
    }

    @Override
    public int getTranslationStatusForItem(String sourceSite, String targetLanguage, String path) {
        return this._translationProvider.getTranslationStatusForItem(sourceSite, targetLanguage, path);
    }

    @Override
    public InputStream getTranslatedContentForItem(String sourceSite, String targetLanguage, String path) {
        return this._translationProvider.getTranslatedContentForItem(sourceSite, targetLanguage, path);
    }

    @Override
    public void updateSiteWithTranslatedContent(String targetSite, String path, InputStream content) {
        this._translationContentDAL.updateSiteWithTranslatedContent(targetSite, path, content);
    }

    public TranslationContentDAL getTranslationContentDAL() {
        return this._translationContentDAL;
    }

    public void setTranslationContentDAL(TranslationContentDAL dal) {
        this._translationContentDAL = dal;
    }

    public TranslationProvider getTranslationProvider() {
        return this._translationProvider;
    }

    public void setTranslationProvider(TranslationProvider provider) {
        this._translationProvider = provider;
    }
}

