/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.translation.provider.demo;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.impl.v1.service.translation.TranslationProvider;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class DemoTranslationProvider
implements TranslationProvider {
    private static final Logger logger = LoggerFactory.getLogger(DemoTranslationProvider.class);
    protected List<String> _translateElements;
    protected Map<String, Integer> _progress = new HashMap<String, Integer>();
    protected Map<String, byte[]> _content = new HashMap<String, byte[]>();

    @Override
    public void translate(String siteName, String sourceLanguage, String targetLanguage, String filename, InputStream content) {
        try {
            if (content != (InputStream)null) {
                byte[] bytes = IOUtils.toByteArray((InputStream)content);
                this._content.put(filename, bytes);
            }
        }
        catch (Exception err) {
            logger.error("error getting content and storing it in a map as byte array:" + filename, err, new Object[0]);
        }
        this._progress.put(filename, 0);
    }

    @Override
    public int getTranslationStatusForItem(String siteName, String targetLanguage, String path) {
        int progress = 0;
        int value = 0;
        try {
            value = this._progress.get(path);
        }
        catch (Exception err) {
            value = 0;
        }
        progress = value + 30;
        if (progress > 100) {
            progress = 100;
        }
        this._progress.put(path, progress);
        return progress;
    }

    @Override
    public InputStream getTranslatedContentForItem(String siteName, String targetLanguage, String path) {
        ByteArrayInputStream retTranslatedContent = null;
        byte[] contentBytes = this._content.get(path);
        if (contentBytes != null) {
            if (path.endsWith(".xml") || path.endsWith(".XML")) {
                try {
                    ByteArrayInputStream docInputStream = new ByteArrayInputStream(contentBytes);
                    SAXReader saxReader = new SAXReader();
                    Document document = saxReader.read((InputStream)docInputStream);
                    for (String element : this._translateElements) {
                        String value;
                        List valueEls = document.selectNodes("//" + element);
                        if (valueEls == null || valueEls.size() <= 0) continue;
                        String translation = "";
                        Node valueEl = (Node)valueEls.get(0);
                        translation = value = valueEl.getText();
                        Pattern contentPattern = Pattern.compile(">(.*?)<");
                        Matcher regexMatcher = contentPattern.matcher(value);
                        while (regexMatcher.find()) {
                            String content = regexMatcher.group(1);
                            if (".".equals(content.trim())) continue;
                            translation = translation.replaceAll(content, new StringBuffer(content).reverse().toString());
                        }
                        valueEl.setText(translation);
                    }
                    String translatedDocument = document.asXML();
                    retTranslatedContent = new ByteArrayInputStream(translatedDocument.getBytes("UTF-8"));
                }
                catch (Exception err) {
                    logger.error("issue during translation", err, new Object[0]);
                }
            } else {
                retTranslatedContent = new ByteArrayInputStream(contentBytes);
            }
        }
        return retTranslatedContent;
    }

    public List<String> getTranslateElements() {
        return this._translateElements;
    }

    public void setTranslateElements(List<String> list) {
        this._translateElements = list;
    }
}

