/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.translation.workflow.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javolution.util.FastList;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.dependency.DmDependencyService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.service.translation.TranslationService;
import org.craftercms.studio.api.v1.service.workflow.WorkflowItem;
import org.craftercms.studio.api.v1.service.workflow.WorkflowJob;
import org.craftercms.studio.api.v1.service.workflow.WorkflowService;
import org.craftercms.studio.impl.v1.service.workflow.JobStateHandler;
import org.dom4j.Document;
import org.dom4j.Node;

public class KickoffTranslationWorkflowForWaterfallItemsHandler
implements JobStateHandler {
    protected static final String MSG_ERROR_CREATE_NEW_TRANSLATE_JOB = "err_create_new_translate_job";
    private static final Logger logger = LoggerFactory.getLogger(KickoffTranslationWorkflowForWaterfallItemsHandler.class);
    private SiteService _siteService;
    private TranslationService _translationService;
    private DmDependencyService _dependencyService;

    @Override
    public String handleState(WorkflowJob job, WorkflowService workflowService) {
        String retState = job.getCurrentStatus();
        String site = job.getSite();
        try {
            FastList paths = new FastList();
            for (WorkflowItem item : job.getItems()) {
                String path = item.getPath();
                paths.add(path);
                this.getDependents(site, path, (List<String>)paths);
            }
            Document siteConfigEl = this._siteService.getSiteConfiguration(site);
            String sourceLanguage = siteConfigEl.valueOf("/site-config/translation/sourceLanguage");
            List targetEls = siteConfigEl.selectNodes("/site-config/translation/targetSites//targetSite");
            if (paths.size() > 0) {
                for (Node targetEl : targetEls) {
                    String targetSiteId = targetEl.valueOf("id");
                    String basePath = targetEl.valueOf("basePath");
                    String targetLanguage = targetEl.valueOf("targetLanguage");
                    Map<String, String> properties = job.getProperties();
                    properties.put("sourceSite", site);
                    properties.put("sourceLanguage", sourceLanguage);
                    properties.put("targetSite", targetSiteId);
                    properties.put("basePath", basePath);
                    properties.put("targetLanguage", targetLanguage);
                    List<String> targetPaths = this._translationService.calculateTargetTranslationSet(site, (List<String>)paths, targetSiteId);
                    for (String path : targetPaths) {
                        ArrayList<String> submitAsSingleItemList = new ArrayList<String>();
                        submitAsSingleItemList.add(path);
                        workflowService.createJob(targetSiteId, submitAsSingleItemList, "translate", properties);
                    }
                }
            }
            retState = "ended";
        }
        catch (Exception err) {
            logger.error(MSG_ERROR_CREATE_NEW_TRANSLATE_JOB, err, job);
        }
        return retState;
    }

    public SiteService getSiteService() {
        return this._siteService;
    }

    public void setSiteService(SiteService service) {
        this._siteService = service;
    }

    public TranslationService getTranslationService() {
        return this._translationService;
    }

    public void setTranslationService(TranslationService service) {
        this._translationService = service;
    }

    public void setDependencyService(DmDependencyService service) {
        this._dependencyService = service;
    }

    private void getDependents(String site, String path, List<String> dependents) {
        List<String> depPaths = this._dependencyService.getDependencyPaths(site, path);
        for (String depPath : depPaths) {
            if (dependents.contains(depPath) || !depPath.startsWith("/site/")) continue;
            dependents.add(depPath);
            this.getDependents(site, depPath, dependents);
        }
    }
}

