/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.translation.workflow.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.craftercms.studio.api.v1.service.notification.NotificationService;
import org.craftercms.studio.api.v1.service.translation.ProviderException;
import org.craftercms.studio.api.v1.service.translation.TranslationService;
import org.craftercms.studio.api.v1.service.workflow.WorkflowJob;
import org.craftercms.studio.api.v1.service.workflow.WorkflowService;
import org.craftercms.studio.impl.v1.service.workflow.JobStateHandler;

public class UpdateItemTranslationStatusHandler
implements JobStateHandler {
    protected TranslationService _translationService;

    @Override
    public String handleState(WorkflowJob job, WorkflowService workflowService) {
        String retState;
        block4: {
            retState = "WAITING-FOR-TRANSLATION";
            String path = job.getItems().get(0).getPath();
            Map<String, String> prop = job.getProperties();
            String sourceSite = prop.get("sourceSite");
            String targetLanguage = prop.get("targetLanguage");
            try {
                int percentComplete = this._translationService.getTranslationStatusForItem(sourceSite, targetLanguage, path);
                if (percentComplete == 100) {
                    retState = "TRANSLATION-COMPLETE";
                    prop.remove("notified");
                }
            }
            catch (ProviderException ex) {
                String submitter = prop.get("submitter");
                if (prop.put("notified", submitter) == null) {
                    NotificationService service = workflowService.getNotificationService();
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("exception", Matcher.quoteReplacement(ex.dumpStackTrace()));
                    service.sendGenericNotification(sourceSite, path, submitter, submitter, "translation-status-failed", params);
                }
                if (!ex.isFatal()) break block4;
                retState = "ended";
            }
        }
        return retState;
    }

    public TranslationService getTranslationService() {
        return this._translationService;
    }

    public void setTranslationService(TranslationService service) {
        this._translationService = service;
    }
}

