/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.translation.workflow.handler;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.craftercms.studio.api.v1.service.notification.NotificationService;
import org.craftercms.studio.api.v1.service.translation.ProviderException;
import org.craftercms.studio.api.v1.service.translation.TranslationService;
import org.craftercms.studio.api.v1.service.workflow.WorkflowJob;
import org.craftercms.studio.api.v1.service.workflow.WorkflowService;
import org.craftercms.studio.impl.v1.service.workflow.JobStateHandler;

public class UpdateProjectWithTranslationHandler
implements JobStateHandler {
    protected TranslationService _translationService;

    @Override
    public String handleState(WorkflowJob job, WorkflowService workflowService) {
        String retState;
        block5: {
            retState = job.getCurrentStatus();
            String path = job.getItems().get(0).getPath();
            Map<String, String> prop = job.getProperties();
            String sourceSite = prop.get("sourceSite");
            String targetSite = prop.get("targetSite");
            String basePath = prop.get("basePath");
            String targetLanguage = prop.get("targetLanguage");
            try {
                InputStream translatedContent = this._translationService.getTranslatedContentForItem(sourceSite, targetLanguage, path);
                if (translatedContent != null) {
                    if (!"/".equals(basePath)) {
                        path = basePath + path;
                    }
                    this._translationService.updateSiteWithTranslatedContent(targetSite, path, translatedContent);
                    retState = "SITE-UPDATED-WITH-TRANSLATED-CONTENT";
                    prop.remove("notified");
                }
            }
            catch (ProviderException ex) {
                String submitter = prop.get("submitter");
                if (prop.put("notified", submitter) == null) {
                    NotificationService service = workflowService.getNotificationService();
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("exception", Matcher.quoteReplacement(ex.dumpStackTrace()));
                    service.sendGenericNotification(sourceSite, path, submitter, submitter, "translation-retrieval-failed", params);
                }
                if (!ex.isFatal()) break block5;
                retState = "ended";
            }
        }
        return retState;
    }

    public TranslationService getTranslationService() {
        return this._translationService;
    }

    public void setTranslationService(TranslationService service) {
        this._translationService = service;
    }
}

