/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.workflow;

import java.util.HashMap;
import java.util.Map;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.workflow.WorkflowJob;
import org.craftercms.studio.api.v1.service.workflow.WorkflowService;
import org.craftercms.studio.impl.v1.service.workflow.JobStateHandler;

public class WorkflowManager {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowManager.class);
    protected final String MSG_NO_HANDLERS_FOR_WORKFLOW_STATE = "no_handlers_for_workflow_state";
    protected final String MSG_NO_HANDLERS_FOR_WORKFLOW = "no_handlers_for_workflow";
    protected Map<String, Map<String, JobStateHandler>> _jobStateHandlers = new HashMap<String, Map<String, JobStateHandler>>();
    protected WorkflowService _workflowService;

    public void handleJobState(WorkflowJob job) {
        if (job != null) {
            Map<String, JobStateHandler> handlers = this._jobStateHandlers.get(job.getProcessName());
            if (handlers != null) {
                String currentState = job.getCurrentStatus();
                JobStateHandler handler = handlers.get(currentState);
                if (handler != null) {
                    String nextState = handler.handleState(job, this._workflowService);
                    if (nextState != null) {
                        if (nextState != currentState) {
                            job.setCurrentStatus(nextState);
                            this._workflowService.updateJob(job);
                        }
                        return;
                    }
                } else {
                    logger.error("no_handlers_for_workflow_state", job.getProcessName(), job.getCurrentStatus(), job.toString());
                }
            } else {
                logger.error("no_handlers_for_workflow", job.getProcessName(), job.getCurrentStatus(), job.toString());
            }
            this._workflowService.deleteJob(job.getId());
        }
    }

    public Map<String, Map<String, JobStateHandler>> getJobStateHandlers() {
        return this._jobStateHandlers;
    }

    public void setJobStateHandlers(Map<String, Map<String, JobStateHandler>> map) {
        this._jobStateHandlers = map;
    }

    public WorkflowService getWorkflowService() {
        return this._workflowService;
    }

    public void setWorkflowService(WorkflowService service) {
        this._workflowService = service;
    }
}

