/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.workflow;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.dal.ObjectMetadata;
import org.craftercms.studio.api.v1.dal.ObjectState;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceException;
import org.craftercms.studio.api.v1.listener.DmWorkflowListener;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.DmRenameService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.dependency.DependencyRules;
import org.craftercms.studio.api.v1.service.dependency.DmDependencyService;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.service.deployment.DeploymentService;
import org.craftercms.studio.api.v1.service.deployment.DmPublishService;
import org.craftercms.studio.api.v1.service.notification.NotificationService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.objectstate.State;
import org.craftercms.studio.api.v1.service.objectstate.TransitionEvent;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.service.workflow.WorkflowJob;
import org.craftercms.studio.api.v1.service.workflow.WorkflowService;
import org.craftercms.studio.api.v1.service.workflow.context.GoLiveContext;
import org.craftercms.studio.api.v1.service.workflow.context.MultiChannelPublishingContext;
import org.craftercms.studio.api.v1.service.workflow.context.RequestContext;
import org.craftercms.studio.api.v1.service.workflow.context.RequestContextBuilder;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.DmDependencyTO;
import org.craftercms.studio.api.v1.to.DmError;
import org.craftercms.studio.api.v1.to.DmFolderConfigTO;
import org.craftercms.studio.api.v1.to.DmPathTO;
import org.craftercms.studio.api.v1.to.GoLiveDeleteCandidates;
import org.craftercms.studio.api.v1.to.GoLiveQueue;
import org.craftercms.studio.api.v1.to.GoLiveQueueChildFilter;
import org.craftercms.studio.api.v1.to.PublishingChannelConfigTO;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.api.v1.util.DmContentItemComparator;
import org.craftercms.studio.api.v1.util.filter.DmFilterWrapper;
import org.craftercms.studio.impl.v1.service.workflow.WorkflowProcessor;
import org.craftercms.studio.impl.v1.service.workflow.dal.WorkflowJobDAL;
import org.craftercms.studio.impl.v1.service.workflow.operation.PreGoLiveOperation;
import org.craftercms.studio.impl.v1.service.workflow.operation.PreScheduleDeleteOperation;
import org.craftercms.studio.impl.v1.service.workflow.operation.PreScheduleOperation;
import org.craftercms.studio.impl.v1.service.workflow.operation.PreSubmitDeleteOperation;
import org.craftercms.studio.impl.v1.service.workflow.operation.SubmitLifeCycleOperation;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.craftercms.studio.impl.v1.util.ContentUtils;
import org.craftercms.studio.impl.v1.util.GoLiveQueueOrganizer;

public class WorkflowServiceImpl
implements WorkflowService {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowServiceImpl.class);
    protected String JSON_KEY_ITEMS = "items";
    protected String JSON_KEY_SCHEDULED_DATE = "scheduledDate";
    protected String JSON_KEY_IS_NOW = "now";
    protected String JSON_KEY_PUBLISH_CHANNEL = "publishChannel";
    protected String JSON_KEY_STATUS_SET = "status";
    protected String JSON_KEY_STATUS_MESSAGE = "message";
    protected String JSON_KEY_SUBMISSION_COMMENT = "submissionComment";
    protected String JSON_KEY_URI = "uri";
    protected String JSON_KEY_DELETED = "deleted";
    protected String JSON_KEY_SUBMITTED_FOR_DELETION = "submittedForDeletion";
    protected String JSON_KEY_SUBMITTED = "submitted";
    protected String JSON_KEY_IN_PROGRESS = "inProgress";
    protected String JSON_KEY_IN_REFERENCE = "reference";
    protected String JSON_KEY_COMPONENTS = "components";
    protected String JSON_KEY_DOCUMENTS = "documents";
    protected String JSON_KEY_ASSETS = "assets";
    protected String JSON_KEY_RENDERING_TEMPLATES = "renderingTemplates";
    protected String JSON_KEY_DELETED_ITEMS = "deletedItems";
    protected String JSON_KEY_CHILDREN = "children";
    protected String JSON_KEY_SEND_EMAIL = "sendEmail";
    protected String JSON_KEY_USER = "user";
    protected String JSON_KEY_REASON = "reason";
    private WorkflowJobDAL _workflowJobDAL;
    private NotificationService notificationService;
    protected ServicesConfig servicesConfig;
    protected DeploymentService deploymentService;
    protected ContentService contentService;
    protected DmFilterWrapper dmFilterWrapper;
    protected DmDependencyService dmDependencyService;
    protected ObjectStateService objectStateService;
    protected DmPublishService dmPublishService;
    protected GeneralLockService generalLockService;
    protected SecurityService securityService;
    protected SiteService siteService;
    protected DmRenameService dmRenameService;
    protected WorkflowProcessor workflowProcessor;
    protected DmWorkflowListener dmWorkflowListener;
    protected String customContentTypeNotificationPattern;
    protected boolean customContentTypeNotification;
    protected ObjectMetadataManager objectMetadataManager;

    @Override
    public WorkflowJob createJob(String site, List<String> srcPaths, String processName, Map<String, String> properties) {
        WorkflowJob job = this._workflowJobDAL.createJob(site, srcPaths, processName, properties);
        job.setCurrentStatus("started");
        job = this._workflowJobDAL.updateJob(job);
        return job;
    }

    @Override
    public List<WorkflowJob> getActiveJobs() {
        List<WorkflowJob> allJobs = this._workflowJobDAL.getJobsByState(null);
        int i = allJobs.size();
        while (i > 0) {
            WorkflowJob job;
            if (!(job = allJobs.get(--i)).getCurrentStatus().equals("ended")) continue;
            allJobs.remove(i);
        }
        return allJobs;
    }

    @Override
    public List<WorkflowJob> getJobsInState(Set<String> states) {
        return this._workflowJobDAL.getJobsByState(states);
    }

    @Override
    public WorkflowJob getJob(String jobId) {
        return this._workflowJobDAL.getJob(jobId);
    }

    @Override
    public WorkflowJob updateJob(WorkflowJob job) {
        return this._workflowJobDAL.updateJob(job);
    }

    @Override
    public boolean deleteJob(String jobId) {
        return this._workflowJobDAL.deleteJob(jobId);
    }

    @Override
    public boolean startJob(String jobId) {
        return false;
    }

    @Override
    public boolean transitionJobState(String jobId, String state) {
        return false;
    }

    @Override
    public boolean endJob(String jobId) {
        return false;
    }

    @Override
    public ResultTO submitToGoLive(String site, String username, String request) throws ServiceException {
        return this.submitForApproval(site, username, request, false);
    }

    protected ResultTO submitForApproval(String site, String submittedBy, String request, boolean delete) throws ServiceException {
        RequestContext requestContext = RequestContextBuilder.buildSubmitContext(site, submittedBy);
        ResultTO result = new ResultTO();
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            JSONObject requestObject = JSONObject.fromObject((Object)request);
            boolean isNow = requestObject.containsKey((Object)this.JSON_KEY_IS_NOW) ? requestObject.getBoolean(this.JSON_KEY_IS_NOW) : false;
            Date scheduledDate = null;
            if (!isNow) {
                scheduledDate = requestObject.containsKey((Object)this.JSON_KEY_SCHEDULED_DATE) ? this.getScheduledDate(site, format, requestObject.getString(this.JSON_KEY_SCHEDULED_DATE)) : null;
            }
            boolean sendEmail = requestObject.containsKey((Object)this.JSON_KEY_SEND_EMAIL) ? requestObject.getBoolean(this.JSON_KEY_SEND_EMAIL) : false;
            String submissionComment = requestObject != null && requestObject.containsKey((Object)this.JSON_KEY_SUBMISSION_COMMENT) ? requestObject.getString(this.JSON_KEY_SUBMISSION_COMMENT) : null;
            JSONArray items = requestObject.getJSONArray(this.JSON_KEY_ITEMS);
            int length = items.size();
            String schDate = null;
            if (requestObject.containsKey((Object)this.JSON_KEY_SCHEDULED_DATE)) {
                schDate = requestObject.getString(this.JSON_KEY_SCHEDULED_DATE);
            }
            ArrayList itemsToDelete = new ArrayList(length);
            if (length > 0) {
                ArrayList<DmDependencyTO> submittedItems = new ArrayList<DmDependencyTO>();
                for (int index = 0; index < length; ++index) {
                    String stringItem = items.optString(index);
                    DmDependencyTO submittedItem = this.getSubmittedItem(site, stringItem, format, schDate);
                    String user = submittedBy;
                    submittedItems.add(submittedItem);
                    if (!delete) continue;
                    submittedItem.setSubmittedForDeletion(true);
                }
                ArrayList<String> submittedPaths = new ArrayList<String>();
                for (DmDependencyTO goLiveItem : submittedItems) {
                    String fullPath = this.contentService.expandRelativeSitePath(site, goLiveItem.getUri());
                    submittedPaths.add(fullPath);
                    this.objectStateService.setSystemProcessing(site, goLiveItem.getUri(), true);
                    DependencyRules rule = new DependencyRules(site);
                    rule.setObjectStateService(this.objectStateService);
                    rule.setContentService(this.contentService);
                    Set<DmDependencyTO> depSet = rule.applySubmitRule(goLiveItem);
                    for (DmDependencyTO dep : depSet) {
                        String depPath = this.contentService.expandRelativeSitePath(site, dep.getUri());
                        submittedPaths.add(depPath);
                        this.objectStateService.setSystemProcessing(site, dep.getUri(), true);
                    }
                }
                List<DmError> errors = this.submitToGoLive(submittedItems, scheduledDate, sendEmail, delete, requestContext, submissionComment);
                result.setSuccess(true);
                result.setStatus(200);
                result.setMessage(this.notificationService.getCompleteMessage(site, "submit-to-go-live"));
                for (String fullPath : submittedPaths) {
                    this.objectStateService.setSystemProcessing(site, this.contentService.getRelativeSitePath(site, fullPath), false);
                }
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setMessage(e.getMessage());
            logger.error("Error while submitting content for approval.", e, new Object[0]);
        }
        return result;
    }

    protected List<DmError> submitToGoLive(List<DmDependencyTO> submittedItems, Date scheduledDate, boolean sendEmail, boolean submitForDeletion, RequestContext requestContext, String submissionComment) throws ServiceException {
        ArrayList<DmError> errors = new ArrayList<DmError>();
        String site = requestContext.getSite();
        String submittedBy = requestContext.getUser();
        for (DmDependencyTO submittedItem : submittedItems) {
            try {
                DependencyRules rule = new DependencyRules(site);
                rule.setContentService(this.contentService);
                rule.setObjectStateService(this.objectStateService);
                this.submitThisAndReferredComponents(submittedItem, site, scheduledDate, sendEmail, submitForDeletion, submittedBy, rule, submissionComment);
                List<DmDependencyTO> children = submittedItem.getChildren();
                if (children == null || submitForDeletion) continue;
                for (DmDependencyTO child : children) {
                    if (child.isReference()) continue;
                    this.submitThisAndReferredComponents(child, site, scheduledDate, sendEmail, submitForDeletion, submittedBy, rule, submissionComment);
                }
            }
            catch (ContentNotFoundException e) {
                errors.add(new DmError(site, submittedItem.getUri(), e));
            }
        }
        return errors;
    }

    protected void submitThisAndReferredComponents(DmDependencyTO submittedItem, String site, Date scheduledDate, boolean sendEmail, boolean submitForDeletion, String submittedBy, DependencyRules rule, String submissionComment) throws ServiceException {
        this.doSubmit(site, submittedItem, scheduledDate, sendEmail, submitForDeletion, submittedBy, true, submissionComment);
        Set<DmDependencyTO> stringSet = submitForDeletion ? rule.applyDeleteDependencyRule(submittedItem) : rule.applySubmitRule(submittedItem);
        for (DmDependencyTO s : stringSet) {
            String fullPath = this.contentService.expandRelativeSitePath(site, s.getUri());
            ContentItemTO contentItem = this.contentService.getContentItem(site, s.getUri());
            boolean lsendEmail = true;
            boolean lnotifyAdmin = true;
            lsendEmail = sendEmail && (!contentItem.isDocument() && !contentItem.isComponent() && !contentItem.isAsset() || this.customContentTypeNotification);
            lnotifyAdmin = !contentItem.isDocument() && !contentItem.isComponent() && !contentItem.isAsset();
            this.doSubmit(site, s, scheduledDate, lsendEmail, submitForDeletion, submittedBy, lnotifyAdmin, submissionComment);
        }
    }

    protected void doSubmit(String site, DmDependencyTO dependencyTO, Date scheduledDate, boolean sendEmail, boolean submitForDeletion, String user, boolean notifyAdmin, String submissionComment) {
        this.removeFromWorkflow(site, dependencyTO.getUri(), true);
        String fullPath = this.contentService.expandRelativeSitePath(site, dependencyTO.getUri());
        DmPathTO path = new DmPathTO(fullPath);
        ContentItemTO item = this.contentService.getContentItem(site, dependencyTO.getUri());
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("submittedBy", user);
        properties.put("sendEmail", sendEmail ? 1 : 0);
        properties.put("submittedForDeletion", submitForDeletion ? 1 : 0);
        properties.put("submissionComment", submissionComment);
        if (null == scheduledDate) {
            properties.put("launchDate", null);
        } else {
            properties.put("launchDate", scheduledDate);
        }
        if (!this.objectMetadataManager.metadataExist(site, dependencyTO.getUri())) {
            this.objectMetadataManager.insertNewObjectMetadata(site, dependencyTO.getUri());
        }
        this.objectMetadataManager.setObjectMetadata(site, dependencyTO.getUri(), properties);
        if (scheduledDate != null) {
            this.objectStateService.transition(site, item, TransitionEvent.SUBMIT_WITH_WORKFLOW_SCHEDULED);
        } else {
            this.objectStateService.transition(site, item, TransitionEvent.SUBMIT_WITH_WORKFLOW_UNSCHEDULED);
        }
        this.dmWorkflowListener.postSubmitToGolive(site, dependencyTO);
        if (notifyAdmin) {
            boolean isPreviewable = item.isPreviewable();
            this.notificationService.sendContentSubmissionNotification(site, "admin", dependencyTO.getUri(), user, scheduledDate, isPreviewable, submitForDeletion);
        }
    }

    @Override
    public void submitToGoLive(String site, List<String> paths, Date scheduledDate, boolean sendApprovedNotice, String submitter) {
    }

    @Override
    public Map<String, Object> getGoLiveItems(String site, String sort, boolean ascending) throws ServiceException {
        DmContentItemComparator comparator = new DmContentItemComparator(sort, ascending, false, false);
        List<ContentItemTO> items = this.getGoLiveItems(site, comparator);
        int total = 0;
        if (items != null) {
            for (ContentItemTO item : items) {
                total += item.getNumOfChildren();
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("total", total);
        result.put("sortedBy", sort);
        result.put("ascending", String.valueOf(ascending));
        result.put("documents", items);
        return result;
    }

    protected List<ContentItemTO> getGoLiveItems(String site, DmContentItemComparator comparator) throws ServiceException {
        List<String> displayPatterns = this.servicesConfig.getDisplayInWidgetPathPatterns(site);
        List<ContentItemTO> categoryItems = this.getCategoryItems(site);
        GoLiveQueue queue = new GoLiveQueue();
        this.fillQueue(site, queue, null);
        Set<ContentItemTO> queueItems = queue.getQueue();
        GoLiveQueueChildFilter childFilter = new GoLiveQueueChildFilter(queue);
        GoLiveQueueOrganizer goLiveQueueOrganizer = new GoLiveQueueOrganizer(this.contentService, childFilter);
        for (ContentItemTO queueItem : queueItems) {
            if (queueItem.getLastEditDate() != null) {
                queueItem.setEventDate(queueItem.getLastEditDate());
            }
            goLiveQueueOrganizer.addToGoLiveItems(site, queueItem, categoryItems, comparator, false, displayPatterns);
        }
        return categoryItems;
    }

    protected List<ContentItemTO> getCategoryItems(String site) {
        String siteRootPrefix = this.servicesConfig.getRootPrefix(site);
        ArrayList<ContentItemTO> categories = new ArrayList<ContentItemTO>();
        List<DmFolderConfigTO> folders = this.servicesConfig.getFolders(site);
        for (DmFolderConfigTO folder : folders) {
            String uri;
            String string = uri = folder.isAttachRootPrefix() ? siteRootPrefix + folder.getPath() : folder.getPath();
            if (folder.isReadDirectChildren()) {
                ContentItemTO rootItem = this.contentService.getContentItemTree(site, siteRootPrefix + folder.getPath(), 1);
                if (rootItem == null) continue;
                if (rootItem.children != null) {
                    for (ContentItemTO childItem : rootItem.children) {
                        categories.add(childItem);
                    }
                }
                categories.add(rootItem);
                continue;
            }
            ContentItemTO categoryItem = new ContentItemTO();
            String timeZone = this.servicesConfig.getDefaultTimezone(site);
            categoryItem.setTimezone(timeZone);
            categoryItem.setName(folder.getName());
            categoryItem.setInternalName(folder.getName());
            categoryItem.setUri(uri);
            categoryItem.setPath(uri);
            categoryItem.setCategoryRoot(uri);
            categories.add(categoryItem);
        }
        return categories;
    }

    public void fillQueue(String site, GoLiveQueue goLiveQueue, GoLiveQueue inProcessQueue) throws ServiceException {
        List<ObjectState> changeSet = this.objectStateService.getSubmittedItems(site);
        if (changeSet != null) {
            for (ObjectState state : changeSet) {
                try {
                    ContentItemTO item = this.contentService.getContentItem(state.getSite(), state.getPath(), 0);
                    this.addToQueue(site, goLiveQueue, inProcessQueue, item, state);
                }
                catch (Exception e) {
                    logger.error("Could not warm cache for [" + state.getSite() + " : " + state.getPath() + "] " + e.getMessage(), new Object[0]);
                }
            }
        }
    }

    protected void addToQueue(String site, GoLiveQueue queue, GoLiveQueue inProcessQueue, ContentItemTO item, ObjectState itemState) throws ServiceException {
        if (item != null) {
            State state = State.valueOf(itemState.getState());
            if (State.isSubmitted(state)) {
                queue.add(item);
            }
            if (inProcessQueue != null && !State.isLive(state)) {
                inProcessQueue.add(item);
                inProcessQueue.add(item.getPath(), item);
            }
        } else {
            this.objectStateService.deleteObjectState(itemState.getObjectId());
        }
    }

    @Override
    public Map<String, Object> getInProgressItems(String site, String sort, boolean ascending, boolean inProgressOnly) throws ServiceException {
        DmContentItemComparator comparator = new DmContentItemComparator(sort, ascending, true, true);
        List<ContentItemTO> items = this.getInProgressItems(site, comparator, inProgressOnly);
        JSONObject jsonObject = new JSONObject();
        int total = 0;
        if (items != null) {
            for (ContentItemTO item : items) {
                total += item.getNumOfChildren();
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("total", total);
        result.put("sortedBy", sort);
        result.put("ascending", String.valueOf(ascending));
        result.put("documents", items);
        return result;
    }

    protected List<ContentItemTO> getInProgressItems(String site, DmContentItemComparator comparator, boolean inProgressOnly) throws ServiceException {
        ArrayList<ContentItemTO> categoryItems = new ArrayList<ContentItemTO>();
        List<ContentItemTO> categoryItems1 = this.getCategoryItems(site);
        categoryItems.addAll(categoryItems1);
        long st = System.currentTimeMillis();
        List<ObjectState> changeSet = this.objectStateService.getChangeSet(site);
        logger.debug("Time taken listChangedAll()  " + (System.currentTimeMillis() - st), new Object[0]);
        st = System.currentTimeMillis();
        if (changeSet != null) {
            List<String> displayPatterns = this.servicesConfig.getDisplayInWidgetPathPatterns(site);
            for (ObjectState state : changeSet) {
                if (!this.contentService.contentExists(state.getSite(), state.getPath()) || !ContentUtils.matchesPatterns(state.getPath(), displayPatterns)) continue;
                ContentItemTO item = this.contentService.getContentItem(state.getSite(), state.getPath(), 0);
                this.addInProgressItems(site, item, categoryItems, comparator, inProgressOnly);
            }
        }
        logger.debug("Time taken after listChangedAll() : " + (System.currentTimeMillis() - st), new Object[0]);
        return categoryItems;
    }

    protected void addInProgressItems(String site, ContentItemTO item, List<ContentItemTO> categoryItems, DmContentItemComparator comparator, boolean inProgressOnly) {
        if (this.addToQueue(false, inProgressOnly, true)) {
            if (!item.isSubmitted() && !item.isInProgress()) {
                return;
            }
            item.setDeleted(false);
            ContentItemTO found = null;
            String uri = item.getUri();
            for (ContentItemTO categoryItem : categoryItems) {
                String categoryPath = categoryItem.getPath() + "/";
                if (!uri.startsWith(categoryPath)) continue;
                found = categoryItem;
                break;
            }
            if (found != null && !found.getUri().equals(item.getUri())) {
                found.addChild(item, comparator, true);
            }
        }
    }

    protected boolean addToQueue(boolean submitted, boolean inProgressOnly, boolean includeInProgress) {
        if (inProgressOnly && submitted) {
            return false;
        }
        if (submitted && !inProgressOnly) {
            return true;
        }
        return !submitted && (inProgressOnly || includeInProgress);
    }

    @Override
    public boolean removeFromWorkflow(String site, String path, boolean cancelWorkflow) {
        HashSet<String> processedPaths = new HashSet<String>();
        return this.removeFromWorkflow(site, path, processedPaths, cancelWorkflow);
    }

    protected boolean removeFromWorkflow(String site, String path, Set<String> processedPaths, boolean cancelWorkflow) {
        if (!processedPaths.contains(path)) {
            processedPaths.add(path);
            long startTime = System.currentTimeMillis();
            if (cancelWorkflow) {
                this._cancelWorkflow(site, path);
            }
            long duration = System.currentTimeMillis() - startTime;
            logger.warn("_cancelWorkflow Duration 111: {0}", duration);
        }
        return false;
    }

    protected void _cancelWorkflow(String site, String path) {
        List<String> allItemsToCancel = this.getWorkflowAffectedPathsInternal(site, path);
        ArrayList<String> paths = new ArrayList<String>();
        for (String affectedItem : allItemsToCancel) {
            try {
                this.deploymentService.cancelWorkflow(site, affectedItem);
                paths.add(affectedItem);
            }
            catch (DeploymentException e) {
                logger.error("Error occurred while trying to cancel workflow for path [" + affectedItem + "], site " + site, e, new Object[0]);
            }
        }
        this.objectStateService.transitionBulk(site, paths, TransitionEvent.REJECT, State.NEW_UNPUBLISHED_UNLOCKED);
        if (!this.objectStateService.isNew(site, path) || path.endsWith("index.xml")) {
            // empty if block
        }
    }

    protected List<String> getWorkflowAffectedPathsInternal(String site, String path) {
        ArrayList<String> affectedPaths = new ArrayList<String>();
        ArrayList<String> filteredPaths = new ArrayList<String>();
        if (this.objectStateService.isInWorkflow(site, path)) {
            affectedPaths.add(path);
            boolean isNew = this.objectStateService.isNew(site, path);
            boolean isRenamed = this.objectMetadataManager.isRenamed(site, path);
            if (isNew || isRenamed) {
                this.getMandatoryChildren(site, path, affectedPaths);
            }
            List<String> dependencyPaths = this.getDependencyCandidates(site, affectedPaths);
            affectedPaths.addAll(dependencyPaths);
            ArrayList<String> candidates = new ArrayList<String>();
            for (String p : affectedPaths) {
                if (candidates.contains(p)) continue;
                candidates.add(p);
            }
            for (String cp : candidates) {
                if (!this.objectStateService.isInWorkflow(site, cp)) continue;
                filteredPaths.add(cp);
            }
        }
        return affectedPaths;
    }

    @Override
    public List<ContentItemTO> getWorkflowAffectedPaths(String site, String path) {
        List<String> affectedPaths = this.getWorkflowAffectedPathsInternal(site, path);
        return this.getWorkflowAffectedItems(site, affectedPaths);
    }

    private void getMandatoryChildren(String site, String path, List<String> affectedPaths) {
    }

    private List<String> getDependencyCandidates(String site, List<String> affectedPaths) {
        ArrayList<String> dependenciesPaths = new ArrayList<String>();
        for (String path : affectedPaths) {
            this.getAllDependenciesRecursive(site, path, dependenciesPaths);
        }
        return dependenciesPaths;
    }

    protected void getAllDependenciesRecursive(String site, String path, List<String> dependecyPaths) {
        List<String> depPaths = this.dmDependencyService.getDependencyPaths(site, path);
        for (String depPath : depPaths) {
            if (dependecyPaths.contains(depPath)) continue;
            dependecyPaths.add(depPath);
            this.getAllDependenciesRecursive(site, depPath, dependecyPaths);
        }
    }

    protected List<ContentItemTO> getWorkflowAffectedItems(String site, List<String> paths) {
        ArrayList<ContentItemTO> items = new ArrayList<ContentItemTO>();
        for (String path : paths) {
            ContentItemTO item = this.contentService.getContentItem(site, path);
            items.add(item);
        }
        return items;
    }

    @Override
    public void updateWorkflowSandboxes(String site, String path) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultTO goDelete(String site, String request, String user) {
        String md5 = ContentUtils.getMd5ForFile(request);
        String id = site + ":" + user + ":" + md5;
        if (!this.generalLockService.tryLock(id)) {
            this.generalLockService.lock(id);
            this.generalLockService.unlock(id);
            return new ResultTO();
        }
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("USER", user);
            ResultTO resultTO = this.approve(site, request, Operation.DELETE);
            return resultTO;
        }
        finally {
            this.generalLockService.unlock(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultTO approve(String site, String request, Operation operation) {
        String approver = this.securityService.getCurrentUser();
        ResultTO result = new ResultTO();
        try {
            JSONObject requestObject = JSONObject.fromObject((Object)request);
            JSONArray items = requestObject.getJSONArray(this.JSON_KEY_ITEMS);
            String scheduledDate = null;
            if (requestObject.containsKey((Object)this.JSON_KEY_SCHEDULED_DATE)) {
                scheduledDate = requestObject.getString(this.JSON_KEY_SCHEDULED_DATE);
            }
            boolean isNow = requestObject.containsKey((Object)this.JSON_KEY_IS_NOW) ? requestObject.getBoolean(this.JSON_KEY_IS_NOW) : false;
            String publishChannelGroupName = requestObject.containsKey((Object)this.JSON_KEY_PUBLISH_CHANNEL) ? requestObject.getString(this.JSON_KEY_PUBLISH_CHANNEL) : null;
            JSONObject jsonObjectStatus = requestObject.getJSONObject(this.JSON_KEY_STATUS_SET);
            String statusMessage = jsonObjectStatus != null && jsonObjectStatus.containsKey((Object)this.JSON_KEY_STATUS_MESSAGE) ? jsonObjectStatus.getString(this.JSON_KEY_STATUS_MESSAGE) : null;
            String submissionComment = requestObject != null && requestObject.containsKey((Object)this.JSON_KEY_SUBMISSION_COMMENT) ? requestObject.getString(this.JSON_KEY_SUBMISSION_COMMENT) : "Test Go Live";
            MultiChannelPublishingContext mcpContext = new MultiChannelPublishingContext(publishChannelGroupName, statusMessage, submissionComment);
            if (operation != Operation.DELETE && !this.dmPublishService.hasChannelsConfigure(site, mcpContext)) {
                ResultTO toReturn = new ResultTO();
                List<PublishingChannelConfigTO> channelsList = this.siteService.getPublishingChannelGroupConfigs(site).get(mcpContext.getPublishingChannelGroup()).getChannels();
                String channels = StringUtils.join(channelsList, (String)" ");
                toReturn.setMessage(" Specified target '" + channels + "' was not found. Please check if an endpoint or channel with name '" + channels + "' exists in site configuration");
                toReturn.setSuccess(false);
                toReturn.setInvalidateCache(false);
                return toReturn;
            }
            int length = items.size();
            if (length == 0) {
                throw new ServiceException("No items provided to go live.");
            }
            String responseMessageKey = null;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            ArrayList<DmDependencyTO> submittedItems = new ArrayList<DmDependencyTO>();
            for (int index = 0; index < length; ++index) {
                String stringItem = items.optString(index);
                JSONObject item = items.optJSONObject(index);
                DmDependencyTO submittedItem = null;
                submittedItem = this.getSubmittedItem(site, stringItem, format, scheduledDate);
                List<DmDependencyTO> submitForDeleteChildren = this.removeSubmitToDeleteChildrenForGoLive(submittedItem, operation);
                if (submittedItem.isReference()) {
                    submittedItem.setReference(false);
                }
                submittedItems.add(submittedItem);
                submittedItems.addAll(submitForDeleteChildren);
            }
            switch (operation) {
                case GO_LIVE: {
                    String fullPath;
                    responseMessageKey = scheduledDate != null && !isNow ? "schedule-to-go-live" : "go-live";
                    ArrayList<DmDependencyTO> submitToDeleteItems = new ArrayList<DmDependencyTO>();
                    ArrayList<DmDependencyTO> goLiveItems = new ArrayList<DmDependencyTO>();
                    ArrayList<DmDependencyTO> renameItems = new ArrayList<DmDependencyTO>();
                    for (DmDependencyTO item : submittedItems) {
                        if (item.isSubmittedForDeletion()) {
                            submitToDeleteItems.add(item);
                            continue;
                        }
                        if (!this.dmRenameService.isItemRenamed(site, item)) {
                            goLiveItems.add(item);
                            continue;
                        }
                        renameItems.add(item);
                    }
                    if (!submitToDeleteItems.isEmpty()) {
                        this.doDelete(site, submitToDeleteItems, approver);
                    }
                    if (!goLiveItems.isEmpty()) {
                        String lockId;
                        String path;
                        List<DmDependencyTO> references = this.getRefAndChildOfDiffDateFromParent(site, goLiveItems, true);
                        List<DmDependencyTO> children = this.getRefAndChildOfDiffDateFromParent(site, goLiveItems, false);
                        goLiveItems.addAll(references);
                        goLiveItems.addAll(children);
                        ArrayList<String> goLivePaths = new ArrayList<String>();
                        for (DmDependencyTO goLiveItem : goLiveItems) {
                            this.resolveSubmittedPaths(site, goLiveItem, goLivePaths);
                        }
                        ArrayList nodeRefs = new ArrayList();
                        for (String fullPath2 : goLivePaths) {
                            path = this.contentService.getRelativeSitePath(site, fullPath2);
                            lockId = site + ":" + path;
                            this.generalLockService.lock(lockId);
                        }
                        try {
                            this.goLive(site, goLiveItems, approver, mcpContext);
                        }
                        finally {
                            for (String fullPath2 : goLivePaths) {
                                path = this.contentService.getRelativeSitePath(site, fullPath2);
                                lockId = site + ":" + path;
                                this.generalLockService.unlock(lockId);
                            }
                        }
                    }
                    if (renameItems.isEmpty()) break;
                    ArrayList<String> renamePaths = new ArrayList<String>();
                    ArrayList<DmDependencyTO> renamedChildren = new ArrayList<DmDependencyTO>();
                    for (DmDependencyTO renameItem : renameItems) {
                        renamedChildren.addAll(this.getChildrenForRenamedItem(site, renameItem));
                        fullPath = this.contentService.expandRelativeSitePath(site, renameItem.getUri());
                        renamePaths.add(fullPath);
                        this.objectStateService.setSystemProcessing(site, renameItem.getUri(), true);
                    }
                    for (DmDependencyTO renamedChild : renamedChildren) {
                        fullPath = this.contentService.expandRelativeSitePath(site, renamedChild.getUri());
                        renamePaths.add(fullPath);
                        this.objectStateService.setSystemProcessing(site, renamedChild.getUri(), true);
                    }
                    renameItems.addAll(renamedChildren);
                    for (int i = 0; i < renameItems.size(); ++i) {
                        DmDependencyTO renamedItem = (DmDependencyTO)renameItems.get(i);
                        if (renamedItem.getScheduledDate() != null && renamedItem.getScheduledDate().after(new Date())) {
                            renamedItem.setNow(false);
                        } else {
                            renamedItem.setNow(true);
                        }
                        renameItems.set(i, renamedItem);
                    }
                    this.dmRenameService.goLive(site, renameItems, approver, mcpContext);
                    break;
                }
                case DELETE: {
                    responseMessageKey = "delete";
                    ArrayList<String> deletePaths = new ArrayList<String>();
                    ArrayList nodeRefs = new ArrayList();
                    for (DmDependencyTO deletedItem : submittedItems) {
                        String fullPath = this.contentService.expandRelativeSitePath(site, deletedItem.getUri());
                        deletePaths.add(fullPath);
                        ContentItemTO contentItem = this.contentService.getContentItem(site, deletedItem.getUri());
                        if (contentItem == null) continue;
                    }
                    this.doDelete(site, submittedItems, approver);
                }
            }
            result.setSuccess(true);
            result.setStatus(200);
            result.setMessage(this.notificationService.getCompleteMessage(site, responseMessageKey));
        }
        catch (JSONException e) {
            logger.error("error performing operation " + (Object)((Object)operation) + " " + (Object)((Object)e), new Object[0]);
            result.setSuccess(false);
            result.setMessage(e.getMessage());
        }
        catch (ServiceException e) {
            logger.error("error performing operation " + (Object)((Object)operation) + " " + e, new Object[0]);
            result.setSuccess(false);
            result.setMessage(e.getMessage());
        }
        return result;
    }

    protected DmDependencyTO getSubmittedItem(String site, JSONObject item, SimpleDateFormat format, String globalSchDate) throws JSONException {
        String dateStr;
        DmDependencyTO submittedItem = new DmDependencyTO();
        String uri = item.getString(this.JSON_KEY_URI);
        submittedItem.setUri(uri);
        boolean deleted = item.containsKey((Object)this.JSON_KEY_DELETED) ? item.getBoolean(this.JSON_KEY_DELETED) : false;
        submittedItem.setDeleted(deleted);
        boolean isNow = item.containsKey((Object)this.JSON_KEY_IS_NOW) ? item.getBoolean(this.JSON_KEY_IS_NOW) : false;
        submittedItem.setNow(isNow);
        boolean submittedForDeletion = item.containsKey((Object)this.JSON_KEY_SUBMITTED_FOR_DELETION) ? item.getBoolean(this.JSON_KEY_SUBMITTED_FOR_DELETION) : false;
        boolean submitted = item.containsKey((Object)this.JSON_KEY_SUBMITTED) ? item.getBoolean(this.JSON_KEY_SUBMITTED) : false;
        boolean inProgress = item.containsKey((Object)this.JSON_KEY_IN_PROGRESS) ? item.getBoolean(this.JSON_KEY_IN_PROGRESS) : false;
        boolean isReference = item.containsKey((Object)this.JSON_KEY_IN_REFERENCE) ? item.getBoolean(this.JSON_KEY_IN_REFERENCE) : false;
        submittedItem.setReference(isReference);
        submittedItem.setSubmittedForDeletion(submittedForDeletion);
        submittedItem.setSubmitted(submitted);
        submittedItem.setInProgress(inProgress);
        Date scheduledDate = null;
        if (globalSchDate != null && !StringUtils.isEmpty((String)globalSchDate)) {
            scheduledDate = this.getScheduledDate(site, format, globalSchDate);
        } else if (item.containsKey((Object)this.JSON_KEY_SCHEDULED_DATE) && !StringUtils.isEmpty((String)(dateStr = item.getString(this.JSON_KEY_SCHEDULED_DATE)))) {
            scheduledDate = this.getScheduledDate(site, format, dateStr);
        }
        if (scheduledDate == null && !isNow) {
            submittedItem.setNow(true);
        }
        submittedItem.setScheduledDate(scheduledDate);
        JSONArray components = item.containsKey((Object)this.JSON_KEY_COMPONENTS) && !item.getJSONObject(this.JSON_KEY_COMPONENTS).isNullObject() ? item.getJSONArray(this.JSON_KEY_COMPONENTS) : null;
        List<DmDependencyTO> submittedComponents = this.getSubmittedItems(site, components, format, globalSchDate);
        submittedItem.setComponents(submittedComponents);
        JSONArray documents = item.containsKey((Object)this.JSON_KEY_DOCUMENTS) && !item.getJSONObject(this.JSON_KEY_DOCUMENTS).isNullObject() ? item.getJSONArray(this.JSON_KEY_DOCUMENTS) : null;
        List<DmDependencyTO> submittedDocuments = this.getSubmittedItems(site, documents, format, globalSchDate);
        submittedItem.setDocuments(submittedDocuments);
        JSONArray assets = item.containsKey((Object)this.JSON_KEY_ASSETS) && !item.getJSONObject(this.JSON_KEY_ASSETS).isNullObject() ? item.getJSONArray(this.JSON_KEY_ASSETS) : null;
        List<DmDependencyTO> submittedAssets = this.getSubmittedItems(site, assets, format, globalSchDate);
        submittedItem.setAssets(submittedAssets);
        JSONArray templates = item.containsKey((Object)this.JSON_KEY_RENDERING_TEMPLATES) && !item.getJSONObject(this.JSON_KEY_RENDERING_TEMPLATES).isNullObject() ? item.getJSONArray(this.JSON_KEY_RENDERING_TEMPLATES) : null;
        List<DmDependencyTO> submittedTemplates = this.getSubmittedItems(site, templates, format, globalSchDate);
        submittedItem.setRenderingTemplates(submittedTemplates);
        JSONArray deletedItems = item.containsKey((Object)this.JSON_KEY_DELETED_ITEMS) && !item.getJSONObject(this.JSON_KEY_DELETED_ITEMS).isNullObject() ? item.getJSONArray(this.JSON_KEY_DELETED_ITEMS) : null;
        List<DmDependencyTO> deletes = this.getSubmittedItems(site, deletedItems, format, globalSchDate);
        submittedItem.setDeletedItems(deletes);
        JSONArray children = item.containsKey((Object)this.JSON_KEY_CHILDREN) ? item.getJSONArray(this.JSON_KEY_CHILDREN) : null;
        List<DmDependencyTO> submittedChidren = this.getSubmittedItems(site, children, format, globalSchDate);
        submittedItem.setChildren(submittedChidren);
        if (uri.endsWith(".xml")) {
            DmDependencyTO dmDependencyTo = this.dmDependencyService.getDependencies(site, item.getString(this.JSON_KEY_URI), false, true);
            List<DmDependencyTO> dependentPages = new ArrayList<DmDependencyTO>();
            if (dmDependencyTo != null) {
                dependentPages = dmDependencyTo.getPages();
            }
            submittedItem.setPages(dependentPages);
            if (submittedItem.getDocuments() == null) {
                ArrayList<DmDependencyTO> dependentDocuments = new ArrayList<DmDependencyTO>();
                if (dmDependencyTo != null) {
                    dmDependencyTo.getDocuments();
                }
                submittedItem.setDocuments(dependentDocuments);
            }
        }
        return submittedItem;
    }

    protected DmDependencyTO getSubmittedItem(String site, String itemPath, SimpleDateFormat format, String globalSchDate) throws JSONException {
        DmDependencyTO submittedItem = this.dmDependencyService.getDependencies(site, itemPath, false, true);
        Date scheduledDate = null;
        if (globalSchDate != null && !StringUtils.isEmpty((String)globalSchDate)) {
            scheduledDate = this.getScheduledDate(site, format, globalSchDate);
        } else if (submittedItem.getScheduledDate() != null) {
            scheduledDate = this.getScheduledDate(site, format, format.format(submittedItem.getScheduledDate()));
        }
        if (scheduledDate == null) {
            submittedItem.setNow(true);
        }
        submittedItem.setScheduledDate(scheduledDate);
        if (CollectionUtils.isNotEmpty(submittedItem.getComponents())) {
            for (DmDependencyTO component : submittedItem.getComponents()) {
                component = this.getSubmittedItem(site, component.getUri(), format, globalSchDate);
            }
        }
        if (CollectionUtils.isNotEmpty(submittedItem.getDocuments())) {
            for (DmDependencyTO document : submittedItem.getDocuments()) {
                document = this.getSubmittedItem(site, document.getUri(), format, globalSchDate);
            }
        }
        if (CollectionUtils.isNotEmpty(submittedItem.getAssets())) {
            for (DmDependencyTO asset : submittedItem.getAssets()) {
                asset = this.getSubmittedItem(site, asset.getUri(), format, globalSchDate);
            }
        }
        if (CollectionUtils.isNotEmpty(submittedItem.getRenderingTemplates())) {
            for (DmDependencyTO template : submittedItem.getRenderingTemplates()) {
                template = this.getSubmittedItem(site, template.getUri(), format, globalSchDate);
            }
        }
        if (CollectionUtils.isNotEmpty(submittedItem.getDeletedItems())) {
            for (DmDependencyTO deletedItem : submittedItem.getDeletedItems()) {
                deletedItem = this.getSubmittedItem(site, deletedItem.getUri(), format, globalSchDate);
            }
        }
        if (CollectionUtils.isNotEmpty(submittedItem.getChildren())) {
            for (DmDependencyTO child : submittedItem.getChildren()) {
                child = this.getSubmittedItem(site, child.getUri(), format, globalSchDate);
            }
        }
        if (submittedItem.getUri().endsWith(".xml")) {
            // empty if block
        }
        return submittedItem;
    }

    protected List<DmDependencyTO> getSubmittedItems(String site, JSONArray items, SimpleDateFormat format, String schDate) throws JSONException {
        int length;
        if (items != null && (length = items.size()) > 0) {
            ArrayList<DmDependencyTO> submittedItems = new ArrayList<DmDependencyTO>();
            for (int index = 0; index < length; ++index) {
                JSONObject item = items.getJSONObject(index);
                DmDependencyTO submittedItem = this.getSubmittedItem(site, item, format, schDate);
                submittedItems.add(submittedItem);
            }
            return submittedItems;
        }
        return null;
    }

    protected List<DmDependencyTO> removeSubmitToDeleteChildrenForGoLive(DmDependencyTO dependencyTO, Operation operation) {
        List<DmDependencyTO> children;
        ArrayList<DmDependencyTO> submitForDeleteChilds = new ArrayList<DmDependencyTO>();
        if (operation == Operation.GO_LIVE && !dependencyTO.isSubmittedForDeletion() && (children = dependencyTO.getChildren()) != null) {
            for (DmDependencyTO child : children) {
                if (!child.isSubmittedForDeletion()) continue;
                submitForDeleteChilds.add(child);
            }
            for (DmDependencyTO submitForDeleteChild : submitForDeleteChilds) {
                children.remove(submitForDeleteChild);
            }
        }
        return submitForDeleteChilds;
    }

    protected void doDelete(String site, List<DmDependencyTO> submittedItems, String approver) throws ServiceException {
        long start = System.currentTimeMillis();
        String user = this.securityService.getCurrentUser();
        Date now = new Date();
        ArrayList<String> itemsToDelete = new ArrayList<String>();
        ArrayList<DmDependencyTO> deleteItems = new ArrayList<DmDependencyTO>();
        ArrayList<DmDependencyTO> scheItems = new ArrayList<DmDependencyTO>();
        for (DmDependencyTO submittedItem : submittedItems) {
            String uri = submittedItem.getUri();
            Date schDate = submittedItem.getScheduledDate();
            boolean isItemForSchedule = false;
            if (schDate == null || schDate.before(now)) {
                if (StringUtils.isNotEmpty((String)approver) && submittedItem.isSendEmail()) {
                    this.sendDeleteApprovalNotification(site, submittedItem, approver);
                }
                if (submittedItem.getUri().endsWith("index.xml")) {
                    submittedItem.setUri(submittedItem.getUri().replace("/index.xml", ""));
                }
                itemsToDelete.add(uri);
            } else {
                scheItems.add(submittedItem);
                isItemForSchedule = true;
            }
            submittedItem.setDeleted(true);
            boolean isNew = this.objectStateService.isNew(site, uri);
            if (!isNew || isItemForSchedule) {
                deleteItems.add(submittedItem);
            }
            ContentItemTO contentItemTO = this.contentService.getContentItem(site, uri);
        }
        GoLiveContext context = new GoLiveContext(approver, site);
        String pathPrefix = "/wem-projects/" + site + "/" + site + "/work-area";
        Map<Date, List<DmDependencyTO>> groupedPackages = this.groupByDate(deleteItems, now);
        if (groupedPackages.isEmpty()) {
            groupedPackages.put(now, Collections.emptyList());
        }
        for (Date scheduledDate : groupedPackages.keySet()) {
            List<DmDependencyTO> deletePackage = groupedPackages.get(scheduledDate);
            SubmitPackage submitpackage = new SubmitPackage(pathPrefix);
            HashSet<String> rescheduledUris = new HashSet<String>();
            if (deletePackage == null) continue;
            Date launchDate = scheduledDate.equals(now) ? null : scheduledDate;
            for (DmDependencyTO dmDependencyTO : deletePackage) {
                if (launchDate != null) {
                    this.handleReferences(site, submitpackage, dmDependencyTO, true, null, "", rescheduledUris);
                    continue;
                }
                this.applyDeleteDependencyRule(site, submitpackage, dmDependencyTO);
            }
            String label = submitpackage.getLabel();
            SubmitLifeCycleOperation deleteOperation = null;
            HashSet<String> liveDependencyItems = new HashSet<String>();
            HashSet<String> allItems = new HashSet<String>();
            for (String uri : itemsToDelete) {
                GoLiveDeleteCandidates deleteCandidate = this.contentService.getDeleteCandidates(context.getSite(), uri);
                allItems.addAll(deleteCandidate.getAllItems());
                liveDependencyItems.addAll(deleteCandidate.getLiveDependencyItems());
            }
            List<String> submitPackPaths = submitpackage.getPaths();
            if (launchDate != null) {
                deleteOperation = new PreScheduleDeleteOperation(this, submitpackage.getUris(), launchDate, context, rescheduledUris);
                label = "schedule_submission:" + label;
            } else {
                for (String liveDependency : liveDependencyItems) {
                    DmPathTO pathTO = new DmPathTO(liveDependency);
                    submitpackage.addToPackage(pathTO.getRelativePath());
                }
                submitPackPaths = submitpackage.getPaths();
                deleteOperation = new PreSubmitDeleteOperation((WorkflowService)this, new HashSet<String>(itemsToDelete), context, rescheduledUris);
                this.removeChildFromSubmitPackForDelete(submitPackPaths);
                for (String string : allItems) {
                }
            }
            HashMap submittedBy = new HashMap();
            this.workflowProcessor.addToWorkflow(site, new ArrayList<String>(), launchDate, label, deleteOperation, approver, null);
        }
        long end = System.currentTimeMillis();
        logger.debug("Submitted deleted items to queue time = " + (end - start), new Object[0]);
    }

    @Override
    public Map<Date, List<DmDependencyTO>> groupByDate(List<DmDependencyTO> submittedItems, Date now) {
        HashMap<Date, List<DmDependencyTO>> groupedPackages = new HashMap<Date, List<DmDependencyTO>>();
        for (DmDependencyTO submittedItem : submittedItems) {
            ArrayList<DmDependencyTO> goLivePackage;
            Date scheduledDate;
            Date date = scheduledDate = submittedItem.isNow() ? null : submittedItem.getScheduledDate();
            if (scheduledDate == null || scheduledDate.before(now)) {
                scheduledDate = now;
            }
            if ((goLivePackage = (ArrayList<DmDependencyTO>)groupedPackages.get(scheduledDate)) == null) {
                goLivePackage = new ArrayList<DmDependencyTO>();
            }
            goLivePackage.add(submittedItem);
            groupedPackages.put(scheduledDate, goLivePackage);
        }
        return groupedPackages;
    }

    protected void handleReferences(String site, SubmitPackage submitpackage, DmDependencyTO dmDependencyTO, boolean isNotScheduled, SubmitPackage dependencyPackage, String approver, Set<String> rescheduledUris) {
        Set<DmDependencyTO> dependencyTOSet;
        ObjectState state;
        String path = this.contentService.expandRelativeSitePath(site, dmDependencyTO.getUri());
        ObjectMetadata properties = this.objectMetadataManager.getProperties(site, dmDependencyTO.getUri());
        Date scheduledDate = null;
        if (properties != null) {
            scheduledDate = properties.getLaunchDate();
        }
        if ((state = this.objectStateService.getObjectState(site, dmDependencyTO.getUri())) != null && !State.isSubmitted(State.valueOf(state.getState())) && scheduledDate != null && scheduledDate.equals(dmDependencyTO.getScheduledDate())) {
            if (this.objectStateService.isScheduled(site, dmDependencyTO.getUri())) {
                return;
            }
            submitpackage.addToPackage(dmDependencyTO);
        }
        if (!dmDependencyTO.isReference()) {
            submitpackage.addToPackage(dmDependencyTO);
        }
        DependencyRules rule = new DependencyRules(site);
        rule.setObjectStateService(this.objectStateService);
        rule.setContentService(this.contentService);
        if (dmDependencyTO.isSubmittedForDeletion() || dmDependencyTO.isDeleted()) {
            dependencyTOSet = rule.applyDeleteDependencyRule(dmDependencyTO);
        } else {
            long start = System.currentTimeMillis();
            dependencyTOSet = rule.applySubmitRule(dmDependencyTO);
            long end = System.currentTimeMillis();
            logger.debug("Time to get dependencies rule = " + (end - start), new Object[0]);
        }
        for (DmDependencyTO dependencyTO : dependencyTOSet) {
            submitpackage.addToPackage(dependencyTO);
            if (isNotScheduled) continue;
            dependencyPackage.addToPackage(dependencyTO);
        }
        if (this.isRescheduleRequest(dmDependencyTO, site)) {
            rescheduledUris.add(dmDependencyTO.getUri());
        }
    }

    protected boolean areEqual(Date oldDate, Date newDate) {
        if (oldDate == null && newDate == null) {
            return true;
        }
        if (oldDate != null && newDate != null) {
            return oldDate.equals(newDate);
        }
        return false;
    }

    protected void applyDeleteDependencyRule(String site, SubmitPackage pack, DmDependencyTO dmDependencyTO) {
        pack.addToPackage(dmDependencyTO);
        DependencyRules rule = new DependencyRules(site);
        rule.setObjectStateService(this.objectStateService);
        rule.setContentService(this.contentService);
        Set<DmDependencyTO> dependencyTOSet = rule.applyDeleteDependencyRule(dmDependencyTO);
        for (DmDependencyTO dependencyTO : dependencyTOSet) {
            pack.addToPackage(dependencyTO);
        }
    }

    protected Date getScheduledDate(String site, SimpleDateFormat format, String dateStr) {
        return ContentFormatUtils.parseDate(format, dateStr, this.servicesConfig.getDefaultTimezone(site));
    }

    protected void removeChildFromSubmitPackForDelete(List<String> paths) {
        Iterator<String> itr = paths.iterator();
        while (itr.hasNext()) {
            String path = itr.next();
            if (!this.checkParentExistsInSubmitPackForDelete(paths, path)) continue;
            itr.remove();
        }
    }

    protected boolean checkParentExistsInSubmitPackForDelete(List<String> paths, String path) {
        String[] split = path.split("/");
        for (int i = split.length - 1; i >= 0; --i) {
            int lastIndex = path.lastIndexOf(split[i]) - 1;
            if (lastIndex <= 0 || !paths.contains(path = path.substring(0, lastIndex))) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendDeleteApprovalNotification(String site, DmDependencyTO submittedItem, String approver) {
        try {
            String uri;
            ContentItemTO contentItem;
            if (submittedItem.isSendEmail() && (contentItem = this.contentService.getContentItem(site, uri = submittedItem.getUri())) == null) return;
        }
        catch (Exception e) {
            logger.error("Could not send delete approval notification for newly created item", e, new Object[0]);
        }
    }

    protected List<DmDependencyTO> getRefAndChildOfDiffDateFromParent(String site, List<DmDependencyTO> submittedItems, boolean removeInPages) {
        ArrayList<DmDependencyTO> childAndReferences = new ArrayList<DmDependencyTO>();
        for (DmDependencyTO submittedItem : submittedItems) {
            List<DmDependencyTO> children = submittedItem.getChildren();
            Date date = submittedItem.getScheduledDate();
            if (children != null) {
                Iterator<DmDependencyTO> childItr = children.iterator();
                while (childItr.hasNext()) {
                    DmDependencyTO child = childItr.next();
                    Date pageDate = child.getScheduledDate();
                    if ((date != null || pageDate == null) && (date == null || date.equals(pageDate))) continue;
                    if (!submittedItem.isNow()) {
                        child.setNow(false);
                        if (date != null && pageDate != null && pageDate.before(date)) {
                            child.setScheduledDate(date);
                        }
                    }
                    childAndReferences.add(child);
                    List<DmDependencyTO> childDeps = child.flattenChildren();
                    for (DmDependencyTO childDep : childDeps) {
                        if (!this.objectStateService.isUpdatedOrNew(site, childDep.getUri())) continue;
                        childAndReferences.add(childDep);
                    }
                    child.setReference(false);
                    childItr.remove();
                    if (!removeInPages) continue;
                    String uri = child.getUri();
                    List<DmDependencyTO> pages = submittedItem.getPages();
                    if (pages == null) continue;
                    Iterator<DmDependencyTO> pagesIter = pages.iterator();
                    while (pagesIter.hasNext()) {
                        DmDependencyTO page = pagesIter.next();
                        if (!page.getUri().equals(uri)) continue;
                        pagesIter.remove();
                    }
                }
            }
            DependencyRules rule = new DependencyRules(site);
            rule.setContentService(this.contentService);
            rule.setObjectStateService(this.objectStateService);
            childAndReferences.addAll(rule.applySubmitRule(submittedItem));
        }
        return childAndReferences;
    }

    protected void resolveSubmittedPaths(String site, DmDependencyTO item, List<String> submittedPaths) {
        List<DmDependencyTO> children;
        String fullPath = this.contentService.expandRelativeSitePath(site, item.getUri());
        if (!submittedPaths.contains(fullPath)) {
            submittedPaths.add(fullPath);
        }
        if ((children = item.getChildren()) != null) {
            for (DmDependencyTO child : children) {
                String childPath = this.contentService.expandRelativeSitePath(site, child.getUri());
                if (!this.objectStateService.isUpdatedOrNew(site, child.getUri())) continue;
                if (!submittedPaths.contains(childPath)) {
                    submittedPaths.add(childPath);
                }
                this.resolveSubmittedPaths(site, child, submittedPaths);
            }
        }
        DependencyRules rule = new DependencyRules(site);
        rule.setObjectStateService(this.objectStateService);
        rule.setContentService(this.contentService);
        Set<DmDependencyTO> deps = rule.applySubmitRule(item);
        if (deps != null) {
            for (DmDependencyTO dep : deps) {
                String depPath = this.contentService.expandRelativeSitePath(site, dep.getUri());
                if (this.objectStateService.isUpdatedOrNew(site, dep.getUri()) && !submittedPaths.contains(depPath)) {
                    submittedPaths.add(depPath);
                }
                this.resolveSubmittedPaths(site, dep, submittedPaths);
            }
        }
    }

    protected List<DmDependencyTO> getChildrenForRenamedItem(String site, DmDependencyTO renameItem) {
        ArrayList<DmDependencyTO> toRet = new ArrayList<DmDependencyTO>();
        List<DmDependencyTO> children = renameItem.getChildren();
        Date date = renameItem.getScheduledDate();
        if (children != null) {
            Iterator<DmDependencyTO> childItr = children.iterator();
            while (childItr.hasNext()) {
                DmDependencyTO child = childItr.next();
                Date pageDate = child.getScheduledDate();
                if ((date != null || pageDate == null) && (date == null || date.equals(pageDate))) continue;
                if (!renameItem.isNow()) {
                    child.setNow(false);
                    if (date != null && pageDate != null && pageDate.before(date)) {
                        child.setScheduledDate(date);
                    }
                }
                toRet.add(child);
                List<DmDependencyTO> childDeps = child.flattenChildren();
                for (DmDependencyTO childDep : childDeps) {
                    if (!this.objectStateService.isUpdatedOrNew(site, childDep.getUri())) continue;
                    toRet.add(childDep);
                }
                child.setReference(false);
                childItr.remove();
            }
        }
        return toRet;
    }

    @Override
    public void preScheduleDelete(Set<String> urisToDelete, Date scheduleDate, GoLiveContext context, Set rescheduledUris) throws ServiceException {
        String site = context.getSite();
        ArrayList<String> itemsToDelete = new ArrayList<String>(urisToDelete);
        this.dmPublishService.unpublish(site, itemsToDelete, context.getApprover(), scheduleDate);
    }

    @Override
    public List<String> preDelete(Set<String> urisToDelete, GoLiveContext context, Set<String> rescheduledUris) throws ServiceException {
        this.cleanUrisFromWorkflow(urisToDelete, context.getSite());
        this.cleanUrisFromWorkflow(rescheduledUris, context.getSite());
        List<String> deletedItems = this.deleteInTransaction(context.getSite(), new ArrayList<String>(urisToDelete), true, context.getApprover());
        return deletedItems;
    }

    protected List<String> deleteInTransaction(String site, List<String> itemsToDelete, boolean generateActivity, String approver) throws ServiceException {
        this.dmPublishService.unpublish(site, itemsToDelete, approver);
        return null;
    }

    protected void cleanUrisFromWorkflow(Set<String> uris, String site) {
        if (uris != null && !uris.isEmpty()) {
            for (String uri : uris) {
                this.cleanWorkflow(uri, site, Collections.emptySet());
            }
        }
    }

    public boolean cleanWorkflow(String url, String site, Set<DmDependencyTO> dependents) {
        this._cancelWorkflow(site, url);
        return true;
    }

    @Override
    public ResultTO goLive(String site, String request) throws ServiceException {
        String lockKey = "{SITE}_PUBLISHING_LOCK".replace("{SITE}", site.toUpperCase());
        this.generalLockService.lock(lockKey);
        try {
            ResultTO resultTO = this.approve(site, request, Operation.GO_LIVE);
            return resultTO;
        }
        catch (RuntimeException e) {
            logger.error("error making go live", e, new Object[0]);
            throw e;
        }
        finally {
            this.generalLockService.unlock(lockKey);
        }
    }

    protected void goLive(String site, List<DmDependencyTO> submittedItems, String approver) throws ServiceException {
        this.goLive(site, submittedItems, approver, null);
    }

    protected void goLive(String site, List<DmDependencyTO> submittedItems, String approver, MultiChannelPublishingContext mcpContext) throws ServiceException {
        long start = System.currentTimeMillis();
        String pathPrefix = "/wem-projects/" + site + "/" + site + "/work-area";
        Date now = new Date();
        if (submittedItems != null) {
            Map<Date, List<DmDependencyTO>> groupedPackages = this.groupByDate(submittedItems, now);
            for (Date scheduledDate : groupedPackages.keySet()) {
                List<DmDependencyTO> goLivePackage = groupedPackages.get(scheduledDate);
                if (goLivePackage == null) continue;
                Date launchDate = scheduledDate.equals(now) ? null : scheduledDate;
                boolean isNotScheduled = launchDate == null;
                SubmitPackage submitpackage = new SubmitPackage(pathPrefix);
                HashSet<String> rescheduledUris = new HashSet<String>();
                SubmitPackage dependencyPackage = new SubmitPackage("");
                for (DmDependencyTO dmDependencyTO : goLivePackage) {
                    this.goLivepackage(site, submitpackage, dmDependencyTO, isNotScheduled, dependencyPackage, approver, rescheduledUris);
                }
                List<String> stringList = submitpackage.getPaths();
                String label = submitpackage.getLabel();
                SubmitLifeCycleOperation operation = null;
                GoLiveContext context = new GoLiveContext(approver, site);
                if (!isNotScheduled) {
                    HashSet<String> uris = new HashSet<String>();
                    uris.addAll(dependencyPackage.getUris());
                    uris.addAll(submitpackage.getUris());
                    label = this.getScheduleLabel(submitpackage, dependencyPackage);
                    operation = new PreScheduleOperation(this, uris, launchDate, context, rescheduledUris);
                } else {
                    operation = new PreGoLiveOperation((WorkflowService)this, submitpackage.getUris(), context, rescheduledUris);
                }
                if (!stringList.isEmpty()) {
                    HashMap submittedBy = new HashMap();
                    for (String longPath : stringList) {
                        String uri = longPath.substring(pathPrefix.length());
                        this.dmPublishService.cancelScheduledItem(site, uri);
                    }
                    this.workflowProcessor.addToWorkflow(site, stringList, launchDate, label, operation, approver, mcpContext);
                }
                Set<DmDependencyTO> dependencyTOSet = submitpackage.getItems();
                for (DmDependencyTO dmDependencyTO : dependencyTOSet) {
                    this.dmWorkflowListener.postGolive(site, dmDependencyTO);
                }
                dependencyTOSet = dependencyPackage.getItems();
                for (DmDependencyTO dmDependencyTO : dependencyTOSet) {
                    this.dmWorkflowListener.postGolive(site, dmDependencyTO);
                }
            }
        }
        long end = System.currentTimeMillis();
        logger.debug("Total go live time = " + (end - start), new Object[0]);
    }

    protected void goLivepackage(String site, SubmitPackage submitpackage, DmDependencyTO dmDependencyTO, boolean isNotScheduled, SubmitPackage dependencyPackage, String approver, Set<String> rescheduledUris) {
        this.handleReferences(site, submitpackage, dmDependencyTO, isNotScheduled, dependencyPackage, approver, rescheduledUris);
        List<DmDependencyTO> children = dmDependencyTO.getChildren();
        if (children != null) {
            for (DmDependencyTO child : children) {
                this.handleReferences(site, submitpackage, child, isNotScheduled, dependencyPackage, approver, rescheduledUris);
                this.goLivepackage(site, submitpackage, child, isNotScheduled, dependencyPackage, approver, rescheduledUris);
            }
        }
    }

    protected String getScheduleLabel(SubmitPackage submitPackage, SubmitPackage dependencyPack) {
        StringBuilder builder = new StringBuilder("schedule_workflow:");
        builder.append(submitPackage.getLabel()).append(",").append(dependencyPack.getLabel());
        String label = builder.toString();
        if (label.length() > 255) {
            label = label.substring(0, 252) + "..";
        }
        return label;
    }

    protected void approveMultiplePackages(String site, String user, Date scheduledDate, List<DmDependencyTO> goLivePackage) throws ServiceException {
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> packagePaths = new ArrayList<String>();
        for (DmDependencyTO item : goLivePackage) {
            buffer.append(item.getUri() + ", ");
            List<String> paths = this.prepareWorkflowSubmission(site, user, item, scheduledDate, item.isSendEmail());
            packagePaths.addAll(paths);
        }
        String label = buffer.toString();
        if (label.length() > 255) {
            label = label.substring(0, 252) + "..";
        }
        this.submitToWorkflow(site, scheduledDate, label, packagePaths);
    }

    protected void approveSinglePackage(String site, String user, Date scheduledDate, DmDependencyTO submittedItem) throws ServiceException {
        List<String> tasks = submittedItem.getWorkflowTasks();
        if (tasks == null || tasks.size() == 0) {
            List<String> paths = this.prepareWorkflowSubmission(site, user, submittedItem, scheduledDate, submittedItem.isSendEmail());
            String label = submittedItem.getUri();
            if (label.length() > 255) {
                label = label.substring(0, 252) + "..";
            }
            this.submitToWorkflow(site, scheduledDate, label, paths);
        }
    }

    protected List<String> prepareWorkflowSubmission(String site, String user, DmDependencyTO submittedItem, Date launchDate, boolean sendEmail) throws ServiceException {
        return this.prepareWorkflowSubmission(site, user, submittedItem, launchDate, sendEmail, false);
    }

    protected List<String> prepareWorkflowSubmission(String site, String user, DmDependencyTO submittedItem, Date launchDate, boolean sendEmail, boolean submittedForDeletion) throws ServiceException {
        ArrayList<String> paths = new ArrayList<String>();
        String fullPath = this.contentService.expandRelativeSitePath(site, submittedItem.getUri());
        ContentItemTO contentItem = this.contentService.getContentItem(site, submittedItem.getUri());
        if (contentItem != null) {
            if (!submittedItem.isDeleted()) {
                ArrayList<String> includedItems = new ArrayList<String>();
                this.addSubmittedAspect(site, user, null, submittedItem, launchDate, includedItems);
                for (String includedItem : includedItems) {
                    paths.add(includedItem);
                }
            } else {
                String topLevelItem = this.contentService.getRelativeSitePath(site, fullPath);
                paths.add(topLevelItem);
            }
        } else {
            logger.error(submittedItem.getUri() + " does not exist.", new Object[0]);
        }
        return paths;
    }

    protected void addSubmittedAspect(String site, String user, String parentUri, DmDependencyTO submittedItem, Date scheduledDate, List<String> includedItems) throws ServiceException {
        String fullPath = this.contentService.expandRelativeSitePath(site, submittedItem.getUri());
        ContentItemTO node = this.contentService.getContentItem(site, submittedItem.getUri());
        if (node != null) {
            includedItems.add(submittedItem.getUri());
        } else {
            includedItems.add(submittedItem.getUri());
        }
    }

    protected void submitToWorkflow(String site, Date launchDate, String label, List<String> paths) throws ServiceException {
        this.submitToWorkflow(site, launchDate, label, paths, null);
    }

    protected void submitToWorkflow(String site, Date launchDate, String label, List<String> paths, MultiChannelPublishingContext mcpContext) throws ServiceException {
        this._submit(site, launchDate, label, paths, mcpContext);
    }

    protected void _submit(String site, Date launchDate, String label, List<String> paths, MultiChannelPublishingContext mcpContext) {
        if (label.length() > 255) {
            label = label.substring(0, 252) + "..";
        }
        logger.debug("[WORKFLOW] w1,publish for " + label + ",start," + System.currentTimeMillis(), new Object[0]);
        this.dmPublishService.publish(site, paths, launchDate, mcpContext);
    }

    protected void invokeListeners(List<DmDependencyTO> submittedItems, String site, Operation operation) {
        for (DmDependencyTO submittedItem : submittedItems) {
            List<DmDependencyTO> children = submittedItem.getChildren();
            switch (operation) {
                case GO_LIVE: {
                    this.dmWorkflowListener.postGolive(site, submittedItem);
                    break;
                }
                case SUBMIT_TO_GO_LIVE: {
                    this.dmWorkflowListener.postSubmitToGolive(site, submittedItem);
                    break;
                }
                case REJECT: {
                    this.dmWorkflowListener.postReject(site, submittedItem);
                }
            }
            if (null == children || children.isEmpty()) continue;
            this.invokeListeners(children, site, operation);
        }
    }

    @Override
    public boolean isRescheduleRequest(DmDependencyTO dependencyTO, String site) {
        if (dependencyTO.isDeleted() || !dependencyTO.isSubmitted() && !dependencyTO.isInProgress()) {
            String path = this.contentService.expandRelativeSitePath(site, dependencyTO.getUri());
            ContentItemTO to = this.contentService.getContentItem(site, dependencyTO.getUri());
            Date newDate = dependencyTO.getScheduledDate();
            Date oldDate = to.getScheduledDate();
            return !this.areEqual(oldDate, newDate);
        }
        return false;
    }

    @Override
    public void preGoLive(Set<String> uris, GoLiveContext context, Set<String> rescheduledUris) {
    }

    @Override
    public void preSchedule(Set<String> uris, Date date, GoLiveContext context, Set<String> rescheduledUris) {
    }

    public ResultTO submitToDelete(String site, String user, String requestBody) throws ServiceException {
        return this.submitForApproval(site, user, requestBody, true);
    }

    @Override
    public ResultTO reject(String site, String user, String request) throws ServiceException {
        ResultTO result = new ResultTO();
        try {
            int length;
            JSONObject requestObject;
            String approver = user;
            if (StringUtils.isEmpty((String)approver)) {
                approver = this.securityService.getCurrentUser();
            }
            String reason = (requestObject = JSONObject.fromObject((Object)request)).containsKey((Object)this.JSON_KEY_REASON) ? requestObject.getString(this.JSON_KEY_REASON) : "";
            JSONArray items = requestObject.getJSONArray(this.JSON_KEY_ITEMS);
            String scheduledDate = null;
            if (requestObject.containsKey((Object)this.JSON_KEY_SCHEDULED_DATE)) {
                scheduledDate = requestObject.getString(this.JSON_KEY_SCHEDULED_DATE);
            }
            if ((length = items.size()) > 0) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                ArrayList<DmDependencyTO> submittedItems = new ArrayList<DmDependencyTO>();
                for (int index = 0; index < length; ++index) {
                    String stringItem = items.optString(index);
                    DmDependencyTO submittedItem = null;
                    submittedItem = this.getSubmittedItem(site, stringItem, format, scheduledDate);
                    submittedItems.add(submittedItem);
                }
                ArrayList<String> paths = new ArrayList<String>();
                for (DmDependencyTO goLiveItem : submittedItems) {
                    if (!this.contentService.contentExists(site, goLiveItem.getUri())) continue;
                    paths.add(goLiveItem.getUri());
                }
                this.objectStateService.setSystemProcessingBulk(site, paths, true);
                this.reject(site, submittedItems, reason, approver);
                this.objectStateService.setSystemProcessingBulk(site, paths, false);
                result.setSuccess(true);
                result.setStatus(200);
                result.setMessage(this.notificationService.getCompleteMessage(site, "reject"));
            } else {
                result.setSuccess(false);
                result.setMessage("No items provided for preparation.");
            }
        }
        catch (JSONException e) {
            result.setSuccess(false);
            result.setMessage(e.getMessage());
        }
        return result;
    }

    protected void reject(String site, List<DmDependencyTO> submittedItems, String reason, String approver) {
        if (submittedItems != null) {
            for (DmDependencyTO dmDependencyTO : submittedItems) {
                DependencyRules rule = new DependencyRules(site);
                this.rejectThisAndReferences(site, dmDependencyTO, rule, approver, reason);
                List<DmDependencyTO> children = dmDependencyTO.getChildren();
                if (children == null) continue;
                for (DmDependencyTO child : children) {
                    this.rejectThisAndReferences(site, child, rule, approver, reason);
                }
            }
        }
    }

    protected void rejectThisAndReferences(String site, DmDependencyTO dmDependencyTO, DependencyRules rule, String approver, String reason) {
        this._reject(site, dmDependencyTO, approver, true, reason);
        Set<DmDependencyTO> dependencyTOSet = rule.applyRejectRule(dmDependencyTO);
        for (DmDependencyTO dependencyTO : dependencyTOSet) {
            boolean lsendEmail = true;
            try {
                String fullPath = this.contentService.expandRelativeSitePath(site, dependencyTO.getUri());
                ContentItemTO contentItem = this.contentService.getContentItem(site, dependencyTO.getUri());
                lsendEmail = !contentItem.isDocument() && !contentItem.isComponent() && !contentItem.isAsset();
            }
            catch (Exception e) {
                logger.error("during rejection, content retrieve failed", new Object[0]);
                lsendEmail = false;
            }
            this._reject(site, dependencyTO, approver, lsendEmail, reason);
        }
    }

    protected void _reject(String site, DmDependencyTO dmDependencyTO, String approver, boolean sendEmail, String reason) {
        String path = this.contentService.expandRelativeSitePath(site, dmDependencyTO.getUri());
        boolean contentExists = this.contentService.contentExists(site, dmDependencyTO.getUri());
        if (contentExists) {
            ObjectMetadata properties = null;
            if (!this.objectMetadataManager.metadataExist(site, dmDependencyTO.getUri())) {
                this.objectMetadataManager.insertNewObjectMetadata(site, dmDependencyTO.getUri());
            }
            properties = this.objectMetadataManager.getProperties(site, dmDependencyTO.getUri());
            String submittedBy = properties.getSubmittedBy();
            if (sendEmail && StringUtils.isNotEmpty((String)submittedBy) && StringUtils.isNotEmpty((String)approver)) {
                boolean isPreviewable = true;
                try {
                    ContentItemTO contentItem = this.contentService.getContentItem(site, dmDependencyTO.getUri());
                    isPreviewable = contentItem.isPreviewable();
                }
                catch (Exception e) {
                    logger.error("Item cannot be retrieved during rejection notification" + path, new Object[0]);
                }
                this.notificationService.sendRejectionNotification(site, submittedBy, dmDependencyTO.getUri(), reason, approver, isPreviewable);
            }
            HashMap<String, Object> newProps = new HashMap<String, Object>();
            newProps.put("submittedBy", "");
            newProps.put("sendEmail", 0);
            newProps.put("submittedForDeletion", 0);
            newProps.put("launchDate", null);
            this.objectMetadataManager.setObjectMetadata(site, dmDependencyTO.getUri(), newProps);
            ContentItemTO item = this.contentService.getContentItem(site, dmDependencyTO.getUri());
            this.objectStateService.transition(site, item, TransitionEvent.REJECT);
        }
        this.dmWorkflowListener.postReject(site, dmDependencyTO);
    }

    public void setWorkflowJobDAL(WorkflowJobDAL dal) {
        this._workflowJobDAL = dal;
    }

    @Override
    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public void setNotificationService(NotificationService service) {
        this.notificationService = service;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public void setDmDependencyService(DmDependencyService dmDependencyService) {
        this.dmDependencyService = dmDependencyService;
    }

    public void setDmFilterWrapper(DmFilterWrapper dmFilterWrapper) {
        this.dmFilterWrapper = dmFilterWrapper;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public DmPublishService getDmPublishService() {
        return this.dmPublishService;
    }

    public void setDmPublishService(DmPublishService dmPublishService) {
        this.dmPublishService = dmPublishService;
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public DmRenameService getDmRenameService() {
        return this.dmRenameService;
    }

    public void setDmRenameService(DmRenameService dmRenameService) {
        this.dmRenameService = dmRenameService;
    }

    public WorkflowProcessor getWorkflowProcessor() {
        return this.workflowProcessor;
    }

    public void setWorkflowProcessor(WorkflowProcessor workflowProcessor) {
        this.workflowProcessor = workflowProcessor;
    }

    public DmWorkflowListener getDmWorkflowListener() {
        return this.dmWorkflowListener;
    }

    public void setDmWorkflowListener(DmWorkflowListener dmWorkflowListener) {
        this.dmWorkflowListener = dmWorkflowListener;
    }

    public String getCustomContentTypeNotificationPattern() {
        return this.customContentTypeNotificationPattern;
    }

    public void setCustomContentTypeNotificationPattern(String customContentTypeNotificationPattern) {
        this.customContentTypeNotificationPattern = customContentTypeNotificationPattern;
    }

    public boolean isCustomContentTypeNotification() {
        return this.customContentTypeNotification;
    }

    public void setCustomContentTypeNotification(boolean customContentTypeNotification) {
        this.customContentTypeNotification = customContentTypeNotification;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public static class SubmitPackage {
        protected String pathPrefix;
        protected Set<String> paths = new HashSet<String>();
        protected Set<DmDependencyTO> items = new HashSet<DmDependencyTO>();
        protected Set<String> uris = new HashSet<String>();
        protected StringBuilder builder = new StringBuilder();

        public SubmitPackage(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        public void addToPackage(String relativePath) {
            this.paths.add(this.pathPrefix + relativePath);
            this.builder.append(relativePath).append(", ");
            this.uris.add(relativePath);
        }

        public void addToPackage(DmDependencyTO item) {
            this.paths.add(this.pathPrefix + item.getUri());
            this.builder.append(item).append(", ");
            this.items.add(item);
            this.uris.add(item.getUri());
        }

        public Set<String> getUris() {
            return this.uris;
        }

        public List<String> getPaths() {
            return new ArrayList<String>(this.paths);
        }

        public Set<DmDependencyTO> getItems() {
            return this.items;
        }

        public String getLabel() {
            String label = this.builder.toString();
            if (label.length() > 255) {
                label = label.substring(0, 252) + "..";
            }
            return label;
        }
    }

    protected static enum Operation {
        GO_LIVE,
        DELETE,
        SUBMIT_TO_GO_LIVE,
        REJECT;

    }
}

