/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.workflow.dal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.craftercms.studio.api.v1.service.workflow.WorkflowItem;
import org.craftercms.studio.api.v1.service.workflow.WorkflowJob;
import org.craftercms.studio.impl.v1.service.workflow.dal.WorkflowJobDAL;

public abstract class AbstractWorkflowJobDAL
implements WorkflowJobDAL {
    public static final String JOB_ID_PREFIX = "job-";
    public static final String ITM_ID_PREFIX = "itm-";

    @Override
    public WorkflowJob createJob(String site, List<String> srcPaths, String processName, Map<String, String> properties) {
        WorkflowJob retJob = this.newJob(site, processName, properties);
        for (String path : srcPaths) {
            WorkflowItem item = this.createItem(retJob.getId(), path);
            retJob.getItems().add(item);
        }
        this.writeNewJob(retJob);
        return retJob;
    }

    @Override
    public WorkflowItem createItem(String jobId, String path) {
        return this.newItem(jobId, path);
    }

    protected abstract void writeNewJob(WorkflowJob var1);

    protected abstract void writeNewItem(WorkflowItem var1);

    protected WorkflowJob newJob(String site, String processName, Map<String, String> properties) {
        WorkflowJob retJob = new WorkflowJob();
        Date now = new Date();
        ArrayList<WorkflowItem> items = new ArrayList<WorkflowItem>();
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        retJob.setId(this.generateJobId());
        retJob.setCreateDate(now);
        retJob.setModifiedDate(now);
        retJob.setSite(site);
        retJob.setItems(items);
        retJob.setProcessName(processName);
        retJob.setProperties(properties);
        retJob.setCurrentStatus("created");
        return retJob;
    }

    protected WorkflowItem newItem(String jobId, String path) {
        WorkflowItem retItem = new WorkflowItem();
        retItem.setId(this.generateItemId());
        retItem.setJobId(jobId);
        retItem.setPath(path);
        retItem.setPercentComplete(0);
        return retItem;
    }

    protected String generateJobId() {
        String retId = "";
        UUID uuid = UUID.randomUUID();
        retId = JOB_ID_PREFIX + uuid.toString();
        return retId;
    }

    protected String generateItemId() {
        String retId = "";
        UUID uuid = UUID.randomUUID();
        retId = ITM_ID_PREFIX + uuid.toString();
        return retId;
    }
}

