/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.workflow.dal;

import com.ibatis.common.jdbc.ScriptRunner;
import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapClient;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.workflow.WorkflowItem;
import org.craftercms.studio.api.v1.service.workflow.WorkflowJob;
import org.craftercms.studio.api.v1.service.workflow.WorkflowJobProperty;
import org.craftercms.studio.impl.v1.service.workflow.dal.AbstractWorkflowJobDAL;

public class DbWorkflowJobDAL
extends AbstractWorkflowJobDAL {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbWorkflowJobDAL.class);
    private static final String TABLE_JOB = "workflowJob";
    private static final String TABLE_JOB_PROPERTY = "workflowJobProperty";
    private static final String TABLE_ITEM = "workflowItem";
    private static final String STATEMENT_CHECK_TABLE_EXISTS = "checkTableExists";
    private static final String INDEX_ID = "Id";
    private static final String INDEX_STATE = "State";
    private static final String STATEMENT_GET_JOB = "getJob";
    private static final String STATEMENT_GET_JOBS_BY_STATES = "getJobsByStates";
    private static final String STATEMENT_UPDATE_JOB = "updateJob";
    private static final String STATEMENT_DELETE_JOB = "deleteJob";
    private static final String STATEMENT_CREATE_JOB = "createJob";
    private static final String STATEMENT_GET_ITEM = "getItem";
    private static final String STATEMENT_GET_ITEMS_BY_JOB = "getItemsByJob";
    private static final String STATEMENT_UPDATE_ITEM = "updateItem";
    private static final String STATEMENT_DELETE_ITEM = "deleteItem";
    private static final String STATEMENT_CREATE_ITEM = "createItem";
    private static final String STATEMENT_DELETE_JOB_PROPERTIES = "deleteJobProperties";
    private static final String STATEMENT_CREATE_JOB_PROPERTY = "createJobProperty";
    protected DataSource dataSource;
    protected SqlMapClient sqlMap;
    protected String initializeScriptPath;

    @Override
    public WorkflowJob getJob(String id) {
        WorkflowJob job = null;
        try {
            LOGGER.debug("[TRANSLATION] looking up job by id: {0}", id);
            job = (WorkflowJob)this.sqlMap.queryForObject(STATEMENT_GET_JOB, (Object)id);
        }
        catch (SQLException e) {
            LOGGER.error("[TRANSLATION] Error while finding a job by id: {0}", e, id);
        }
        return job;
    }

    @Override
    public List<WorkflowJob> getJobsByState(Set<String> states) {
        List jobs = null;
        try {
            LOGGER.debug("[TRANSLATION] looking up job by states: {0}", states);
            HashMap<String, Set<String>> params = null;
            if (states != null && !states.isEmpty()) {
                params = new HashMap<String, Set<String>>();
                params.put("states", states);
            }
            jobs = this.sqlMap.queryForList(STATEMENT_GET_JOBS_BY_STATES, params);
        }
        catch (SQLException e) {
            LOGGER.error("[TRANSLATION] Error while querying for jobs by states: {0}", e, states);
        }
        return jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public WorkflowJob updateJob(WorkflowJob job) {
        block12: {
            LOGGER.debug("[TRANSLATION] updating job: {0}", job);
            this.sqlMap.startTransaction();
            this.sqlMap.update(STATEMENT_UPDATE_JOB, (Object)job);
            String jobId = job.getId();
            this.sqlMap.delete(STATEMENT_DELETE_JOB_PROPERTIES, (Object)jobId);
            Map<String, String> properties = job.getProperties();
            if (!properties.isEmpty()) {
                this.sqlMap.startBatch();
                for (String name : properties.keySet()) {
                    WorkflowJobProperty property = new WorkflowJobProperty(jobId, name, properties.get(name));
                    this.sqlMap.insert(STATEMENT_CREATE_JOB_PROPERTY, (Object)property);
                }
                this.sqlMap.executeBatch();
            }
            this.sqlMap.commitTransaction();
            try {
                this.sqlMap.endTransaction();
            }
            catch (SQLException e) {
                LOGGER.error("[TRANSLATION] Error creating a job: {0}", e, job);
            }
            break block12;
            catch (SQLException e) {
                try {
                    LOGGER.error("[TRANSLATION] Error while updating job: {0}", e, job);
                }
                catch (Throwable throwable) {
                    try {
                        this.sqlMap.endTransaction();
                    }
                    catch (SQLException e2) {
                        LOGGER.error("[TRANSLATION] Error creating a job: {0}", e2, job);
                    }
                    throw throwable;
                }
                try {
                    this.sqlMap.endTransaction();
                }
                catch (SQLException e3) {
                    LOGGER.error("[TRANSLATION] Error creating a job: {0}", e3, job);
                }
            }
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean deleteJob(String id) {
        boolean result;
        block10: {
            result = false;
            LOGGER.debug("[TRANSLATION] deleting a job by id: {0}", id);
            this.sqlMap.startTransaction();
            this.sqlMap.delete(STATEMENT_DELETE_JOB, (Object)id);
            this.sqlMap.delete(STATEMENT_DELETE_JOB_PROPERTIES, (Object)id);
            this.sqlMap.delete("deleteJobItems", (Object)id);
            this.sqlMap.commitTransaction();
            result = true;
            try {
                this.sqlMap.endTransaction();
            }
            catch (SQLException e) {
                LOGGER.error("[TRANSLATION] Error deleting a job: {0}", e, id);
            }
            break block10;
            catch (SQLException e) {
                try {
                    LOGGER.error("[TRANSLATION] Error while deleting a job by id: {0}", e, id);
                }
                catch (Throwable throwable) {
                    try {
                        this.sqlMap.endTransaction();
                    }
                    catch (SQLException e2) {
                        LOGGER.error("[TRANSLATION] Error deleting a job: {0}", e2, id);
                    }
                    throw throwable;
                }
                try {
                    this.sqlMap.endTransaction();
                }
                catch (SQLException e3) {
                    LOGGER.error("[TRANSLATION] Error deleting a job: {0}", e3, id);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void writeNewJob(WorkflowJob job) {
        block14: {
            Map<String, String> properties;
            LOGGER.debug("[TRANSLATION] creating a job: {0}", job);
            this.sqlMap.startTransaction();
            this.sqlMap.insert(STATEMENT_CREATE_JOB, (Object)job);
            String jobId = job.getId();
            LOGGER.debug("[TRANSLATION] writing properties of job: {0}", jobId);
            List<WorkflowItem> items = job.getItems();
            if (!items.isEmpty()) {
                this.sqlMap.startBatch();
                for (WorkflowItem item : items) {
                    this.sqlMap.insert(STATEMENT_CREATE_ITEM, (Object)item);
                }
                this.sqlMap.executeBatch();
            }
            if (!(properties = job.getProperties()).isEmpty()) {
                this.sqlMap.startBatch();
                for (String name : properties.keySet()) {
                    WorkflowJobProperty property = new WorkflowJobProperty(jobId, name, properties.get(name));
                    this.sqlMap.insert(STATEMENT_CREATE_JOB_PROPERTY, (Object)property);
                }
                this.sqlMap.executeBatch();
            }
            this.sqlMap.commitTransaction();
            try {
                this.sqlMap.endTransaction();
            }
            catch (SQLException e) {
                LOGGER.error("[TRANSLATION] Error creating a job: {0}", e, job);
            }
            break block14;
            catch (SQLException e) {
                try {
                    LOGGER.error("[TRANSLATION] Error creating a job: {0}", e, job);
                }
                catch (Throwable throwable) {
                    try {
                        this.sqlMap.endTransaction();
                    }
                    catch (SQLException e2) {
                        LOGGER.error("[TRANSLATION] Error creating a job: {0}", e2, job);
                    }
                    throw throwable;
                }
                try {
                    this.sqlMap.endTransaction();
                }
                catch (SQLException e3) {
                    LOGGER.error("[TRANSLATION] Error creating a job: {0}", e3, job);
                }
            }
        }
    }

    @Override
    public WorkflowItem getItem(String id) {
        WorkflowItem item = null;
        try {
            LOGGER.debug("[TRANSLATION] looking up an item by id: {0}", id);
            item = (WorkflowItem)this.sqlMap.queryForObject(STATEMENT_GET_ITEM, (Object)id);
        }
        catch (SQLException e) {
            LOGGER.error("[TRANSLATION] Error while querying for an item by id: {0}", e, id);
        }
        return item;
    }

    @Override
    public List<WorkflowItem> getItemsByJob(String jobId) {
        List items = null;
        try {
            LOGGER.debug("[TRANSLATION] looking up items by job id: {0}", jobId);
            items = this.sqlMap.queryForList(STATEMENT_GET_ITEMS_BY_JOB, (Object)jobId);
        }
        catch (SQLException e) {
            LOGGER.error("[TRANSLATION] Error while querying for itmes by job id: {0}", e, jobId);
        }
        return items;
    }

    @Override
    public WorkflowItem updateItem(WorkflowItem item) {
        try {
            LOGGER.debug("[TRANSLATION] updating item: {0}", item);
            this.sqlMap.update(STATEMENT_UPDATE_ITEM, (Object)item);
        }
        catch (SQLException e) {
            LOGGER.error("[TRANSLATION] Error while updating item by id: {0}", e, item.getId());
        }
        return item;
    }

    @Override
    public boolean deleteItem(String id) {
        boolean result = false;
        try {
            LOGGER.debug("[TRANSLATION] deleting an item by id: {0}", id);
            this.sqlMap.delete(STATEMENT_DELETE_ITEM, (Object)id);
            result = true;
        }
        catch (SQLException e) {
            LOGGER.error("[TRANSLATION] Error while deleting an item by id: {0}", e, id);
        }
        return result;
    }

    @Override
    protected void writeNewItem(WorkflowItem item) {
        try {
            LOGGER.debug("[TRANSLATION] creating an item: {0}", item);
            WorkflowItem newItem = (WorkflowItem)this.sqlMap.insert(STATEMENT_CREATE_ITEM, (Object)item);
            item.setId(newItem.getId());
        }
        catch (SQLException e) {
            LOGGER.error("[TRANSLATION] Error while creating an item: {0}", e, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initTable() {
        DataSource dataSource = this.sqlMap.getDataSource();
        Connection connection = null;
        int oldval = -1;
        try {
            List checkTable;
            connection = dataSource.getConnection();
            oldval = connection.getTransactionIsolation();
            if (oldval != 2) {
                connection.setTransactionIsolation(2);
            }
            if ((checkTable = this.sqlMap.queryForList(STATEMENT_CHECK_TABLE_EXISTS)) == null || checkTable.size() == 0) {
                ScriptRunner scriptRunner = new ScriptRunner(connection, false, true);
                scriptRunner.runScript(Resources.getResourceAsReader((String)this.initializeScriptPath));
                LOGGER.debug("Adding indexes to {0}workflowJob", new Object[0]);
                this.addTableIndex(connection, TABLE_JOB, INDEX_ID);
                this.addTableIndex(connection, TABLE_JOB, INDEX_STATE);
                LOGGER.debug("Adding indexes to {0}workflowJobProperty", new Object[0]);
                this.addTableIndex(connection, TABLE_JOB_PROPERTY, INDEX_ID);
                LOGGER.debug("Adding indexes to {0}workflowItem", new Object[0]);
                this.addTableIndex(connection, TABLE_ITEM, INDEX_ID);
            }
            if (oldval != -1) {
                connection.setTransactionIsolation(oldval);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while initializing workflow tables and indexes.", e, new Object[0]);
        }
        finally {
            this.closeConnection(connection);
            connection = null;
        }
    }

    private void addTableIndex(Connection connection, String table, String column) throws SQLException, IOException {
        List indexCheckResult = this.sqlMap.queryForList(table + ".check" + column + "Index");
        if (indexCheckResult == null || indexCheckResult.size() == 0) {
            this.sqlMap.insert(table + ".add" + column + "Index");
            connection.commit();
        }
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                LOGGER.error("Error while closing connection.", e, new Object[0]);
            }
            connection = null;
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public SqlMapClient getSqlMap() {
        return this.sqlMap;
    }

    public void setSqlMap(SqlMapClient sqlMap) {
        this.sqlMap = sqlMap;
    }

    public String getInitializeScriptPath() {
        return this.initializeScriptPath;
    }

    public void setInitializeScriptPath(String initializeScriptPath) {
        this.initializeScriptPath = initializeScriptPath;
    }
}

