/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.workflow.dal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.craftercms.studio.api.v1.service.workflow.WorkflowItem;
import org.craftercms.studio.api.v1.service.workflow.WorkflowJob;
import org.craftercms.studio.impl.v1.service.workflow.dal.AbstractWorkflowJobDAL;

public class InMemoryWorkflowJobDAL
extends AbstractWorkflowJobDAL {
    protected Map<String, WorkflowJob> _jobs = new HashMap<String, WorkflowJob>();
    protected Map<String, WorkflowItem> _items = new HashMap<String, WorkflowItem>();

    @Override
    public WorkflowJob getJob(String id) {
        return this._jobs.get(id);
    }

    @Override
    public List<WorkflowJob> getJobsByState(Set<String> states) {
        ArrayList<WorkflowJob> retJobs = new ArrayList<WorkflowJob>();
        Set<String> ids = this._jobs.keySet();
        for (String id : ids) {
            WorkflowJob job = this._jobs.get(id);
            if (states != null && !states.contains(job.getCurrentStatus())) continue;
            retJobs.add(job);
        }
        return retJobs;
    }

    @Override
    public WorkflowJob updateJob(WorkflowJob job) {
        this._jobs.put(job.getId(), job);
        return job;
    }

    @Override
    public boolean deleteJob(String id) {
        this._jobs.remove(id);
        return true;
    }

    @Override
    public WorkflowItem getItem(String id) {
        return this._items.get(id);
    }

    @Override
    public List<WorkflowItem> getItemsByJob(String jobId) {
        ArrayList<WorkflowItem> retItems = new ArrayList<WorkflowItem>();
        Set<String> ids = this._items.keySet();
        for (String id : ids) {
            WorkflowItem item = this._items.get(id);
            if (jobId != item.getJobId()) continue;
            retItems.add(item);
        }
        return retItems;
    }

    @Override
    public WorkflowItem updateItem(WorkflowItem item) {
        this._items.put(item.getId(), item);
        return item;
    }

    @Override
    public boolean deleteItem(String id) {
        this._items.remove(id);
        return true;
    }

    @Override
    protected void writeNewJob(WorkflowJob job) {
        this._jobs.put(job.getId(), job);
    }

    @Override
    protected void writeNewItem(WorkflowItem item) {
        this._items.put(item.getId(), item);
    }
}

