/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.workflow.job;

import java.util.List;
import javax.transaction.UserTransaction;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.transaction.TransactionService;
import org.craftercms.studio.api.v1.service.workflow.WorkflowJob;
import org.craftercms.studio.api.v1.service.workflow.WorkflowService;
import org.craftercms.studio.impl.v1.job.RepositoryJob;
import org.craftercms.studio.impl.v1.service.workflow.WorkflowManager;

public class ProcessInFlightJobs
extends RepositoryJob {
    private static final Logger logger = LoggerFactory.getLogger(ProcessInFlightJobs.class);
    protected final String MSG_UNABLE_TO_EXECUTE_JOB = "unable_to_execute_workflow_job_as";
    protected final String MSG_PROCESSING_ACTIVE_WORKFLOW_JOBS = "processing_active_workflow_jobs";
    protected final String MSG_PROCESSING_WORKFLOW_JOB = "processing_workflow_job";
    protected final String MSG_ERROR_PROCESSING_WORKFLOW_JOB = "err_processing_workflow_job";
    protected final String MSG_ERROR_NO_TRANSACTION_PROCESSING_WORKFLOW_JOB = "err_no_transaction_while_processing_workflow_job";
    protected TransactionService _transactionService;
    protected WorkflowManager _workflowManager;
    protected WorkflowService _workflowService;

    @Override
    public void executeAsSignedInUser() {
        try {
            this.processJobs();
        }
        catch (Exception err) {
            logger.error("unable_to_execute_workflow_job_as", err, "admin");
        }
    }

    public void processJobs() {
        logger.info("processing_active_workflow_jobs", new Object[0]);
        List<WorkflowJob> allJobs = this._workflowService.getJobsInState(null);
        for (WorkflowJob job : allJobs) {
            try {
                UserTransaction tx = this._transactionService.getTransaction();
                try {
                    tx.begin();
                    logger.info("processing_workflow_job", job.getId());
                    this._workflowManager.handleJobState(job);
                    tx.commit();
                }
                catch (Exception err) {
                    logger.error("err_processing_workflow_job", err, job.getId());
                    tx.rollback();
                }
            }
            catch (Exception err) {
                logger.error("err_no_transaction_while_processing_workflow_job", err, job.getId());
            }
        }
    }

    public WorkflowService getWorkflowService() {
        return this._workflowService;
    }

    public void setWorkflowService(WorkflowService service) {
        this._workflowService = service;
    }

    public WorkflowManager getWorkflowManager() {
        return this._workflowManager;
    }

    public void setWorkflowManager(WorkflowManager mgr) {
        this._workflowManager = mgr;
    }

    public TransactionService getTransactionService() {
        return this._transactionService;
    }

    public void setTransactionService(TransactionService service) {
        this._transactionService = service;
    }
}

