/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentFormatUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentFormatUtils.class);
    public static final Pattern PATTERN_ISO_DATE_MODEL = Pattern.compile("([0-9]{4}\\-[0-9]{2}\\-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2})((\\+|\\-)[0-9]{2}:[0-9]{2})");
    public static final Pattern PATTERN_ISO_DATE_WO_TIME_MODEL = Pattern.compile("([0-9]{4}\\-[0-9]{2}\\-[0-9]{2})((\\+|\\-)[0-9]{2}:[0-9]{2})");
    public static final Pattern PATTERN_DATE_MODEL = Pattern.compile("([0-9]{4}\\-[0-9]{2}\\-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2})((\\+|\\-)[0-9]{2})([0-9]{2})");
    public static final String DATE_PATTERN_MODEL = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String DATE_PATTERN_TIMEZONE_GMT = "GMT";
    public static final String DATE_PATTERN_SCHEDULED = "MM/dd KK:mma";
    public static final SimpleDateFormat DATE_FORMAT_SCHEDULED = new SimpleDateFormat("MM/dd KK:mma");
    protected static SimpleDateFormat DATE_FORMAT_MODEL = null;

    public static Date parseDate(SimpleDateFormat format, String dateStr, String timeZone) {
        Date retDate = null;
        if (format != null && dateStr != null) {
            if (StringUtils.isEmpty((String)timeZone)) {
                format.setTimeZone(TimeZone.getTimeZone(DATE_PATTERN_TIMEZONE_GMT));
            } else {
                format.setTimeZone(TimeZone.getTimeZone(timeZone));
            }
            try {
                retDate = format.parse(dateStr);
            }
            catch (ParseException e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Failed to parse date: " + dateStr + " using format: " + DATE_FORMAT_MODEL);
                }
            }
        } else {
            LOGGER.error("Requested date format with null args dateStr: " + dateStr + " using format: " + format);
        }
        return retDate;
    }

    public static Date parseDate(SimpleDateFormat format, String dateStr) {
        return ContentFormatUtils.parseDate(format, dateStr, DATE_PATTERN_TIMEZONE_GMT);
    }

    public static String formatDate(SimpleDateFormat format, Date date, String timeZone) {
        if (StringUtils.isEmpty((String)timeZone)) {
            format.setTimeZone(TimeZone.getTimeZone(DATE_PATTERN_TIMEZONE_GMT));
        } else {
            format.setTimeZone(TimeZone.getTimeZone(timeZone));
        }
        return format.format(date);
    }

    public static String formatDate(SimpleDateFormat format, Date date) {
        return format.format(date);
    }

    public static boolean getBooleanValue(String str) {
        return !StringUtils.isEmpty((String)str) && str.equalsIgnoreCase("true");
    }

    public static long getLongValue(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            LOGGER.error("failed to get a long value from " + str, (Throwable)e);
            return -1L;
        }
    }

    public static int getIntValue(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            LOGGER.error("failed to get a number from " + str, (Throwable)e);
            return -1;
        }
    }

    public static String convertFromFormDate(String date) {
        if (!StringUtils.isEmpty((String)date)) {
            Matcher matcher = PATTERN_ISO_DATE_MODEL.matcher(date);
            Matcher matcher2 = PATTERN_ISO_DATE_WO_TIME_MODEL.matcher(date);
            if (matcher.matches()) {
                String convertedDate = matcher.group(1) + matcher.group(2).replace(":", "");
                return convertedDate;
            }
            if (matcher2.matches()) {
                String convertedDate = matcher2.group(1) + "T00:00:01" + matcher2.group(2).replace(":", "");
                return convertedDate;
            }
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Failed to convert from ISO date. " + date + " does not match " + PATTERN_ISO_DATE_MODEL.toString() + ", Or " + PATTERN_ISO_DATE_WO_TIME_MODEL.toString());
            }
        }
        return null;
    }

    public static String convertToFormDate(String date) {
        if (!StringUtils.isEmpty((String)date)) {
            Matcher matcher = PATTERN_DATE_MODEL.matcher(date);
            if (matcher.matches()) {
                String convertedDate = matcher.group(1) + matcher.group(2) + ":" + matcher.group(4);
                return convertedDate;
            }
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Failed to convert to ISO date. " + date + " does not match " + PATTERN_DATE_MODEL.toString());
            }
        }
        return null;
    }
}

