/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.util;

import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.impl.v1.util.ContentComparatorBase;

public class ContentItemOrderComparator
extends ContentComparatorBase<ContentItemTO> {
    private static final long serialVersionUID = 1771650786602918784L;
    private static final Logger logger = LoggerFactory.getLogger(ContentItemOrderComparator.class);
    protected boolean _listFloatingPagesLast;
    protected boolean _listLevelDescriptorsFirst;

    public void setListFloatingPagesLast(boolean listFloatingPagesLast) {
        this._listFloatingPagesLast = listFloatingPagesLast;
    }

    public boolean isListFloatingPagesLast() {
        return this._listFloatingPagesLast;
    }

    public void setListLevelDescriptorsFirst(boolean listLevelDescriptorsFirst) {
        this._listLevelDescriptorsFirst = listLevelDescriptorsFirst;
    }

    public boolean isListLevelDescriptorsFirst() {
        return this._listLevelDescriptorsFirst;
    }

    public ContentItemOrderComparator(String orderName, boolean ascending, boolean listFloatingPagesLast, boolean listLevelDescriptorsFirst) {
        super(orderName, ascending);
        this._listFloatingPagesLast = listFloatingPagesLast;
        this._listLevelDescriptorsFirst = listLevelDescriptorsFirst;
    }

    public int hashCodeOf(ContentItemTO item) {
        if (item != null) {
            return item.hashCode();
        }
        return 0;
    }

    public boolean areEqual(ContentItemTO item1, ContentItemTO item2) {
        if (item1 == null && item2 == null) {
            return true;
        }
        if (item1 == null || item2 == null) {
            return false;
        }
        return item1.equals(item2);
    }

    public int compare(ContentItemTO item1, ContentItemTO item2) {
        if (this._listLevelDescriptorsFirst) {
            if (item1.isLevelDescriptor() && !item2.isLevelDescriptor()) {
                return this._ascending ? -1 : 1;
            }
            if (!item1.isLevelDescriptor() && item2.isLevelDescriptor()) {
                return this._ascending ? 1 : -1;
            }
        }
        if (item1.isFolder() && !item1.isPage() && (!item2.isFolder() || item2.isFolder() && item2.isPage())) {
            return this._ascending ? 1 : -1;
        }
        if ((!item1.isFolder() || item1.isFolder() && item1.isPage()) && item2.isFolder() && !item2.isPage()) {
            return this._ascending ? -1 : 1;
        }
        if (item1.isFolder() && !item1.isPage() && item2.isFolder() && !item2.isPage()) {
            return this.compareStrings(item1.getName(), item2.getName(), this._ascending);
        }
        if (this._listFloatingPagesLast) {
            if (item1.isFloating() && !item2.isFloating()) {
                return this._ascending ? 1 : -1;
            }
            if (!item1.isFloating() && item2.isFloating()) {
                return this._ascending ? -1 : 1;
            }
        }
        if (item1.isFloating() && item2.isFloating()) {
            String item1InternalName = item1.getInternalName() != null ? item1.getInternalName().toLowerCase() : null;
            String item2InternalName = item2.getInternalName() != null ? item2.getInternalName().toLowerCase() : null;
            return this.compareStrings(item1InternalName, item2InternalName, this._ascending);
        }
        Double value1 = item1.getOrder(this._sort);
        Double value2 = item2.getOrder(this._sort);
        if (value1 == null && value2 == null) {
            return 0;
        }
        if (value1 == null) {
            return this._ascending ? 1 : -1;
        }
        if (value2 == null) {
            return this._ascending ? -1 : 1;
        }
        if (value1 < 0.0 && value2 < 0.0) {
            String item1InternalName = item1.getInternalName() != null ? item1.getInternalName().toLowerCase() : null;
            String item2InternalName = item2.getInternalName() != null ? item2.getInternalName().toLowerCase() : null;
            return this.compareStrings(item1InternalName, item2InternalName, this._ascending);
        }
        value1 = value1 < 0.0 ? Double.MAX_VALUE : value1;
        value2 = value2 < 0.0 ? Double.MAX_VALUE : value2;
        if (this._ascending) {
            return value1.compareTo(value2);
        }
        return value1.compareTo(value2) * -1;
    }
}

