/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.util;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.activity.ActivityService;
import org.craftercms.studio.impl.v1.util.XmlUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class ContentUtils {
    private static final Logger logger = LoggerFactory.getLogger(ContentUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            logger.error("Failed to release a resource.", e, new Object[0]);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            logger.error("Failed to relase a resource.", e, new Object[0]);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            logger.error("Failed to release a reader.", e, new Object[0]);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document convertStreamToXml(InputStream is) throws DocumentException {
        InputStreamReader isReader = null;
        try {
            isReader = new InputStreamReader(is, "UTF-8");
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read((Reader)isReader);
            return document;
        }
        catch (DocumentException e) {
            logger.error("Error while coverting stream to XML", (Exception)((Object)e), new Object[0]);
            Document document = null;
            return document;
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Error while coverting stream to XML", e, new Object[0]);
            Document document = null;
            return document;
        }
        finally {
            ContentUtils.release(is);
            ContentUtils.release(isReader);
        }
    }

    public static String generateActivityValue(ActivityService.ActivityType activity) {
        return "org.craftercms.cstudio." + activity.toString().toLowerCase();
    }

    public static Date getEditedDate(String str) {
        if (!StringUtils.isEmpty((String)str)) {
            try {
                return new ISO8601DateFormat().parse(str);
            }
            catch (ParseException e) {
                logger.error("No activity post date provided.", new Object[0]);
                return null;
            }
        }
        logger.error("No activity post date provided.", new Object[0]);
        return null;
    }

    public static boolean matchesPatterns(String uri, List<String> patterns) {
        if (patterns != null) {
            for (String pattern : patterns) {
                if (!uri.matches(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMd5ForFile(InputStream input) {
        String result = null;
        MessageDigest md = null;
        try {
            int numBytes;
            md = MessageDigest.getInstance("MD5");
            md.reset();
            byte[] bytes = new byte[1024];
            input.mark(Integer.MAX_VALUE);
            while ((numBytes = input.read(bytes)) != -1) {
                md.update(bytes, 0, numBytes);
            }
            byte[] digest = md.digest();
            result = new String(Hex.encodeHex((byte[])digest));
            input.reset();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Error while creating MD5 digest", e, new Object[0]);
        }
        catch (IOException e) {
            logger.error("Error while reading input stream", e, new Object[0]);
        }
        return result;
    }

    public static String getMd5ForFile(String data) {
        ByteArrayInputStream is = null;
        String fileName = null;
        try {
            is = new ByteArrayInputStream(data.getBytes("UTF-8"));
            fileName = ContentUtils.getMd5ForFile(is);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Error while creating MD5 digest", e, new Object[0]);
        }
        return fileName;
    }

    public static String getParentUrl(String url) {
        int lastIndex = url.lastIndexOf("/");
        return url.substring(0, lastIndex);
    }

    public static String getPageName(String url) {
        int lastIndex = url.lastIndexOf("/");
        return url.substring(lastIndex + 1);
    }

    public static InputStream convertDocumentToStream(Document document, String encoding) {
        try {
            return new ByteArrayInputStream(XmlUtils.convertDocumentToString(document).getBytes(encoding));
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Failed to convert document to stream with encoding: " + encoding, e, new Object[0]);
            return null;
        }
        catch (IOException e) {
            logger.error("Failed to convert document to stream with encoding: " + encoding, e, new Object[0]);
            return null;
        }
    }
}

