/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.craftercms.studio.impl.v1.util.NullResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomUtils {
    public static Document createXmlDocument(String xmlAsString) {
        return DomUtils.createXmlDocument(xmlAsString, "UTF-8");
    }

    public static Document createXmlDocument(String xmlAsString, String encoding) {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setIgnoringComments(false);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            document = builder.parse(new InputSource(new StringReader(xmlAsString)));
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return document;
    }

    public static Document createXmlDocument(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setNamespaceAware(true);
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        db.setEntityResolver(new NullResolver());
        return db.parse(is);
    }

    public static String xmlToString(Node node) {
        return DomUtils.xmlToString(node, "UTF-8");
    }

    public static String xmlToString(Node node, String encoding) {
        String retXmlAsString = "";
        try {
            DOMSource source = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", encoding);
            transformer.transform(source, result);
            retXmlAsString = stringWriter.toString();
            retXmlAsString = retXmlAsString.replace("&nbsp;", "&#160;");
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return retXmlAsString;
    }

    public static void dumpStringToConsole(String value) {
        try {
            PrintStream outx = new PrintStream((OutputStream)System.out, true, "UTF-8");
            outx.println(value);
        }
        catch (Exception e) {
            System.out.println("error dumping string to console" + e);
        }
    }
}

