/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.util;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;

public class ValueConverter
implements Serializable {
    protected static final long serialVersionUID = -6194104691768087456L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueConverter.class);

    public static Date convertToDate(String formatString, String date) {
        if (!StringUtils.isEmpty((String)date)) {
            try {
                SimpleDateFormat format = new SimpleDateFormat(formatString);
                if (format != null) {
                    return format.parse(date);
                }
                LOGGER.error(formatString + " is not a valid datetime format.", new Object[0]);
            }
            catch (ParseException e) {
                LOGGER.error(date + " is not valid value for " + formatString, new Object[0]);
            }
        }
        return null;
    }

    public static Date convertFromFormDate(String formatString, String date) {
        String convertedValue;
        if (!StringUtils.isEmpty((String)date) && (convertedValue = ContentFormatUtils.convertFromFormDate(date)) != null) {
            return ValueConverter.convertToDate(formatString, convertedValue);
        }
        return null;
    }
}

