/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.util.spring.context;

import org.craftercms.studio.api.v1.ebus.RepositoryEventContext;
import org.craftercms.studio.api.v1.service.security.SecurityProvider;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class SiteConfigurationLoader
implements ApplicationListener<ContextRefreshedEvent> {
    protected SiteService siteService;
    protected SecurityProvider securityProvider;
    protected String adminUser;
    protected String adminPassword;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        String ticket = this.securityProvider.authenticate(this.adminUser, this.adminPassword);
        RepositoryEventContext repositoryEventContext = new RepositoryEventContext(ticket);
        RepositoryEventContext.setCurrent(repositoryEventContext);
        this.siteService.reloadSiteConfigurations();
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public String getAdminUser() {
        return this.adminUser;
    }

    public void setAdminUser(String adminUser) {
        this.adminUser = adminUser;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }
}

