/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.controller;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.craftercms.commons.monitoring.MemoryMonitor;
import org.craftercms.commons.monitoring.StatusMonitor;
import org.craftercms.commons.monitoring.VersionMonitor;
import org.craftercms.engine.util.logging.CircularQueueLogAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/1/monitoring"})
public class MonitoringController {
    private static final Logger logger = LoggerFactory.getLogger(MonitoringController.class);
    public static final String URL_ROOT = "/api/1/monitoring";
    public static final String MEMORY_URL = "/memory";
    public static final String STATUS_URL = "/status";
    public static final String VERSION_URL = "/version";
    public static final String LOG_URL = "/log";

    @GetMapping(value={"/memory"})
    public ResponseEntity<List<MemoryMonitor>> getMemoryStats() {
        return new ResponseEntity((Object)MemoryMonitor.getMemoryStats(), HttpStatus.OK);
    }

    @GetMapping(value={"/status"})
    public ResponseEntity<StatusMonitor> getCurrentStatus() {
        return new ResponseEntity((Object)StatusMonitor.getCurrentStatus(), HttpStatus.OK);
    }

    @GetMapping(value={"/version"})
    public ResponseEntity<VersionMonitor> getCurrentVersion() throws Exception {
        try {
            return new ResponseEntity((Object)VersionMonitor.getVersion(this.getClass()), HttpStatus.OK);
        }
        catch (IOException e) {
            logger.error("Unable to read manifest file", (Throwable)e);
            throw new IOException("Unable to read manifest file", e);
        }
    }

    @GetMapping(value={"/log"})
    public List<HashMap<String, Object>> getLoggedEvents(@RequestParam String site, @RequestParam long since) {
        return CircularQueueLogAppender.loggerQueue().getLoggedEvents(site, since);
    }
}

