/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.controller;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.lang.UrlUtils;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.engine.service.context.SiteContext;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class StaticAssetsRequestHandler
extends ResourceHttpRequestHandler {
    private static final Log logger = LogFactory.getLog(StaticAssetsRequestHandler.class);
    private ContentStoreService contentStoreService;
    private String staticAssetsPath;
    private boolean disableCaching;

    protected void init() {
        if (this.disableCaching) {
            this.setCacheControl(CacheControl.noCache());
        }
        this.setRequireSession(false);
    }

    @Required
    public void setContentStoreService(ContentStoreService contentStoreService) {
        this.contentStoreService = contentStoreService;
    }

    public void setStaticAssetsPath(String staticAssetsPath) {
        this.staticAssetsPath = staticAssetsPath;
    }

    public void setDisableCaching(boolean disableCaching) {
        this.disableCaching = disableCaching;
    }

    protected Resource getResource(HttpServletRequest request) {
        Content content;
        SiteContext siteContext = SiteContext.getCurrent();
        String path = this.getPath(request, siteContext);
        if (siteContext == null) {
            throw new IllegalStateException("No current site context found");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Trying to get content for static asset at [context=" + siteContext + ", path='" + path + "']"));
        }
        if ((content = this.getContent(siteContext, path)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No static asset found at [context=" + siteContext + ", path='" + path + "'] - returning 404"));
            }
            return null;
        }
        return this.toResource(content, path);
    }

    protected Resource toResource(Content content, String path) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected String getPath(HttpServletRequest request, SiteContext siteContext) {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalStateException("Required request attribute '" + HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE + "' is not set");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.staticAssetsPath)) {
            return UrlUtils.concat((String)this.staticAssetsPath, (String)path);
        }
        return UrlUtils.concat((String)siteContext.getStaticAssetsPath(), (String)path);
    }

    protected Content getContent(SiteContext siteContext, String path) {
        return this.contentStoreService.findContent(siteContext.getContext(), path);
    }
}

