/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.controller.rest;

import java.util.Collection;
import java.util.Map;
import org.craftercms.core.controller.rest.CacheRestController;
import org.craftercms.core.exception.CacheException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.service.context.SiteContextManager;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.bind.annotation.RequestParam;

public class FreeMarkerAwareCacheRestController
extends CacheRestController {
    protected SiteContextManager siteContextManager;

    @Required
    public void setSiteContextManager(SiteContextManager siteContextManager) {
        this.siteContextManager = siteContextManager;
    }

    public Map<String, String> clearAllScopes() throws CacheException {
        Collection contexts = this.siteContextManager.listContexts();
        for (SiteContext siteContext : contexts) {
            siteContext.getFreeMarkerConfig().getConfiguration().clearTemplateCache();
        }
        return super.clearAllScopes();
    }

    public Map<String, String> clearScope(@RequestParam(value="contextId") String contextId) throws InvalidContextException, CacheException {
        Collection contexts = this.siteContextManager.listContexts();
        for (SiteContext siteContext : contexts) {
            if (!siteContext.getContext().getId().equals(contextId)) continue;
            siteContext.getFreeMarkerConfig().getConfiguration().clearTemplateCache();
            break;
        }
        return super.clearScope(contextId);
    }
}

