/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.controller.rest;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.lang.UrlUtils;
import org.craftercms.commons.validation.ValidationException;
import org.craftercms.commons.validation.ValidationRuntimeException;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.util.ExceptionUtils;
import org.craftercms.engine.exception.HttpStatusCodeAwareException;
import org.craftercms.engine.exception.ScriptNotFoundException;
import org.craftercms.engine.scripting.ScriptFactory;
import org.craftercms.engine.scripting.ScriptUrlTemplateScanner;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.GroovyScriptUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.util.UriTemplate;

public class RestScriptsController
extends AbstractController {
    private static final Log logger = LogFactory.getLog(RestScriptsController.class);
    public static final String DEFAULT_RESPONSE_BODY_MODEL_ATTR_NAME = "responseBody";
    public static final String DEFAULT_ERROR_MESSAGE_MODEL_ATTR_NAME = "message";
    private static final String SCRIPT_URL_FORMAT = "%s.%s.%s";
    protected String responseBodyModelAttributeName = "responseBody";
    protected String errorMessageModelAttributeName = "message";
    protected ScriptUrlTemplateScanner urlTemplateScanner;

    public void setResponseBodyModelAttributeName(String responseBodyModelAttributeName) {
        this.responseBodyModelAttributeName = responseBodyModelAttributeName;
    }

    public void setErrorMessageModelAttributeName(String errorMessageModelAttributeName) {
        this.errorMessageModelAttributeName = errorMessageModelAttributeName;
    }

    public void setUrlTemplateScanner(ScriptUrlTemplateScanner urlTemplateScanner) {
        this.urlTemplateScanner = urlTemplateScanner;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        SiteContext siteContext = SiteContext.getCurrent();
        ScriptFactory scriptFactory = siteContext.getScriptFactory();
        if (scriptFactory == null) {
            throw new IllegalStateException("No script factory associate to current site context '" + siteContext.getSiteName() + "'");
        }
        String serviceUrl = this.getServiceUrl(request);
        String scriptUrl = this.getScriptUrl(scriptFactory, siteContext, request, serviceUrl);
        Map scriptVariables = this.createScriptVariables(request, response);
        scriptUrl = this.parseScriptUrlForVariables(siteContext, scriptUrl, scriptVariables);
        Object responseBody = this.executeScript(scriptFactory, scriptVariables, response, scriptUrl);
        if (response.isCommitted()) {
            logger.debug((Object)("Response already committed by script " + scriptUrl));
            return null;
        }
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.addObject(this.responseBodyModelAttributeName, responseBody);
        return modelAndView;
    }

    protected String getServiceUrl(HttpServletRequest request) {
        String pathWithinHandlerMappingAttr = HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE;
        String url = (String)request.getAttribute(pathWithinHandlerMappingAttr);
        if (StringUtils.isEmpty((CharSequence)url)) {
            throw new IllegalStateException("Required request attribute '" + pathWithinHandlerMappingAttr + "' is not set");
        }
        return url;
    }

    protected String parseScriptUrlForVariables(SiteContext siteContext, String scriptUrl, Map<String, Object> variables) {
        List urlTemplates;
        ContentStoreService storeService = siteContext.getStoreService();
        if (!storeService.exists(siteContext.getContext(), scriptUrl) && this.urlTemplateScanner != null && CollectionUtils.isNotEmpty((Collection)(urlTemplates = this.urlTemplateScanner.scan(siteContext)))) {
            for (UriTemplate template : urlTemplates) {
                if (!template.matches(scriptUrl)) continue;
                Map pathVars = template.match(scriptUrl);
                String actualScriptUrl = template.toString();
                variables.put("pathVars", pathVars);
                return actualScriptUrl;
            }
        }
        return scriptUrl;
    }

    protected String getScriptUrl(ScriptFactory scriptFactory, SiteContext siteContext, HttpServletRequest request, String serviceUrl) {
        String baseUrl = UrlUtils.concat((String)siteContext.getRestScriptsPath(), (String)FilenameUtils.removeExtension((String)serviceUrl));
        return String.format(SCRIPT_URL_FORMAT, baseUrl, request.getMethod().toLowerCase(), scriptFactory.getScriptFileExtension());
    }

    protected Map<String, Object> createScriptVariables(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        GroovyScriptUtils.addRestScriptVariables(variables, (HttpServletRequest)request, (HttpServletResponse)response, (ServletContext)this.getServletContext());
        return variables;
    }

    protected Object executeScript(ScriptFactory scriptFactory, Map<String, Object> scriptVariables, HttpServletResponse response, String scriptUrl) {
        try {
            return scriptFactory.getScript(scriptUrl).execute(scriptVariables);
        }
        catch (ScriptNotFoundException e) {
            logger.error((Object)("Script not found at " + scriptUrl), (Throwable)e);
            response.setStatus(400);
            return Collections.singletonMap(this.errorMessageModelAttributeName, "REST script not found");
        }
        catch (Exception e) {
            logger.error((Object)("Error executing REST script at " + scriptUrl), (Throwable)e);
            String errorMsg = this.checkHttpStatusCodeAwareException(e, response);
            if (StringUtils.isEmpty((CharSequence)errorMsg) && StringUtils.isEmpty((CharSequence)(errorMsg = this.checkValidationException(e, response)))) {
                response.setStatus(500);
                errorMsg = e.getMessage();
            }
            return Collections.singletonMap(this.errorMessageModelAttributeName, errorMsg);
        }
    }

    protected String checkHttpStatusCodeAwareException(Exception e, HttpServletResponse response) {
        HttpStatusCodeAwareException cause = (HttpStatusCodeAwareException)ExceptionUtils.getThrowableOfType((Throwable)e, HttpStatusCodeAwareException.class);
        if (cause != null) {
            response.setStatus(cause.getStatusCode());
            return ((Exception)cause).getMessage();
        }
        return null;
    }

    protected String checkValidationException(Exception e, HttpServletResponse response) {
        Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
        if (cause instanceof ValidationException || cause instanceof ValidationRuntimeException) {
            response.setStatus(400);
            return cause.getMessage();
        }
        return null;
    }
}

