/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.controller.rest;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.cache.CacheStatistics;
import org.craftercms.core.service.CacheService;
import org.craftercms.engine.service.context.SiteContext;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${crafter.core.rest.base.uri}/site/cache"})
public class SiteCacheRestController {
    private static final Log logger = LogFactory.getLog(SiteCacheRestController.class);
    public static final String URL_ROOT = "/site/cache";
    public static final String URL_CLEAR = "/clear";
    public static final String URL_STATS = "/statistics";
    protected CacheService cacheService;

    @Required
    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    @RequestMapping(value={"/clear"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> clear() {
        SiteContext siteContext = SiteContext.getCurrent();
        String siteName = siteContext.getSiteName();
        this.cacheService.clearScope(siteContext.getContext());
        siteContext.getFreeMarkerConfig().getConfiguration().clearTemplateCache();
        String msg = "Content cache and Freemarker cache have been cleared for site '" + siteName + "'";
        logger.debug((Object)msg);
        return Collections.singletonMap("message", msg);
    }

    @ResponseBody
    @RequestMapping(value={"/statistics"}, method={RequestMethod.GET})
    public CacheStatistics getStatistics() {
        SiteContext siteContext = SiteContext.getCurrent();
        return this.cacheService.getStatistics(siteContext.getContext());
    }
}

