/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.controller.rest;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.craftercms.core.controller.rest.RestControllerBase;
import org.craftercms.engine.service.context.SiteContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${crafter.core.rest.base.uri}/site/jobs"})
public class SiteScheduledJobsController
extends RestControllerBase {
    public static final String URL_ROOT = "/site/jobs";
    public static final String URL_LIST = "/list";

    @GetMapping(value={"/list"})
    public List<Map<String, String>> listScheduledJobs() throws SchedulerException {
        LinkedList<Map<String, String>> jobs = new LinkedList<Map<String, String>>();
        SiteContext siteContext = SiteContext.getCurrent();
        Scheduler scheduler = siteContext.getScheduler();
        if (scheduler != null) {
            List groups = scheduler.getJobGroupNames();
            for (String group : groups) {
                Set keys = scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)group));
                for (JobKey key : keys) {
                    List triggers = scheduler.getTriggersOfJob(key);
                    HashMap<String, String> job = new HashMap<String, String>();
                    job.put("name", key.getName());
                    job.put("nextFireTime", ((Trigger)triggers.get(0)).getNextFireTime().toInstant().toString());
                    jobs.add(job);
                }
            }
        }
        return jobs;
    }
}

