/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.exception;

import org.craftercms.core.exception.CrafterException;
import org.craftercms.engine.exception.HttpStatusCodeAwareException;
import org.springframework.http.HttpStatus;

public class HttpStatusCodeException
extends CrafterException
implements HttpStatusCodeAwareException {
    private HttpStatus status;

    public HttpStatusCodeException(int statusCode) {
        this(HttpStatus.valueOf((int)statusCode));
    }

    public HttpStatusCodeException(int statusCode, String message, Throwable cause) {
        this(HttpStatus.valueOf((int)statusCode), message, cause);
    }

    public HttpStatusCodeException(int statusCode, String message) {
        this(HttpStatus.valueOf((int)statusCode), message);
    }

    public HttpStatusCodeException(int statusCode, Throwable cause) {
        this(HttpStatus.valueOf((int)statusCode), cause);
    }

    public HttpStatusCodeException(HttpStatus status) {
        this.status = status;
    }

    public HttpStatusCodeException(HttpStatus status, String message, Throwable cause) {
        super(message, cause);
        this.status = status;
    }

    public HttpStatusCodeException(HttpStatus status, String message) {
        super(message);
        this.status = status;
    }

    public HttpStatusCodeException(HttpStatus status, Throwable cause) {
        super(cause);
        this.status = status;
    }

    public int getStatusCode() {
        return this.status.value();
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public String toString() {
        String clazz = this.getClass().getName();
        String message = this.getLocalizedMessage();
        message = message != null ? "[" + this.status.getReasonPhrase() + "] " + message : "[" + this.status.getReasonPhrase() + "]";
        return clazz + ": " + message;
    }
}

