/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.freemarker;

import freemarker.core.Environment;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import org.craftercms.commons.http.RequestContext;
import org.springframework.beans.factory.annotation.Required;

public class CrafterTemplateExceptionHandler
implements TemplateExceptionHandler {
    public static final String FREEMARKER_CURRENT_ERROR_ID_ATTRIBUTE = "freemarkerCurrentErrorId";
    public static final String ERROR_FORMAT = "<script type='text/javascript'>function showError{errorId}() {document.getElementById('error{errorId}').style.display = 'block';document.getElementById('toggleError{errorId}Btn').innerHTML = 'Hide error';}function hideError{errorId}() {document.getElementById('error{errorId}').style.display = 'none';document.getElementById('toggleError{errorId}Btn').innerHTML = 'Show error';}function toggleError{errorId}() {if (document.getElementById('error{errorId}').style.display == 'none') {showError{errorId}();} else {hideError{errorId}();}}</script><a id='toggleError{errorId}Btn' onclick='toggleError{errorId}()' style='color: red; font-size: 14px; font-family: Arial, Helvetica, sans-serif; font-style: normal; font-variant: normal; font-weight: normal; text-decoration: underline; text-transform: none; cursor: pointer'>Show error</a><div id='error{errorId}' style='display: none;'><pre>${error}</pre></div>";
    private boolean displayTemplateExceptionsInView;

    @Required
    public void setDisplayTemplateExceptionsInView(boolean displayTemplateExceptionsInView) {
        this.displayTemplateExceptionsInView = displayTemplateExceptionsInView;
    }

    public void handleTemplateException(TemplateException te, Environment env, Writer out) throws TemplateException {
        if (this.displayTemplateExceptionsInView) {
            String error = ERROR_FORMAT.replace("{errorId}", this.createErrorId());
            error = error.replace("{error}", this.getExceptionStackTrace(te));
            try {
                out.write(error);
            }
            catch (IOException e) {
                throw new TemplateException("Failed to print error. Cause: " + e, env);
            }
        }
    }

    protected String getExceptionStackTrace(TemplateException te) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        te.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    protected String createErrorId() {
        HttpServletRequest request = RequestContext.getCurrent().getRequest();
        Integer currentErrorId = (Integer)request.getAttribute(FREEMARKER_CURRENT_ERROR_ID_ATTRIBUTE);
        if (currentErrorId == null) {
            currentErrorId = 1;
        } else {
            Integer n = currentErrorId;
            Integer n2 = currentErrorId = Integer.valueOf(currentErrorId + 1);
        }
        request.setAttribute(FREEMARKER_CURRENT_ERROR_ID_ATTRIBUTE, (Object)currentErrorId);
        return currentErrorId.toString();
    }
}

