/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.freemarker;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.utility.DeepUnwrap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.engine.freemarker.ExecuteControllerDirective;
import org.craftercms.engine.model.SiteItem;
import org.craftercms.engine.scripting.Script;
import org.craftercms.engine.scripting.ScriptFactory;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.GroovyScriptUtils;
import org.springframework.beans.factory.annotation.Required;

public class ExecuteControllerDirective
implements TemplateDirectiveModel {
    private static final Log logger = LogFactory.getLog(ExecuteControllerDirective.class);
    public static final String PATH_PARAM_NAME = "path";
    protected ServletContext servletContext;

    @Required
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        TemplateModel pathParam = (TemplateModel)params.get(PATH_PARAM_NAME);
        if (pathParam == null) {
            throw new IllegalArgumentException("No 'path' param specified");
        }
        this.executeController(this.getPath(pathParam, env), env);
    }

    protected void executeController(String path, Environment env) throws TemplateException {
        Script script;
        Map scriptVariables = this.createScriptVariables(env);
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            ScriptFactory scriptFactory = siteContext.getScriptFactory();
            if (scriptFactory == null) {
                throw new IllegalStateException("No script factory associate to current site context '" + siteContext.getSiteName() + "'");
            }
            try {
                script = scriptFactory.getScript(path);
            }
            catch (Exception e) {
                throw new TemplateException("Unable to load controller at '" + path + "'", e, env);
            }
        } else {
            throw new IllegalStateException("No current site context found");
        }
        this.executeController(script, scriptVariables, env);
    }

    protected void executeController(Script script, Map<String, Object> variables, Environment env) throws TemplateException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing controller at " + script.getUrl()));
        }
        try {
            script.execute(variables);
        }
        catch (Exception e) {
            throw new TemplateException("Error executing controller at " + script.getUrl(), e, env);
        }
    }

    protected Map<String, Object> createScriptVariables(Environment env) throws TemplateException {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        RequestContext context = RequestContext.getCurrent();
        SiteItem contentModel = this.getContentModel(env);
        Object templateModel = this.getTemplateModel(env);
        if (context == null) {
            throw new IllegalStateException("No current request context found");
        }
        GroovyScriptUtils.addSiteItemScriptVariables(variables, (HttpServletRequest)context.getRequest(), (HttpServletResponse)context.getResponse(), (ServletContext)this.servletContext, (SiteItem)contentModel, (Object)templateModel);
        return variables;
    }

    protected String getPath(TemplateModel pathParam, Environment env) throws TemplateException {
        Object unwrappedPath = DeepUnwrap.unwrap((TemplateModel)pathParam);
        if (unwrappedPath instanceof String) {
            return (String)unwrappedPath;
        }
        throw new TemplateException("Param 'path of unexpected type: expected: " + String.class.getName() + ", actual: " + unwrappedPath.getClass().getName(), env);
    }

    protected SiteItem getContentModel(Environment env) throws TemplateException {
        TemplateModel contentModel = env.getVariable("contentModel");
        if (contentModel != null) {
            Object unwrappedContentModel = DeepUnwrap.unwrap((TemplateModel)contentModel);
            if (unwrappedContentModel instanceof SiteItem) {
                return (SiteItem)unwrappedContentModel;
            }
            throw new TemplateException("Variable 'contentModel of unexpected type: expected: " + SiteItem.class.getName() + ", actual: " + unwrappedContentModel.getClass().getName(), env);
        }
        return null;
    }

    protected Object getTemplateModel(Environment env) throws TemplateException {
        return new EnvironmentGroovyBeanWrapper(env);
    }
}

