/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.http.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.craftercms.engine.exception.HttpProxyException;
import org.craftercms.engine.http.HttpProxy;
import org.springframework.beans.factory.annotation.Required;

public class HttpProxyImpl
implements HttpProxy {
    private static final Log logger = LogFactory.getLog(HttpProxyImpl.class);
    private String baseServiceUrl;
    private CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).build();

    @Required
    public void setBaseServiceUrl(String baseServiceUrl) {
        this.baseServiceUrl = StringUtils.stripEnd((String)baseServiceUrl, (String)"/");
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void proxyGet(String url, HttpServletRequest request, HttpServletResponse response) throws HttpProxyException {
        this.proxyRequest(url, true, request, response);
    }

    public void proxyPost(String url, HttpServletRequest request, HttpServletResponse response) {
        this.proxyRequest(url, false, request, response);
    }

    protected void proxyRequest(String url, boolean isGet, HttpServletRequest request, HttpServletResponse response) throws HttpProxyException {
        String targetUrl = this.createTargetUrl(url, request);
        HttpRequestBase httpRequest = null;
        CloseableHttpResponse httpResponse = null;
        try {
            httpRequest = isGet ? this.createGetRequest(targetUrl, request) : this.createPostRequest(targetUrl, request);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Proxying to " + this.getRequestDescription((HttpUriRequest)httpRequest)));
            }
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
            response.setStatus(httpResponse.getStatusLine().getStatusCode());
            String responseBody = IOUtils.toString((InputStream)httpResponse.getEntity().getContent());
            if (httpResponse.getStatusLine().getStatusCode() >= 400 && logger.isDebugEnabled()) {
                logger.debug((Object)("Received error response from " + this.getRequestDescription((HttpUriRequest)httpRequest) + ": status = " + httpResponse.getStatusLine().getReasonPhrase() + ", response body = \n" + responseBody));
            }
            this.copyActualResponseHeaders((HttpUriRequest)httpRequest, response);
            this.copyActualResponseBody(responseBody, response);
        }
        catch (Exception e) {
            String errorMsg = httpRequest != null ? "Error while proxying to " + this.getRequestDescription((HttpUriRequest)httpRequest) : "Error while proxing to " + (isGet ? "GET[" : "POST[") + targetUrl + "]";
            logger.error((Object)errorMsg, (Throwable)e);
            throw new HttpProxyException(errorMsg, (Throwable)e);
        }
        finally {
            if (httpRequest != null) {
                httpRequest.releaseConnection();
            }
        }
    }

    protected HttpRequestBase createGetRequest(String url, HttpServletRequest request) {
        HttpGet getRequest = new HttpGet(url);
        this.copyOriginalHeaders((HttpUriRequest)getRequest, request);
        return getRequest;
    }

    protected HttpRequestBase createPostRequest(String url, HttpServletRequest request) throws IOException {
        HttpPost postRequest = new HttpPost(url);
        this.copyOriginalHeaders((HttpUriRequest)postRequest, request);
        this.copyOriginalRequestBody(postRequest, request);
        return postRequest;
    }

    protected void copyOriginalHeaders(HttpUriRequest httpRequest, HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String headerValue = request.getHeader(headerName);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(this.getRequestDescription(httpRequest) + " copying request header " + headerName + ": " + headerValue));
                }
                httpRequest.addHeader(headerName, headerValue);
            }
        }
    }

    protected void copyOriginalRequestBody(HttpPost httpRequest, HttpServletRequest request) throws IOException {
        int contentLength = request.getContentLength();
        if (contentLength > 0) {
            String contentType = request.getContentType();
            ServletInputStream content = request.getInputStream();
            httpRequest.setEntity((HttpEntity)new InputStreamEntity((InputStream)content, (long)contentLength, ContentType.create((String)contentType)));
        }
    }

    protected void copyActualResponseHeaders(HttpUriRequest httpRequest, HttpServletResponse response) {
        Header[] headers;
        for (Header header : headers = httpRequest.getAllHeaders()) {
            String headerName = header.getName();
            String headerValue = header.getValue();
            if (headerName.equals("Transfer-Encoding") || header.equals("chunked")) continue;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(this.getRequestDescription(httpRequest) + " copying response header " + headerName + ": " + headerValue));
            }
            if (response.containsHeader(headerName)) {
                response.setHeader(headerName, headerValue);
                continue;
            }
            response.addHeader(headerName, headerValue);
        }
    }

    protected void copyActualResponseBody(String responseBody, HttpServletResponse response) throws IOException {
        if (responseBody != null) {
            response.setContentLength(responseBody.length());
            ServletOutputStream out = response.getOutputStream();
            out.write(responseBody.getBytes());
            out.flush();
        }
    }

    protected String createTargetUrl(String url, HttpServletRequest request) {
        StringBuilder targetUrl = new StringBuilder();
        if (!url.startsWith(this.baseServiceUrl)) {
            targetUrl.append(this.baseServiceUrl);
            if (!this.baseServiceUrl.endsWith("/") && !url.startsWith("/")) {
                targetUrl.append("/");
            }
        }
        targetUrl.append(url).append(this.createTargetQueryString(request));
        return targetUrl.toString();
    }

    protected String createTargetQueryString(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            queryString = "";
        }
        return queryString;
    }

    private String getRequestDescription(HttpUriRequest httpRequest) {
        return httpRequest.getMethod() + "[" + httpRequest.getURI() + "]";
    }
}

