/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.http.impl;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.core.util.ExceptionUtils;
import org.craftercms.engine.exception.HttpStatusCodeAwareException;
import org.craftercms.engine.http.ExceptionHandler;

public class HttpStatusCodeAwareExceptionHandler
implements ExceptionHandler {
    private static final Log logger = LogFactory.getLog(HttpStatusCodeAwareExceptionHandler.class);

    public boolean handle(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        HttpStatusCodeAwareException httpStatusCodeAwareEx = (HttpStatusCodeAwareException)ExceptionUtils.getThrowableOfType((Throwable)ex, HttpStatusCodeAwareException.class);
        if (httpStatusCodeAwareEx != null) {
            ex = (Exception)httpStatusCodeAwareEx;
            logger.error((Object)(request.getMethod() + " " + HttpUtils.getFullRequestUri((HttpServletRequest)request, (boolean)true) + " failed"), (Throwable)ex);
            response.sendError(httpStatusCodeAwareEx.getStatusCode(), ex.getMessage());
            return true;
        }
        return false;
    }
}

