/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.macro.impl;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.craftercms.engine.macro.Macro;
import org.craftercms.engine.macro.MacroResolver;
import org.springframework.beans.factory.annotation.Required;

public class MacroResolverImpl
implements MacroResolver {
    private List<Macro> macros;

    @Required
    public void setMacros(List<Macro> macros) {
        this.macros = macros;
    }

    public String resolveMacros(String str) {
        return this.resolveMacros(str, null);
    }

    public String resolveMacros(String str, Map<String, ?> macroValues) {
        if (MapUtils.isNotEmpty(macroValues)) {
            for (Map.Entry<String, Object> entry : macroValues.entrySet()) {
                String macroName = "{" + entry.getKey() + "}";
                Object macroValue = entry.getValue();
                str = str.replace(macroName, macroValue.toString());
            }
        }
        for (Macro macro : this.macros) {
            str = macro.resolve(str);
        }
        return str;
    }
}

