/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.craftercms.commons.converters.Converter;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.Tree;
import org.craftercms.core.util.XmlUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class SiteItem {
    protected Item item;
    protected List<SiteItem> childItems;
    protected Converter<Element, Object> modelFieldConverter;
    protected Comparator<SiteItem> sortComparator;

    public SiteItem(Item item, Converter<Element, Object> modelFieldConverter, Comparator<SiteItem> sortComparator) {
        this.item = item;
        this.modelFieldConverter = modelFieldConverter;
        this.sortComparator = sortComparator;
    }

    public Item getItem() {
        return this.item;
    }

    public String getStoreName() {
        return this.item.getName();
    }

    public String getStoreUrl() {
        return this.item.getUrl();
    }

    public boolean isFolder() {
        return this.item.isFolder();
    }

    public Document getDom() {
        return this.item.getDescriptorDom();
    }

    public Map<String, Object> getProperties() {
        return this.item.getProperties();
    }

    public Object get(String xpathExpression) {
        if (this.getDom() != null) {
            Object result = XmlUtils.selectObject((Node)this.getDom().getRootElement(), (String)xpathExpression);
            if (result instanceof Element) {
                return this.modelFieldConverter.convert((Object)((Element)result));
            }
            return result;
        }
        return null;
    }

    public String queryValue(String xpathExpression) {
        if (this.getDom() != null) {
            return XmlUtils.selectSingleNodeValue((Node)this.getDom().getRootElement(), (String)xpathExpression);
        }
        return null;
    }

    public List<String> queryValues(String xpathExpression) {
        if (this.getDom() != null) {
            return XmlUtils.selectNodeValues((Node)this.getDom().getRootElement(), (String)xpathExpression);
        }
        return null;
    }

    public String queryValue(String xpathExpression, Map<String, String> namespaceUris) {
        if (this.getDom() != null) {
            return XmlUtils.selectSingleNodeValue((Node)this.getDom().getRootElement(), (String)xpathExpression, namespaceUris);
        }
        return null;
    }

    public List<String> queryValues(String xpathExpression, Map<String, String> namespaceUris) {
        if (this.getDom() != null) {
            return XmlUtils.selectNodeValues((Node)this.getDom().getRootElement(), (String)xpathExpression, namespaceUris);
        }
        return null;
    }

    public List<SiteItem> getChildItems() {
        if (this.childItems == null) {
            if (this.item instanceof Tree) {
                List treeChildren = ((Tree)this.item).getChildren();
                if (CollectionUtils.isNotEmpty((Collection)treeChildren)) {
                    this.childItems = new ArrayList(treeChildren.size());
                    for (Item treeChild : treeChildren) {
                        this.childItems.add(this.createItemWrapper(treeChild));
                    }
                    if (this.sortComparator != null) {
                        this.childItems = this.sortItems(this.childItems, this.sortComparator);
                    }
                } else {
                    this.childItems = Collections.emptyList();
                }
            } else {
                this.childItems = Collections.emptyList();
            }
        }
        return this.childItems;
    }

    public SiteItem getChildItem(String storeName) {
        for (SiteItem childItem : this.getChildItems()) {
            if (!childItem.getStoreName().equals(storeName)) continue;
            return childItem;
        }
        return null;
    }

    public String toString() {
        return "SiteItem[storeName='" + this.getStoreName() + '\'' + ", storeUrl='" + this.getStoreUrl() + '\'' + ", folder=" + this.isFolder() + ']';
    }

    protected List<SiteItem> sortItems(List<SiteItem> items, Comparator<SiteItem> comparator) {
        Collections.sort(items, comparator);
        return items;
    }

    protected SiteItem createItemWrapper(Item item) {
        return new SiteItem(item, this.modelFieldConverter, this.sortComparator);
    }
}

