/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.model.sorting;

import java.util.Comparator;
import org.craftercms.engine.model.SiteItem;
import org.craftercms.engine.properties.SiteProperties;

public class OrderDefaultComparator
implements Comparator<SiteItem> {
    public static final String ORDER_DEFAULT_VALUE_KEY = "orderDefault_f";
    public static final float DEFAULT_ORDER_DEFAULT_VALUE = -1.0f;

    @Override
    public int compare(SiteItem siteItem1, SiteItem siteItem2) {
        Float orderDefault1 = this.getOrderDefault(siteItem1);
        Float orderDefault2 = this.getOrderDefault(siteItem2);
        if (orderDefault1 == null) {
            orderDefault1 = Float.valueOf(-1.0f);
        }
        if (orderDefault2 == null) {
            orderDefault2 = Float.valueOf(-1.0f);
        }
        return orderDefault1.compareTo(orderDefault2);
    }

    protected Float getOrderDefault(SiteItem siteItem) {
        Float value = (Float)siteItem.get(ORDER_DEFAULT_VALUE_KEY);
        if (value == null && siteItem.isFolder() && (siteItem = siteItem.getChildItem(SiteProperties.getIndexFileName())) != null) {
            value = (Float)siteItem.get(ORDER_DEFAULT_VALUE_KEY);
        }
        return value;
    }
}

