/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.scripting.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.engine.exception.SchedulingException;
import org.craftercms.engine.scripting.ScriptJobResolver;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.ContentStoreUtils;
import org.craftercms.engine.util.SchedulingUtils;
import org.craftercms.engine.util.quartz.JobContext;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.context.ServletContextAware;

public class FolderBasedScriptJobResolver
implements ScriptJobResolver,
ServletContextAware {
    protected String folderUrl;
    protected String cronExpression;
    protected String scriptSuffix;
    protected ServletContext servletContext;

    @Required
    public void setFolderUrl(String folderUrl) {
        this.folderUrl = folderUrl;
    }

    @Required
    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    @Required
    public void setScriptSuffix(String scriptSuffix) {
        this.scriptSuffix = scriptSuffix;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public List<JobContext> resolveJobs(SiteContext siteContext) throws SchedulingException {
        List scriptUrls = ContentStoreUtils.findChildrenUrl((ContentStoreService)siteContext.getStoreService(), (Context)siteContext.getContext(), (String)this.folderUrl);
        ArrayList<JobContext> jobContexts = null;
        if (CollectionUtils.isNotEmpty((Collection)scriptUrls)) {
            for (String scriptUrl : scriptUrls) {
                if (!scriptUrl.endsWith(this.scriptSuffix)) continue;
                if (jobContexts == null) {
                    jobContexts = new ArrayList<JobContext>();
                }
                jobContexts.add(SchedulingUtils.createJobContext((SiteContext)siteContext, (String)scriptUrl, (String)this.cronExpression, (ServletContext)this.servletContext));
            }
        }
        return jobContexts;
    }
}

