/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.context;

import java.net.URLClassLoader;
import java.util.Arrays;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.core.exception.CrafterException;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.url.UrlTransformationEngine;
import org.craftercms.engine.scripting.ScriptFactory;
import org.craftercms.engine.service.PreviewOverlayCallback;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.MDC;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;

public class SiteContext {
    private static final String SITE_NAME_MDC_KEY = "siteName";
    private static ThreadLocal<SiteContext> threadLocal = new ThreadLocal();
    protected ContentStoreService storeService;
    protected String siteName;
    protected Context context;
    protected boolean fallback;
    protected String staticAssetsPath;
    protected String templatesPath;
    protected String restScriptsPath;
    protected String controllerScriptsPath;
    protected String[] configPaths;
    protected String[] applicationContextPaths;
    protected String groovyClassesPath;
    protected FreeMarkerConfig freeMarkerConfig;
    protected UrlTransformationEngine urlTransformationEngine;
    protected PreviewOverlayCallback overlayCallback;
    protected ScriptFactory scriptFactory;
    protected HierarchicalConfiguration config;
    protected ApplicationContext globalApplicationContext;
    protected ConfigurableApplicationContext applicationContext;
    protected URLClassLoader classLoader;
    protected Scheduler scheduler;

    public static SiteContext getCurrent() {
        return (SiteContext)threadLocal.get();
    }

    public static void setCurrent(SiteContext current) {
        threadLocal.set(current);
        MDC.put((String)SITE_NAME_MDC_KEY, (String)current.getSiteName());
    }

    public static void clear() {
        MDC.remove((String)SITE_NAME_MDC_KEY);
        threadLocal.remove();
    }

    public ContentStoreService getStoreService() {
        return this.storeService;
    }

    public void setStoreService(ContentStoreService storeService) {
        this.storeService = storeService;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public boolean isFallback() {
        return this.fallback;
    }

    public void setFallback(boolean fallback) {
        this.fallback = fallback;
    }

    public String getStaticAssetsPath() {
        return this.staticAssetsPath;
    }

    public void setStaticAssetsPath(String staticAssetsPath) {
        this.staticAssetsPath = staticAssetsPath;
    }

    public String getTemplatesPath() {
        return this.templatesPath;
    }

    public void setTemplatesPath(String templatesPath) {
        this.templatesPath = templatesPath;
    }

    public String getRestScriptsPath() {
        return this.restScriptsPath;
    }

    public void setRestScriptsPath(String restScriptsPath) {
        this.restScriptsPath = restScriptsPath;
    }

    public String getControllerScriptsPath() {
        return this.controllerScriptsPath;
    }

    public void setControllerScriptsPath(String controllerScriptsPath) {
        this.controllerScriptsPath = controllerScriptsPath;
    }

    public String[] getConfigPaths() {
        return this.configPaths;
    }

    public void setConfigPaths(String[] configPaths) {
        this.configPaths = configPaths;
    }

    public String[] getApplicationContextPaths() {
        return this.applicationContextPaths;
    }

    public void setApplicationContextPaths(String[] applicationContextPaths) {
        this.applicationContextPaths = applicationContextPaths;
    }

    public String getGroovyClassesPath() {
        return this.groovyClassesPath;
    }

    public void setGroovyClassesPath(String groovyClassesPath) {
        this.groovyClassesPath = groovyClassesPath;
    }

    public FreeMarkerConfig getFreeMarkerConfig() {
        return this.freeMarkerConfig;
    }

    public void setFreeMarkerConfig(FreeMarkerConfig freeMarkerConfig) {
        this.freeMarkerConfig = freeMarkerConfig;
    }

    public UrlTransformationEngine getUrlTransformationEngine() {
        return this.urlTransformationEngine;
    }

    public void setUrlTransformationEngine(UrlTransformationEngine urlTransformationEngine) {
        this.urlTransformationEngine = urlTransformationEngine;
    }

    public PreviewOverlayCallback getOverlayCallback() {
        return this.overlayCallback;
    }

    public void setOverlayCallback(PreviewOverlayCallback overlayCallback) {
        this.overlayCallback = overlayCallback;
    }

    public ScriptFactory getScriptFactory() {
        return this.scriptFactory;
    }

    public void setScriptFactory(ScriptFactory scriptFactory) {
        this.scriptFactory = scriptFactory;
    }

    public HierarchicalConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(HierarchicalConfiguration config) {
        this.config = config;
    }

    public ApplicationContext getGlobalApplicationContext() {
        return this.globalApplicationContext;
    }

    public void setGlobalApplicationContext(ApplicationContext globalApplicationContext) {
        this.globalApplicationContext = globalApplicationContext;
    }

    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public URLClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(URLClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public boolean isValid() throws CrafterException {
        return this.storeService.validate(this.context);
    }

    public void destroy() throws CrafterException {
        if (this.applicationContext != null) {
            try {
                this.applicationContext.close();
            }
            catch (Exception e) {
                throw new CrafterException("Unable to close application context", (Throwable)e);
            }
        }
        if (this.classLoader != null) {
            try {
                this.classLoader.close();
            }
            catch (Exception e) {
                throw new CrafterException("Unable to close class loader", (Throwable)e);
            }
        }
        if (this.scheduler != null) {
            try {
                this.scheduler.shutdown();
            }
            catch (SchedulerException e) {
                throw new CrafterException("Unable to shutdown scheduler", (Throwable)e);
            }
        }
        this.storeService.destroyContext(this.context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SiteContext siteContext = (SiteContext)o;
        return this.siteName.equals(siteContext.siteName);
    }

    public int hashCode() {
        return this.siteName.hashCode();
    }

    public String toString() {
        return "SiteContext{siteName='" + this.siteName + '\'' + ", context=" + this.context + ", fallback=" + this.fallback + ", staticAssetsPath='" + this.staticAssetsPath + '\'' + ", templatesPath='" + this.templatesPath + '\'' + ", restScriptsPath='" + this.restScriptsPath + '\'' + ", controllerScriptsPath='" + this.controllerScriptsPath + '\'' + ", configPaths=" + Arrays.toString(this.configPaths) + ", applicationContextPaths=" + Arrays.toString(this.applicationContextPaths) + ", groovyClassesPath='" + this.groovyClassesPath + '\'' + '}';
    }
}

