/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.context;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PreDestroy;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.entitlements.exception.EntitlementException;
import org.craftercms.commons.entitlements.model.EntitlementType;
import org.craftercms.commons.entitlements.model.Module;
import org.craftercms.commons.entitlements.validator.EntitlementValidator;
import org.craftercms.core.exception.RootFolderNotFoundException;
import org.craftercms.engine.event.SiteContextCreatedEvent;
import org.craftercms.engine.event.SiteContextDestroyedEvent;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.service.context.SiteContextFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;

public class SiteContextManager
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(SiteContextManager.class);
    protected Lock lock = new ReentrantLock();
    protected Map<String, SiteContext> contextRegistry = new ConcurrentHashMap();
    protected SiteContextFactory contextFactory;
    protected SiteContextFactory fallbackContextFactory;
    protected ApplicationContext applicationContext;
    protected EntitlementValidator entitlementValidator;

    public Lock getLock() {
        return this.lock;
    }

    @Required
    public void setContextFactory(SiteContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    @Required
    public void setFallbackContextFactory(SiteContextFactory fallbackContextFactory) {
        this.fallbackContextFactory = fallbackContextFactory;
    }

    @Required
    public void setEntitlementValidator(EntitlementValidator entitlementValidator) {
        this.entitlementValidator = entitlementValidator;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PreDestroy
    public void destroy() {
        this.destroyAllContexts();
    }

    public Collection<SiteContext> listContexts() {
        return this.contextRegistry.values();
    }

    public void createContexts(Collection<String> siteNames) {
        logger.info((Object)"==================================================");
        logger.info((Object)"<CREATING SITE CONTEXTS>");
        logger.info((Object)"==================================================");
        if (CollectionUtils.isNotEmpty(siteNames)) {
            for (String siteName : siteNames) {
                try {
                    this.createContext(siteName, false);
                }
                catch (Exception e) {
                    logger.error((Object)("Error creating site context for site '" + siteName + "'"), (Throwable)e);
                }
            }
        }
        logger.info((Object)"==================================================");
        logger.info((Object)"</CREATING SITE CONTEXTS>");
        logger.info((Object)"==================================================");
    }

    public SiteContext createContext(String siteName, boolean fallback) {
        return this.getContext(siteName, fallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAllContexts() {
        logger.info((Object)"==================================================");
        logger.info((Object)"<DESTROYING SITE CONTEXTS>");
        logger.info((Object)"==================================================");
        this.lock.lock();
        try {
            Iterator iter = this.contextRegistry.values().iterator();
            while (iter.hasNext()) {
                SiteContext siteContext = (SiteContext)iter.next();
                String siteName = siteContext.getSiteName();
                logger.info((Object)"==================================================");
                logger.info((Object)("<Destroying site context: " + siteName + ">"));
                logger.info((Object)"==================================================");
                try {
                    this.destroyContext(siteContext);
                }
                catch (Exception e) {
                    logger.error((Object)("Error destroying site context for site '" + siteName + "'"), (Throwable)e);
                }
                logger.info((Object)"==================================================");
                logger.info((Object)("</Destroying site context: " + siteName + ">"));
                logger.info((Object)"==================================================");
                iter.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
        logger.info((Object)"==================================================");
        logger.info((Object)"</DESTROYING SITE CONTEXTS>");
        logger.info((Object)"==================================================");
    }

    protected void destroyContexts(Collection<String> siteNames) {
        logger.info((Object)"==================================================");
        logger.info((Object)"<DESTROYING SITE CONTEXTS>");
        logger.info((Object)"==================================================");
        if (CollectionUtils.isNotEmpty(siteNames)) {
            for (String siteName : siteNames) {
                try {
                    this.destroyContext(siteName);
                }
                catch (Exception e) {
                    logger.error((Object)("Error destroying site context for site '" + siteName + "'"), (Throwable)e);
                }
            }
        }
        logger.info((Object)"==================================================");
        logger.info((Object)"</DESTROYING SITE CONTEXTS>");
        logger.info((Object)"==================================================");
    }

    public void destroyContext(String siteName) {
        this.lock.lock();
        try {
            SiteContext siteContext = (SiteContext)this.contextRegistry.remove(siteName);
            if (siteContext != null) {
                logger.info((Object)"==================================================");
                logger.info((Object)("<Destroying site context: " + siteName + ">"));
                logger.info((Object)"==================================================");
                this.destroyContext(siteContext);
                logger.info((Object)"==================================================");
                logger.info((Object)("</Destroying site context: " + siteName + ">"));
                logger.info((Object)"==================================================");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SiteContext getContext(String siteName, boolean fallback) {
        SiteContext siteContext = (SiteContext)this.contextRegistry.get(siteName);
        if (siteContext == null) {
            if (!fallback) {
                try {
                    int totalSites = (int)this.contextRegistry.values().stream().filter(context -> !context.isFallback()).count();
                    this.entitlementValidator.validateEntitlement(Module.ENGINE, EntitlementType.SITE, totalSites, 1);
                }
                catch (EntitlementException e) {
                    return null;
                }
            }
            this.lock.lock();
            try {
                siteContext = (SiteContext)this.contextRegistry.get(siteName);
                if (siteContext != null) return siteContext;
                logger.info((Object)"==================================================");
                logger.info((Object)("<Creating site context: " + siteName + ">"));
                logger.info((Object)"==================================================");
                if (fallback) {
                    siteContext = this.fallbackContextFactory.createContext(siteName);
                    siteContext.setFallback(true);
                } else {
                    siteContext = this.contextFactory.createContext(siteName);
                }
                this.publishEvent((ApplicationEvent)new SiteContextCreatedEvent(siteContext, (Object)this), siteContext);
                this.contextRegistry.put(siteName, siteContext);
                logger.info((Object)("Site context created: " + siteContext));
                logger.info((Object)"==================================================");
                logger.info((Object)("</Creating site context: " + siteName + ">"));
                logger.info((Object)"==================================================");
                return siteContext;
            }
            catch (RootFolderNotFoundException e) {
                logger.error((Object)("Cannot resolve root folder for site '" + siteName + "'"), (Throwable)e);
                return siteContext;
            }
            finally {
                this.lock.unlock();
            }
        }
        if (siteContext.isValid()) return siteContext;
        logger.error((Object)("Site context " + siteContext + " is not valid anymore"));
        this.destroyContext(siteName);
        return null;
    }

    protected void destroyContext(SiteContext siteContext) {
        this.publishEvent((ApplicationEvent)new SiteContextDestroyedEvent(siteContext, (Object)this), siteContext);
        siteContext.destroy();
        logger.info((Object)("Site context destroyed: " + siteContext));
    }

    protected void publishEvent(ApplicationEvent event, SiteContext siteContext) {
        ConfigurableApplicationContext siteApplicationContext = siteContext.getApplicationContext();
        if (siteApplicationContext != null) {
            siteApplicationContext.publishEvent(event);
        } else {
            this.applicationContext.publishEvent(event);
        }
    }
}

