/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.context;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.service.context.SiteContextManager;
import org.craftercms.engine.service.context.SiteContextResolver;
import org.craftercms.engine.service.context.SiteResolver;
import org.springframework.beans.factory.annotation.Required;

public class SiteContextResolverImpl
implements SiteContextResolver {
    public static final String SITE_NAME_ATTRIBUTE = "siteName";
    private static final Log logger = LogFactory.getLog(SiteContextResolverImpl.class);
    protected SiteResolver siteResolver;
    protected SiteContextManager siteContextManager;
    protected String fallbackSiteName;

    @Required
    public void setSiteResolver(SiteResolver siteResolver) {
        this.siteResolver = siteResolver;
    }

    @Required
    public void setSiteContextManager(SiteContextManager siteContextManager) {
        this.siteContextManager = siteContextManager;
    }

    @Required
    public void setFallbackSiteName(String fallbackSiteName) {
        this.fallbackSiteName = fallbackSiteName;
    }

    public SiteContext getContext(HttpServletRequest request) {
        SiteContext siteContext;
        boolean fallback = false;
        String siteName = StringUtils.lowerCase((String)this.siteResolver.getSiteName(request));
        if (StringUtils.isNotEmpty((CharSequence)siteName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Site name resolved for current request: '" + siteName + "'"));
            }
        } else {
            fallback = true;
            siteName = this.fallbackSiteName;
            logger.warn((Object)"Unable to resolve a site name for the request. Using fallback site");
        }
        if ((siteContext = this.getContext(siteName, fallback)) == null && !fallback) {
            logger.warn((Object)("Unable to retrieve context for site name '" + siteName + "'. Using fallback site"));
            siteContext = this.getContext(this.fallbackSiteName, true);
        }
        if (siteContext == null) {
            throw new IllegalStateException("Unable to resolve to a context for site name '" + siteName + "'");
        }
        request.setAttribute(SITE_NAME_ATTRIBUTE, (Object)siteName);
        return siteContext;
    }

    protected SiteContext getContext(String siteName, boolean fallback) {
        SiteContext siteContext = this.siteContextManager.getContext(siteName, fallback);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Site context resolved for current request: " + siteContext));
        }
        return siteContext;
    }
}

