/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.context;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.engine.service.context.SiteListResolver;
import org.craftercms.engine.service.context.SiteResolver;
import org.springframework.beans.factory.annotation.Required;

public class StaticMappingsSiteResolver
implements SiteListResolver,
SiteResolver {
    private static final Log logger = LogFactory.getLog(StaticMappingsSiteResolver.class);
    private Map<String, String> mappings;

    @Required
    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public Collection<String> getSiteList() {
        return new LinkedHashSet<String>(this.mappings.values());
    }

    public String getSiteName(HttpServletRequest request) {
        String domainName = request.getServerName();
        if (this.mappings.containsKey(domainName)) {
            return (String)this.mappings.get(domainName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("No site mapping found for domain name " + domainName));
        }
        return null;
    }
}

