/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.filter;

import java.util.Arrays;
import java.util.List;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.ItemFilter;

public class IncludeByNameItemFilter
implements ItemFilter {
    private String[] includeRegexes;

    public IncludeByNameItemFilter(String includeRegex) {
        this.includeRegexes = new String[1];
        this.includeRegexes[0] = includeRegex;
    }

    public IncludeByNameItemFilter(String[] includeRegexes) {
        this.includeRegexes = includeRegexes;
    }

    public boolean runBeforeProcessing() {
        return true;
    }

    public boolean runAfterProcessing() {
        return false;
    }

    public boolean accepts(Item item, List<Item> acceptedItems, List<Item> rejectedItems, boolean runningBeforeProcessing) {
        for (String includeRegex : this.includeRegexes) {
            if (!item.getName().matches(includeRegex)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "IncludeByNameItemFilter[includeRegexes=" + (this.includeRegexes == null ? null : Arrays.asList(this.includeRegexes)) + ']';
    }
}

