/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.converters.Converter;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.processors.impl.ItemProcessorPipeline;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.ItemFilter;
import org.craftercms.core.service.Tree;
import org.craftercms.core.service.impl.CompositeItemFilter;
import org.craftercms.engine.model.SiteItem;
import org.craftercms.engine.service.SiteItemService;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.service.filter.ExcludeByNameItemFilter;
import org.craftercms.engine.service.filter.ExpectedNodeValueItemFilter;
import org.craftercms.engine.service.filter.IncludeByNameItemFilter;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Required;

public class SiteItemServiceImpl
implements SiteItemService {
    protected ContentStoreService storeService;
    protected List<Predicate<Item>> defaultPredicates;
    protected List<ItemFilter> defaultFilters;
    protected List<ItemProcessor> defaultProcessors;
    protected Converter<Element, Object> modelFieldConverter;
    protected Comparator<SiteItem> sortComparator;

    @Required
    public void setStoreService(ContentStoreService storeService) {
        this.storeService = storeService;
    }

    public void setDefaultPredicates(List<Predicate<Item>> defaultPredicates) {
        this.defaultPredicates = defaultPredicates;
    }

    public void setDefaultFilters(List<ItemFilter> defaultFilters) {
        this.defaultFilters = defaultFilters;
    }

    public void setDefaultProcessors(List<ItemProcessor> defaultProcessors) {
        this.defaultProcessors = defaultProcessors;
    }

    @Required
    public void setModelFieldConverter(Converter<Element, Object> modelFieldConverter) {
        this.modelFieldConverter = modelFieldConverter;
    }

    public void setSortComparator(Comparator<SiteItem> sortComparator) {
        this.sortComparator = sortComparator;
    }

    public Content getRawContent(String url) {
        return this.storeService.findContent(this.getSiteContext().getContext(), url);
    }

    public SiteItem getSiteItem(String url) {
        return this.getSiteItem(url, null);
    }

    public SiteItem getSiteItem(String url, ItemProcessor processor) {
        return this.getSiteItem(url, processor, null);
    }

    public SiteItem getSiteItem(String url, ItemProcessor processor, Predicate<Item> predicate) {
        Item item;
        if (CollectionUtils.isNotEmpty((Collection)this.defaultPredicates)) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>(this.defaultPredicates);
            if (predicate != null) {
                predicates.add(predicate);
            }
            predicate = PredicateUtils.allPredicate(predicates);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.defaultProcessors)) {
            ItemProcessorPipeline processorPipeline = new ItemProcessorPipeline(new ArrayList(this.defaultProcessors));
            if (processor != null) {
                processorPipeline.addProcessor(processor);
            }
            processor = processorPipeline;
        }
        if ((item = this.storeService.findItem(this.getSiteContext().getContext(), null, url, processor)) != null && (predicate == null || predicate.evaluate((Object)item))) {
            return this.createItemWrapper(item);
        }
        return null;
    }

    public SiteItem getSiteTree(String url, int depth) {
        return this.getSiteTree(url, depth, null, (ItemProcessor)null);
    }

    public SiteItem getSiteTree(String url, int depth, ItemFilter filter, ItemProcessor processor) {
        Tree tree;
        if (CollectionUtils.isNotEmpty((Collection)this.defaultFilters)) {
            CompositeItemFilter compositeFilter = new CompositeItemFilter(new ArrayList(this.defaultFilters));
            if (filter != null) {
                compositeFilter.addFilter(filter);
            }
            filter = compositeFilter;
        }
        if (CollectionUtils.isNotEmpty((Collection)this.defaultProcessors)) {
            ItemProcessorPipeline processorPipeline = new ItemProcessorPipeline(new ArrayList(this.defaultProcessors));
            if (processor != null) {
                processorPipeline.addProcessor(processor);
            }
            processor = processorPipeline;
        }
        if ((tree = this.storeService.findTree(this.getSiteContext().getContext(), null, url, depth, filter, processor)) != null) {
            return this.createItemWrapper((Item)tree);
        }
        return null;
    }

    @Deprecated
    public SiteItem getSiteTree(String url, int depth, String includeByNameRegex, String excludeByNameRegex) {
        return this.getSiteTree(url, depth, includeByNameRegex, excludeByNameRegex, (Map)null);
    }

    @Deprecated
    public SiteItem getSiteTree(String url, int depth, String includeByNameRegex, String excludeByNameRegex, String[] ... nodeXPathAndExpectedValuePairs) {
        HashMap<String, String> nodeXPathAndExpectedValuePairMap = null;
        if (ArrayUtils.isNotEmpty((Object[])nodeXPathAndExpectedValuePairs)) {
            nodeXPathAndExpectedValuePairMap = new HashMap<String, String>();
            for (String[] nodeXPathAndExpectedValuePair : nodeXPathAndExpectedValuePairs) {
                String nodeXPathQuery = nodeXPathAndExpectedValuePair[0];
                String expectedNodeValueRegex = nodeXPathAndExpectedValuePair[1];
                nodeXPathAndExpectedValuePairMap.put(nodeXPathQuery, expectedNodeValueRegex);
            }
        }
        return this.getSiteTree(url, depth, includeByNameRegex, excludeByNameRegex, nodeXPathAndExpectedValuePairMap);
    }

    @Deprecated
    public SiteItem getSiteTree(String url, int depth, String includeByNameRegex, String excludeByNameRegex, Map<String, String> nodeXPathAndExpectedValuePairs) {
        Tree tree;
        CompositeItemFilter compositeFilter = new CompositeItemFilter();
        if (CollectionUtils.isNotEmpty((Collection)this.defaultFilters)) {
            for (ItemFilter itemFilter : this.defaultFilters) {
                compositeFilter.addFilter(itemFilter);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)includeByNameRegex)) {
            compositeFilter.addFilter((ItemFilter)new IncludeByNameItemFilter(includeByNameRegex));
        }
        if (StringUtils.isNotEmpty((CharSequence)excludeByNameRegex)) {
            compositeFilter.addFilter((ItemFilter)new ExcludeByNameItemFilter(excludeByNameRegex));
        }
        if (MapUtils.isNotEmpty(nodeXPathAndExpectedValuePairs)) {
            for (Map.Entry entry : nodeXPathAndExpectedValuePairs.entrySet()) {
                compositeFilter.addFilter((ItemFilter)new ExpectedNodeValueItemFilter((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        if ((tree = this.storeService.findTree(this.getSiteContext().getContext(), null, url, depth, (ItemFilter)compositeFilter, null)) != null) {
            return this.createItemWrapper((Item)tree);
        }
        return null;
    }

    protected SiteContext getSiteContext() {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext == null) {
            throw new IllegalStateException("No current site context found");
        }
        return siteContext;
    }

    protected SiteItem createItemWrapper(Item item) {
        return new SiteItem(item, this.modelFieldConverter, this.sortComparator);
    }
}

