/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.servlet.filter;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.craftercms.engine.http.ExceptionHandler;
import org.springframework.beans.factory.annotation.Required;

public class ExceptionHandlingFilter
implements Filter {
    private List<ExceptionHandler> exceptionHandlers;

    @Required
    public void setExceptionHandlers(List<ExceptionHandler> exceptionHandlers) {
        this.exceptionHandlers = exceptionHandlers;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            this.handleException((HttpServletRequest)request, (HttpServletResponse)response, e);
        }
    }

    public void destroy() {
    }

    protected void handleException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws ServletException, IOException {
        boolean handled = false;
        Iterator iter = this.exceptionHandlers.iterator();
        while (iter.hasNext() && !handled) {
            handled = ((ExceptionHandler)iter.next()).handle(request, response, ex);
        }
        if (!handled) {
            throw new ServletException("Unhandled exception: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

