/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.servlet.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.engine.service.context.SiteContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class SiteAwareCORSFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(SiteAwareCORSFilter.class);
    public static final String CONFIG_KEY = "cors";
    public static final String ENABLE_KEY = "enable";
    public static final String MAX_AGE_KEY = "accessControlMaxAge";
    public static final String ALLOW_ORIGIN_KEY = "accessControlAllowOrigin";
    public static final String ALLOW_METHODS_KEY = "accessControlAllowMethods";
    public static final String ALLOW_HEADERS_KEY = "accessControlAllowHeaders";
    public static final String ALLOW_CREDENTIALS_KEY = "accessControlAllowCredentials";
    public static final String MAX_AGE_DEFAULT = "86400";
    public static final String ALLOW_ORIGIN_DEFAULT = "*";
    public static final String ALLOW_METHODS_DEFAULT = "GET, POST, OPTIONS";
    public static final String ALLOW_HEADERS_DEFAULT = "Content-Type";
    public static final String ALLOW_CREDENTIALS_DEFAULT = "true";

    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        SiteContext siteContext = SiteContext.getCurrent();
        HierarchicalConfiguration config = siteContext.getConfig();
        try {
            HierarchicalConfiguration corsConfig = config.configurationAt(CONFIG_KEY);
            if (corsConfig != null) {
                return !corsConfig.getBoolean(ENABLE_KEY, false);
            }
        }
        catch (Exception e) {
            logger.debug("Site '{}' has no CORS configuration", (Object)siteContext.getSiteName());
        }
        return true;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        SiteContext siteContext = SiteContext.getCurrent();
        HierarchicalConfiguration corsConfig = siteContext.getConfig().configurationAt(CONFIG_KEY);
        response.setHeader("Access-Control-Allow-Origin", corsConfig.getString(ALLOW_ORIGIN_KEY, ALLOW_ORIGIN_DEFAULT));
        response.setHeader("Access-Control-Allow-Credentials", corsConfig.getString(ALLOW_CREDENTIALS_KEY, ALLOW_CREDENTIALS_DEFAULT));
        response.setHeader("Access-Control-Allow-Methods", corsConfig.getString(ALLOW_METHODS_KEY, ALLOW_METHODS_DEFAULT));
        response.setHeader("Access-Control-Allow-Headers", corsConfig.getString(ALLOW_HEADERS_KEY, ALLOW_HEADERS_DEFAULT));
        response.setHeader("Access-Control-Max-Age", corsConfig.getString(MAX_AGE_KEY, MAX_AGE_DEFAULT));
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

